/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.ServiceType;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.FileWriter2;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.spi.NetcdfFileProvider;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.ncml.AggregationIF;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileFactory;

public class NetcdfDataset
extends NetcdfFile {
    private static Logger log = LoggerFactory.getLogger(NetcdfDataset.class);
    private static Set<Enhance> EnhanceAll = Collections.unmodifiableSet(EnumSet.of(Enhance.ConvertEnums, new Enhance[]{Enhance.ConvertUnsigned, Enhance.ApplyScaleOffset, Enhance.ConvertMissing, Enhance.CoordSystems, Enhance.ApplyRuntimeLoadedEnhancements}));
    private static Set<Enhance> EnhanceNone = Collections.unmodifiableSet(EnumSet.noneOf(Enhance.class));
    private static Set<Enhance> defaultEnhanceMode = EnhanceAll;
    protected static boolean fillValueIsMissing = true;
    protected static boolean invalidDataIsMissing = true;
    protected static boolean missingDataIsMissing = true;
    private static FileCache netcdfFileCache;
    private static FileFactory defaultNetcdfFileFactory;
    private NetcdfFile orgFile;
    private List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    private List<CoordinateSystem> coordSys = new ArrayList<CoordinateSystem>();
    private List<CoordinateTransform> coordTransforms = new ArrayList<CoordinateTransform>();
    private String convUsed;
    private Set<Enhance> enhanceMode = EnumSet.noneOf(Enhance.class);
    private AggregationIF agg;

    public static Set<Enhance> getEnhanceAll() {
        return EnhanceAll;
    }

    public static Set<Enhance> getEnhanceNone() {
        return EnhanceNone;
    }

    public static Set<Enhance> getDefaultEnhanceMode() {
        return defaultEnhanceMode;
    }

    public static void setDefaultEnhanceMode(Set<Enhance> mode) {
        defaultEnhanceMode = Collections.unmodifiableSet(mode);
    }

    @Deprecated
    public static Set<Enhance> parseEnhanceMode(String enhanceMode) {
        if (enhanceMode == null) {
            return null;
        }
        switch (enhanceMode.toLowerCase()) {
            case "all": {
                return NetcdfDataset.getEnhanceAll();
            }
            case "none": {
                return NetcdfDataset.getEnhanceNone();
            }
            case "convertenums": {
                return EnumSet.of(Enhance.ConvertEnums);
            }
            case "convertunsigned": {
                return EnumSet.of(Enhance.ConvertUnsigned);
            }
            case "applyscaleoffset": {
                return EnumSet.of(Enhance.ApplyScaleOffset);
            }
            case "convertmissing": {
                return EnumSet.of(Enhance.ConvertMissing);
            }
            case "coordsystems": {
                return EnumSet.of(Enhance.CoordSystems);
            }
            case "incompletecoordsystems": {
                return EnumSet.of(Enhance.CoordSystems, Enhance.IncompleteCoordSystems);
            }
            case "true": {
                return NetcdfDataset.getEnhanceAll();
            }
            case "scalemissingdefer": {
                return NetcdfDataset.getEnhanceNone();
            }
            case "alldefer": {
                return EnumSet.of(Enhance.ConvertEnums, Enhance.CoordSystems);
            }
            case "scalemissing": {
                return EnumSet.of(Enhance.ConvertUnsigned, Enhance.ApplyScaleOffset, Enhance.ConvertMissing);
            }
        }
        return null;
    }

    @Deprecated
    public static void setFillValueIsMissing(boolean b) {
        fillValueIsMissing = b;
    }

    @Deprecated
    public static boolean getFillValueIsMissing() {
        return fillValueIsMissing;
    }

    @Deprecated
    public static void setInvalidDataIsMissing(boolean b) {
        invalidDataIsMissing = b;
    }

    @Deprecated
    public static boolean getInvalidDataIsMissing() {
        return invalidDataIsMissing;
    }

    @Deprecated
    public static void setMissingDataIsMissing(boolean b) {
        missingDataIsMissing = b;
    }

    @Deprecated
    public static boolean getMissingDataIsMissing() {
        return missingDataIsMissing;
    }

    @Deprecated
    public static synchronized void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        NetcdfDataset.initNetcdfFileCache(minElementsInMemory, maxElementsInMemory, -1, period);
    }

    @Deprecated
    public static synchronized void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int hardLimit, int period) {
        netcdfFileCache = new FileCache("NetcdfFileCache (deprecated)", minElementsInMemory, maxElementsInMemory, hardLimit, period);
    }

    @Deprecated
    public static synchronized void disableNetcdfFileCache() {
        if (null != netcdfFileCache) {
            netcdfFileCache.disable();
        }
        netcdfFileCache = null;
    }

    @Deprecated
    public static synchronized void shutdown() {
        NetcdfDataset.disableNetcdfFileCache();
        FileCache.shutdown();
    }

    @Deprecated
    public static synchronized FileCacheIF getNetcdfFileCache() {
        return netcdfFileCache;
    }

    @Deprecated
    public static NetcdfDataset wrap(NetcdfFile ncfile, Set<Enhance> mode) throws IOException {
        NetcdfDataset ncd;
        if (ncfile instanceof NetcdfDataset && !(ncd = (NetcdfDataset)ncfile).enhanceNeeded(mode)) {
            return (NetcdfDataset)ncfile;
        }
        return new NetcdfDataset(ncfile, mode);
    }

    @Deprecated
    public static NetcdfDataset openDataset(String location) throws IOException {
        return NetcdfDataset.openDataset(location, true, null);
    }

    @Deprecated
    public static NetcdfDataset openDataset(String location, boolean enhance, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openDataset(location, enhance, -1, cancelTask, null);
    }

    @Deprecated
    public static NetcdfDataset openDataset(String location, boolean enhance, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDataset.openDataset(durl, enhance ? defaultEnhanceMode : null, buffer_size, cancelTask, spiObject);
    }

    @Deprecated
    public static NetcdfDataset openDataset(DatasetUrl location, Set<Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        NetcdfDataset ds;
        NetcdfFile ncfile = NetcdfDataset.openProtocolOrFile(location, buffer_size, cancelTask, spiObject);
        if (ncfile instanceof NetcdfDataset) {
            ds = (NetcdfDataset)ncfile;
            NetcdfDataset.enhance(ds, enhanceMode, cancelTask);
        } else {
            ds = new NetcdfDataset(ncfile, enhanceMode);
        }
        return ds;
    }

    @Deprecated
    private static CoordSysBuilderIF enhance(NetcdfDataset ds, Set<Enhance> mode, CancelTask cancelTask) throws IOException {
        if (mode == null) {
            mode = EnumSet.noneOf(Enhance.class);
        }
        CoordSysBuilderIF builder = null;
        if (mode.contains((Object)Enhance.CoordSystems) && !ds.enhanceMode.contains((Object)Enhance.CoordSystems)) {
            builder = CoordSysBuilder.factory(ds, cancelTask);
            builder.augmentDataset(ds, cancelTask);
            ds.convUsed = builder.getConventionUsed();
        }
        if (mode.contains((Object)Enhance.ConvertEnums) && !ds.enhanceMode.contains((Object)Enhance.ConvertEnums) || mode.contains((Object)Enhance.ConvertUnsigned) && !ds.enhanceMode.contains((Object)Enhance.ConvertUnsigned) || mode.contains((Object)Enhance.ApplyScaleOffset) && !ds.enhanceMode.contains((Object)Enhance.ApplyScaleOffset) || mode.contains((Object)Enhance.ConvertMissing) && !ds.enhanceMode.contains((Object)Enhance.ConvertMissing)) {
            for (Variable v : ds.getVariables()) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                ve.enhance(mode);
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return null;
            }
        }
        if (builder != null) {
            if (mode.contains((Object)Enhance.IncompleteCoordSystems)) {
                ds.addEnhanceMode(Enhance.IncompleteCoordSystems);
                builder.buildCoordinateSystems(ds);
                ds.removeEnhanceMode(Enhance.IncompleteCoordSystems);
            } else {
                builder.buildCoordinateSystems(ds);
            }
        }
        ds.finish();
        ds.addEnhanceModes(mode);
        return builder;
    }

    @Deprecated
    public static NetcdfDataset acquireDataset(DatasetUrl location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireDataset(null, location, defaultEnhanceMode, -1, cancelTask, null);
    }

    @Deprecated
    public static NetcdfDataset acquireDataset(DatasetUrl location, boolean enhanceMode, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireDataset(null, location, enhanceMode ? defaultEnhanceMode : null, -1, cancelTask, null);
    }

    @Deprecated
    public static NetcdfDataset acquireDataset(DatasetUrl location, Set<Enhance> enhanceMode, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireDataset(null, location, enhanceMode, -1, cancelTask, null);
    }

    @Deprecated
    public static NetcdfDataset acquireDataset(FileFactory fac, DatasetUrl durl, Set<Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        if (netcdfFileCache == null) {
            if (fac == null) {
                return NetcdfDataset.openDataset(durl, enhanceMode, buffer_size, cancelTask, iospMessage);
            }
            return (NetcdfDataset)fac.open(durl, buffer_size, cancelTask, iospMessage);
        }
        if (fac != null) {
            return (NetcdfDataset)NetcdfDataset.openOrAcquireFile(netcdfFileCache, fac, null, durl, buffer_size, cancelTask, iospMessage);
        }
        fac = new StandardDatasetFactory(durl, enhanceMode);
        return (NetcdfDataset)NetcdfDataset.openOrAcquireFile(netcdfFileCache, fac, fac.hashCode(), durl, buffer_size, cancelTask, iospMessage);
    }

    @Deprecated
    public static NetcdfFile openFile(String location, CancelTask cancelTask) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDataset.openProtocolOrFile(durl, -1, cancelTask, null);
    }

    @Deprecated
    public static NetcdfFile openFile(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDataset.openProtocolOrFile(location, buffer_size, cancelTask, spiObject);
    }

    @Deprecated
    public static NetcdfFile acquireFile(DatasetUrl location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireFile(null, null, location, -1, cancelTask, null);
    }

    @Deprecated
    public static NetcdfFile acquireFile(FileFactory factory, Object hashKey, DatasetUrl location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (netcdfFileCache == null && factory != null) {
            return (NetcdfFile)factory.open(location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfDataset.openOrAcquireFile(netcdfFileCache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openOrAcquireFile(FileCache cache, FileFactory factory, Object hashKey, DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (factory == null) {
            factory = defaultNetcdfFileFactory;
        }
        if (cache != null) {
            return (NetcdfFile)cache.acquire(factory, hashKey, durl, buffer_size, cancelTask, spiObject);
        }
        return (NetcdfFile)factory.open(durl, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openProtocolOrFile(DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (durl.getServiceType() == ServiceType.NCML) {
            return NcMLReader.readNcML(durl.getTrueurl(), cancelTask);
        }
        for (NetcdfFileProvider provider : ServiceLoader.load(NetcdfFileProvider.class)) {
            if (!provider.isOwnerOf(durl)) continue;
            return provider.open(durl.getTrueurl(), cancelTask);
        }
        for (NetcdfFileProvider provider : ServiceLoader.load(NetcdfFileProvider.class)) {
            if (!provider.isOwnerOf(durl.getTrueurl())) continue;
            return provider.open(durl.getTrueurl(), cancelTask);
        }
        if (durl.getServiceType() != null) {
            switch (durl.getServiceType()) {
                case File: 
                case HTTPServer: {
                    break;
                }
                default: {
                    throw new IOException("Unknown service type: " + (Object)((Object)durl.serviceType));
                }
            }
        }
        return NetcdfFile.open(durl.getTrueurl(), buffer_size, cancelTask, spiObject);
    }

    @Deprecated
    public AggregationIF getAggregation() {
        return this.agg;
    }

    @Deprecated
    public void setAggregation(AggregationIF agg) {
        this.agg = agg;
    }

    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return ImmutableList.copyOf(this.coordSys);
    }

    public String getConventionUsed() {
        return this.convUsed;
    }

    public Set<Enhance> getEnhanceMode() {
        return this.enhanceMode;
    }

    private void addEnhanceModes(Set<Enhance> addEnhanceModes) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        result.addAll(this.enhanceMode);
        result.addAll(addEnhanceModes);
        this.enhanceMode = result.build();
    }

    private void addEnhanceMode(Enhance addEnhanceMode) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        result.addAll(this.enhanceMode);
        result.add((Object)addEnhanceMode);
        this.enhanceMode = result.build();
    }

    private void removeEnhanceMode(Enhance removeEnhanceMode) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        this.enhanceMode.stream().filter(e -> !e.equals((Object)removeEnhanceMode)).forEach(result::add);
        this.enhanceMode = result.build();
    }

    public ImmutableList<CoordinateTransform> getCoordinateTransforms() {
        return ImmutableList.copyOf(this.coordTransforms);
    }

    public ImmutableList<CoordinateAxis> getCoordinateAxes() {
        return ImmutableList.copyOf(this.coordAxes);
    }

    @Deprecated
    public void clearCoordinateSystems() {
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        for (Variable v : this.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            ve.clearCoordinateSystems();
        }
        this.removeEnhanceMode(Enhance.CoordSystems);
    }

    public CoordinateAxis findCoordinateAxis(AxisType type) {
        if (type == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            if (type != v.getAxisType()) continue;
            return v;
        }
        return null;
    }

    public CoordinateAxis findCoordinateAxis(String fullName) {
        if (fullName == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            if (!fullName.equals(v.getFullName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateSystem findCoordinateSystem(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateSystem v : this.coordSys) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateTransform findCoordinateTransform(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateTransform v : this.coordTransforms) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.agg != null) {
            this.agg.persistWrite();
            this.agg.close();
        }
        if (this.cache != null && this.cache.release(this)) {
            return;
        }
        if (this.orgFile != null) {
            this.orgFile.close();
        }
        this.orgFile = null;
    }

    @Override
    @Deprecated
    public void release() throws IOException {
        if (this.orgFile != null) {
            this.orgFile.release();
        }
    }

    @Override
    @Deprecated
    public void reacquire() throws IOException {
        if (this.orgFile != null) {
            this.orgFile.reacquire();
        }
    }

    @Override
    public long getLastModified() {
        if (this.agg != null) {
            return this.agg.getLastModified();
        }
        return this.orgFile != null ? this.orgFile.getLastModified() : 0L;
    }

    @Override
    @Deprecated
    public void empty() {
        super.empty();
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        this.convUsed = null;
    }

    @Override
    @Deprecated
    public boolean syncExtend() throws IOException {
        boolean wasExtended;
        if (this.agg != null) {
            return this.agg.syncExtend();
        }
        if (this.orgFile != null && (wasExtended = this.orgFile.syncExtend())) {
            Dimension ndim = this.orgFile.getUnlimitedDimension();
            int newLength = ndim.getLength();
            Dimension udim = this.getUnlimitedDimension();
            udim.setLength(newLength);
            for (Variable v : this.getVariables()) {
                if (!v.isUnlimited()) continue;
                v.setDimensions(v.getDimensions());
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public NetcdfDataset(NetcdfFile ncfile) throws IOException {
        this(ncfile, defaultEnhanceMode);
    }

    @Deprecated
    public NetcdfDataset(NetcdfFile ncfile, boolean enhance) throws IOException {
        this(ncfile, enhance ? defaultEnhanceMode : null);
    }

    @Deprecated
    public NetcdfDataset(NetcdfFile ncfile, Set<Enhance> mode) throws IOException {
        super(ncfile);
        this.orgFile = ncfile;
        this.iosp = null;
        this.convertGroup(this.getRootGroup(), ncfile.getRootGroup());
        this.finish();
        NetcdfDataset.enhance(this, mode, null);
    }

    private void convertGroup(Group g, Group from) {
        for (EnumTypedef et : from.getEnumTypedefs()) {
            g.addEnumeration(et);
        }
        for (Dimension d : from.getDimensions()) {
            g.addDimension(new Dimension(d.getShortName(), d));
        }
        for (Attribute a : from.attributes()) {
            g.addAttribute(a);
        }
        for (Variable v : from.getVariables()) {
            g.addVariable(this.convertVariable(g, v));
        }
        for (Group nested : from.getGroups()) {
            Group nnested = new Group(this, g, nested.getShortName());
            g.addGroup(nnested);
            this.convertGroup(nnested, nested);
        }
    }

    private Variable convertVariable(Group g, Variable v) {
        Variable newVar = v instanceof Sequence ? new SequenceDS(g, (Sequence)v) : (v instanceof Structure ? new StructureDS(g, (Structure)v) : new VariableDS(g, v, false));
        return newVar;
    }

    @Override
    @Deprecated
    protected Boolean makeRecordStructure() {
        if (this.orgFile == null) {
            return false;
        }
        Boolean hasRecord = (Boolean)this.orgFile.sendIospMessage("AddRecordStructure");
        if (hasRecord == null || !hasRecord.booleanValue()) {
            return false;
        }
        Variable orgV = this.orgFile.getRootGroup().findVariableLocal("record");
        if (!(orgV instanceof Structure)) {
            return false;
        }
        Structure orgStructure = (Structure)orgV;
        Dimension udim = this.getUnlimitedDimension();
        if (udim == null) {
            return false;
        }
        Group root = this.getRootGroup();
        StructureDS newStructure = new StructureDS(this, root, null, "record", udim.getShortName(), null, null);
        newStructure.setOriginalVariable(orgStructure);
        for (Variable v : this.getVariables()) {
            VariableDS memberV;
            if (!v.isUnlimited()) continue;
            try {
                memberV = (VariableDS)v.slice(0, 0);
            }
            catch (InvalidRangeException e) {
                log.error("Cant slice variable " + v);
                return false;
            }
            memberV.setParentStructure(newStructure);
            newStructure.addMemberVariable(memberV);
        }
        root.addVariable(newStructure);
        this.finish();
        return true;
    }

    @Deprecated
    public void sort() {
        this.variables.sort(new VariableComparator());
        this.coordAxes.sort(new VariableComparator());
    }

    @Deprecated
    public NetcdfDataset() {
    }

    @Deprecated
    public NetcdfFile getReferencedFile() {
        return this.orgFile;
    }

    @Override
    @Deprecated
    public IOServiceProvider getIosp() {
        return this.orgFile == null ? null : this.orgFile.getIosp();
    }

    @Deprecated
    public void setReferencedFile(NetcdfFile ncfile) {
        this.orgFile = ncfile;
    }

    @Override
    protected String toStringDebug(Object o) {
        return "";
    }

    @Deprecated
    public void addCoordinateSystem(CoordinateSystem cs) {
        this.coordSys.add(cs);
    }

    @Deprecated
    public void addCoordinateTransform(CoordinateTransform ct) {
        if (!this.coordTransforms.contains(ct)) {
            this.coordTransforms.add(ct);
        }
    }

    @Deprecated
    public CoordinateAxis addCoordinateAxis(VariableDS v) {
        if (v == null) {
            return null;
        }
        ArrayList<CoordinateAxis> coordCopy = new ArrayList<CoordinateAxis>(this.coordAxes);
        CoordinateAxis oldVar = this.findCoordinateAxis(v.getFullName());
        if (oldVar != null) {
            coordCopy.remove(oldVar);
        }
        CoordinateAxis ca = v instanceof CoordinateAxis ? (CoordinateAxis)v : CoordinateAxis.factory(this, v);
        coordCopy.add(ca);
        this.coordAxes = coordCopy;
        if (v.isMemberOfStructure()) {
            Structure parentOrg = v.getParentStructure();
            Structure parent = (Structure)this.findVariable(parentOrg.getFullNameEscaped());
            parent.replaceMemberVariable(ca);
        } else {
            this.removeVariable(v.getParentGroup(), v.getShortName());
            this.addVariable(ca.getParentGroup(), ca);
        }
        return ca;
    }

    @Override
    @Deprecated
    public Variable addVariable(Group g, Variable v) {
        if (!(v instanceof VariableDS) && !(v instanceof StructureDS)) {
            throw new IllegalArgumentException("NetcdfDataset variables must be VariableEnhanced objects");
        }
        return super.addVariable(g, v);
    }

    @Deprecated
    public CoordSysBuilderIF enhance() throws IOException {
        return NetcdfDataset.enhance(this, defaultEnhanceMode, null);
    }

    @Deprecated
    public void enhance(Set<Enhance> mode) throws IOException {
        NetcdfDataset.enhance(this, mode, null);
    }

    @Deprecated
    public boolean enhanceNeeded(Set<Enhance> want) {
        if (want == null) {
            return false;
        }
        for (Enhance mode : want) {
            if (this.enhanceMode.contains((Object)mode)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setValues(Variable v, int npts, double start, double incr) {
        if ((long)npts != v.getSize()) {
            throw new IllegalArgumentException("bad npts = " + npts + " should be " + v.getSize());
        }
        Array data = Array.makeArray(v.getDataType(), npts, start, incr);
        if (v.getRank() != 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    @Deprecated
    public void setValues(Variable v, List<String> values) throws IllegalArgumentException {
        Array data = Array.makeArray(v.getDataType(), values);
        if (data.getSize() != v.getSize()) {
            throw new IllegalArgumentException("Incorrect number of values specified for the Variable " + v.getFullName() + " needed= " + v.getSize() + " given=" + data.getSize());
        }
        if (v.getRank() != 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    @Deprecated
    public static Array makeArray(DataType dtype, List<String> stringValues) throws NumberFormatException {
        return Array.makeArray(dtype, stringValues);
    }

    @Override
    public void getDetailInfo(Formatter f) {
        f.format("NetcdfDataset location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.agg == null) {
            f.format("  has no Aggregation element%n", new Object[0]);
        } else {
            f.format("%nAggregation:%n", new Object[0]);
            this.agg.getDetailInfo(f);
        }
        if (this.orgFile == null) {
            f.format("  has no referenced NetcdfFile%n", new Object[0]);
            this.showCached(f);
            this.showProxies(f);
        } else {
            f.format("%nReferenced File:%n", new Object[0]);
            f.format("%s", this.orgFile.getDetailInfo());
        }
    }

    private void dumpClasses(Group g, PrintWriter out) {
        out.println("Dimensions:");
        for (Dimension ds : g.getDimensions()) {
            out.println("  " + ds.getShortName() + " " + ds.getClass().getName());
        }
        out.println("Atributes:");
        for (Attribute a : g.attributes()) {
            out.println("  " + a.getShortName() + " " + a.getClass().getName());
        }
        out.println("Variables:");
        this.dumpVariables(g.getVariables(), out);
        out.println("Groups:");
        for (Group nested : g.getGroups()) {
            out.println("  " + nested.getFullName() + " " + nested.getClass().getName());
            this.dumpClasses(nested, out);
        }
    }

    private void dumpVariables(List<Variable> vars, PrintWriter out) {
        for (Variable v : vars) {
            out.print("  " + v.getFullName() + " " + v.getClass().getName());
            if (v instanceof CoordinateAxis) {
                out.println("  " + (Object)((Object)((CoordinateAxis)v).getAxisType()));
            } else {
                out.println();
            }
            if (!(v instanceof Structure)) continue;
            this.dumpVariables(((Structure)v).getVariables(), out);
        }
    }

    @Deprecated
    public static void debugDump(PrintWriter out, NetcdfDataset ncd) {
        String referencedLocation = ncd.orgFile == null ? "(null)" : ncd.orgFile.getLocation();
        out.println("\nNetcdfDataset dump = " + ncd.getLocation() + " url= " + referencedLocation + "\n");
        ncd.dumpClasses(ncd.getRootGroup(), out);
    }

    @Override
    public String getFileTypeId() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeId();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeId();
        }
        return "N/A";
    }

    @Override
    public String getFileTypeDescription() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeDescription();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeDescription();
        }
        return "N/A";
    }

    @Deprecated
    public void check(Formatter f) {
        for (Variable v : this.getVariables()) {
            Variable orgVar;
            VariableDS vds = (VariableDS)v;
            if (vds.getOriginalDataType() != vds.getDataType()) {
                f.format("Variable %s has type %s, org = %s%n", new Object[]{vds.getFullName(), vds.getOriginalDataType(), vds.getDataType()});
            }
            if ((orgVar = vds.getOriginalVariable()) == null || orgVar.getRank() == vds.getRank()) continue;
            f.format("Variable %s has rank %d, org = %d%n", vds.getFullName(), vds.getRank(), orgVar.getRank());
        }
    }

    private NetcdfDataset(Builder<?> builder) {
        super(builder);
        this.orgFile = builder.orgFile;
        this.convUsed = ((Builder)builder).convUsed;
        this.enhanceMode = builder.getEnhanceMode();
        this.agg = builder.agg;
        CoordinatesHelper coords = builder.coords.build(this);
        this.coordAxes = coords.getCoordAxes();
        this.coordSys = coords.getCoordSystems();
        this.coordTransforms = coords.getCoordTransforms();
        for (Variable v : this.variables) {
            if (!(v instanceof VariableDS)) continue;
            VariableDS vds = (VariableDS)v;
            vds.setCoordinateSystems(coords);
        }
        this.finish();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(NetcdfDataset.builder());
    }

    @Deprecated
    public NetcdfDataset(NetcdfFile.Builder<?> builder) {
        super(builder);
        this.finish();
    }

    private Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        this.coordAxes.forEach(axis -> b.coords.addCoordinateAxis((CoordinateAxis.Builder)axis.toBuilder()));
        this.coordSys.forEach(sys -> b.coords.addCoordinateSystem(sys.toBuilder()));
        this.coordTransforms.forEach(trans -> b.coords.addCoordinateTransform(trans.toBuilder()));
        ((Builder)((Builder)b.setOrgFile(this).setConventionUsed(this.convUsed)).setEnhanceMode(this.enhanceMode)).setAggregation(this.agg);
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static Builder builder(NetcdfFile from) {
        Object builder = ((Builder)NetcdfDataset.builder().copyFrom(from)).setOrgFile(from);
        return builder;
    }

    @Deprecated
    public static void main(String[] arg) throws IOException {
        String usage = "usage: ucar.nc2.dataset.NetcdfDataset -in <fileIn> -out <fileOut> [-isLargeFile] [-netcdf4]";
        if (arg.length < 4) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean isLargeFile = false;
        boolean netcdf4 = false;
        String datasetIn = null;
        String datasetOut = null;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-out")) {
                datasetOut = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-isLargeFile")) {
                isLargeFile = true;
            }
            if (!s.equalsIgnoreCase("-netcdf4")) continue;
            netcdf4 = true;
        }
        if (datasetIn == null || datasetOut == null) {
            System.out.println(usage);
            System.exit(0);
        }
        CancelTask cancel = CancelTask.create();
        NetcdfFile ncfileIn = NetcdfDataset.openFile(datasetIn, cancel);
        System.out.printf("NetcdfDatataset read from %s write to %s ", datasetIn, datasetOut);
        NetcdfFileWriter.Version version = netcdf4 ? NetcdfFileWriter.Version.netcdf4 : NetcdfFileWriter.Version.netcdf3;
        FileWriter2 writer = new FileWriter2(ncfileIn, datasetOut, version, null);
        writer.getNetcdfFileWriter().setLargeFile(isLargeFile);
        NetcdfFile ncfileOut = writer.write(cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        ncfileIn.close();
        cancel.setDone(true);
        System.out.printf("%s%n", cancel);
    }

    static {
        defaultNetcdfFileFactory = new StandardFileFactory();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NetcdfFile.Builder<T> {
        @Nullable
        public NetcdfFile orgFile;
        public CoordinatesHelper.Builder coords = CoordinatesHelper.builder();
        private String convUsed;
        private Set<Enhance> enhanceMode = EnumSet.noneOf(Enhance.class);
        public AggregationIF agg;
        private boolean built;

        @Override
        protected abstract T self();

        public void replaceCoordinateAxis(Group.Builder group, CoordinateAxis.Builder axis) {
            if (axis == null) {
                return;
            }
            this.coords.replaceCoordinateAxis(axis);
            group.replaceVariable(axis);
            axis.setParentGroupBuilder(group);
        }

        public T setOrgFile(NetcdfFile orgFile) {
            this.orgFile = orgFile;
            return (T)this.self();
        }

        public T setConventionUsed(String convUsed) {
            this.convUsed = convUsed;
            return (T)this.self();
        }

        public T setEnhanceMode(Set<Enhance> enhanceMode) {
            this.enhanceMode = enhanceMode;
            return (T)this.self();
        }

        public T setDefaultEnhanceMode() {
            this.enhanceMode = NetcdfDataset.getDefaultEnhanceMode();
            return (T)this.self();
        }

        public Set<Enhance> getEnhanceMode() {
            return this.enhanceMode;
        }

        public void addEnhanceMode(Enhance addEnhanceMode) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            result.addAll(this.enhanceMode);
            result.add((Object)addEnhanceMode);
            this.enhanceMode = result.build();
        }

        public void removeEnhanceMode(Enhance removeEnhanceMode) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            this.enhanceMode.stream().filter(e -> !e.equals((Object)removeEnhanceMode)).forEach(result::add);
            this.enhanceMode = result.build();
        }

        public void addEnhanceModes(Set<Enhance> addEnhanceModes) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            result.addAll(this.enhanceMode);
            result.addAll(addEnhanceModes);
            this.enhanceMode = result.build();
        }

        public T setAggregation(AggregationIF agg) {
            this.agg = agg;
            return (T)this.self();
        }

        public T copyFrom(NetcdfFile orgFile) {
            this.setLocation(orgFile.getLocation());
            this.setId(orgFile.getId());
            this.setTitle(orgFile.getTitle());
            Group.Builder root = Group.builder().setName("");
            this.convertGroup(root, orgFile.getRootGroup());
            this.setRootGroup(root);
            return (T)this.self();
        }

        private void convertGroup(Group.Builder g, Group from) {
            g.setName(from.getShortName());
            g.addEnumTypedefs(from.getEnumTypedefs());
            for (Dimension d : from.getDimensions()) {
                g.addDimension(d.toBuilder().build());
            }
            g.addAttributes(from.attributes());
            for (Variable v : from.getVariables()) {
                g.addVariable(this.convertVariable(g, v));
            }
            for (Group nested : from.getGroups()) {
                Group.Builder nnested = Group.builder();
                g.addGroup(nnested);
                this.convertGroup(nnested, nested);
            }
        }

        private Variable.Builder<?> convertVariable(Group.Builder g, Variable v) {
            Object newVar = v instanceof Sequence ? SequenceDS.builder().copyFrom((Sequence)v) : (v instanceof Structure ? StructureDS.builder().copyFrom((Structure)v) : VariableDS.builder().copyFrom(v));
            ((Variable.Builder)newVar).setParentGroupBuilder(g);
            return newVar;
        }

        @Override
        public NetcdfDataset build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new NetcdfDataset(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    private static class VariableComparator
    implements Comparator {
        private VariableComparator() {
        }

        public int compare(Object o1, Object o2) {
            String cs2;
            VariableEnhanced v1 = (VariableEnhanced)o1;
            VariableEnhanced v2 = (VariableEnhanced)o2;
            List<CoordinateSystem> list1 = v1.getCoordinateSystems();
            String cs1 = !list1.isEmpty() ? list1.get(0).getName() : "";
            List<CoordinateSystem> list2 = v2.getCoordinateSystems();
            String string = cs2 = !list2.isEmpty() ? list2.get(0).getName() : "";
            if (cs2.equals(cs1)) {
                return v1.getShortName().compareToIgnoreCase(v2.getShortName());
            }
            return cs1.compareToIgnoreCase(cs2);
        }
    }

    private static class StandardDatasetFactory
    implements FileFactory {
        DatasetUrl location;
        EnumSet<Enhance> enhanceMode;

        StandardDatasetFactory(DatasetUrl location, Set<Enhance> enhanceMode) {
            this.location = location;
            this.enhanceMode = enhanceMode == null ? EnumSet.noneOf(Enhance.class) : EnumSet.copyOf(enhanceMode);
        }

        @Override
        public NetcdfFile open(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openDataset(location, this.enhanceMode, buffer_size, cancelTask, iospMessage);
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result += 37 * result + this.enhanceMode.hashCode();
            return result;
        }
    }

    private static class StandardFileFactory
    implements FileFactory {
        private StandardFileFactory() {
        }

        @Override
        public NetcdfFile open(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openFile(location, buffer_size, cancelTask, iospMessage);
        }
    }

    public static enum Enhance {
        ConvertEnums,
        ConvertUnsigned,
        ApplyScaleOffset,
        ConvertMissing,
        CoordSystems,
        IncompleteCoordSystems,
        ApplyRuntimeLoadedEnhancements;

    }
}

