/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.CSMConvention;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class CF1Convention
extends CSMConvention {
    private static final String convName = "CF-1.";
    private static final String[] vertical_coords = new String[]{"atmosphere_ln_pressure_coordinate", "atmosphere_sigma_coordinate", "atmosphere_hybrid_sigma_pressure_coordinate", "atmosphere_hybrid_height_coordinate", "atmosphere_sleve_coordinate", "ocean_sigma_coordinate", "ocean_s_coordinate", "ocean_sigma_z_coordinate", "ocean_double_sigma_coordinate", "ocean_s_coordinate_g1", "ocean_s_coordinate_g2"};
    private boolean avhrr_oiv2;

    public static int getVersion(String hasConvName) {
        int result = CF1Convention.extractVersion(hasConvName);
        if (result >= 0) {
            return result;
        }
        List<String> names = CF1Convention.breakupConventionNames(hasConvName);
        for (String name : names) {
            result = CF1Convention.extractVersion(name);
            if (result < 0) continue;
            return result;
        }
        return -1;
    }

    private static int extractVersion(String hasConvName) {
        if (!hasConvName.startsWith(convName)) {
            return -1;
        }
        String versionS = hasConvName.substring(convName.length());
        try {
            return Integer.parseInt(versionS);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getZisPositive(String zaxisName, String vertCoordUnits) {
        if (vertCoordUnits == null) {
            return "up";
        }
        if (vertCoordUnits.isEmpty()) {
            return "up";
        }
        if (SimpleUnit.isCompatible("millibar", vertCoordUnits)) {
            return "down";
        }
        if (SimpleUnit.isCompatible("m", vertCoordUnits)) {
            return "up";
        }
        return "up";
    }

    public CF1Convention() {
        this.conventionName = "CF-1.X";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        String src;
        boolean got_grid_mapping = false;
        ImmutableList<Variable> vars = ds.getVariables();
        for (Variable v : vars) {
            String grid_mapping;
            String sname = ds.findAttValueIgnoreCase(v, "standard_name", null);
            if (sname != null) {
                if ((sname = sname.trim()).equalsIgnoreCase("atmosphere_ln_pressure_coordinate")) {
                    this.makeAtmLnCoordinate(ds, v);
                    continue;
                }
                if (sname.equalsIgnoreCase("forecast_reference_time")) {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RunTime.toString()));
                    continue;
                }
                if (sname.equalsIgnoreCase("forecast_period")) {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
                    continue;
                }
                if (sname.equalsIgnoreCase("time")) {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                }
                if (sname.equalsIgnoreCase("ensemble") || sname.equalsIgnoreCase("realization")) {
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
                    continue;
                }
                for (String vertical_coord : vertical_coords) {
                    if (!sname.equalsIgnoreCase(vertical_coord)) continue;
                    v.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Vertical.toString()));
                    if (v.findAttribute("_CoordinateAxes") != null) continue;
                    v.addAttribute(new Attribute("_CoordinateAxes", v.getFullName()));
                }
                this.checkTimeVarForCalendar(v);
            }
            if ((grid_mapping = ds.findAttValueIgnoreCase(v, "grid_mapping", null)) != null) {
                Variable gridMap = ds.findVariable(grid_mapping);
                if (gridMap == null) {
                    Group g = v.getParentGroupOrRoot();
                    gridMap = g.findVariableLocal(grid_mapping);
                }
                if (gridMap != null) {
                    gridMap.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Projection.toString()));
                    String grid_mapping_name = ds.findAttValueIgnoreCase(gridMap, "grid_mapping_name", null);
                    if ("latitude_longitude".equals(grid_mapping_name)) {
                        gridMap.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.Lat) + " " + (Object)((Object)AxisType.Lon)));
                    } else {
                        gridMap.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.GeoX) + " " + (Object)((Object)AxisType.GeoY)));
                    }
                    Attribute productionLocation = ds.findGlobalAttributeIgnoreCase("production_location");
                    Attribute icdVersion = ds.findGlobalAttributeIgnoreCase("ICD_version");
                    if (productionLocation != null && icdVersion != null) {
                        this.correctGoes16(productionLocation, icdVersion, gridMap);
                    }
                    got_grid_mapping = true;
                }
            }
            if (ds.findGlobalAttribute("Conventions") == null || CF1Convention.getVersion(ds.findGlobalAttribute("Conventions").getStringValue()) < 8 || v.findAttribute("geometry") == null) continue;
            Attribute container = v.findAttribute("geometry");
            Variable coordsvar = ds.findVariable(container.getStringValue());
            v.addAttribute(new Attribute("geometry_type", ds.findAttValueIgnoreCase(coordsvar, "geometry_type", "")));
            if (!ds.findAttValueIgnoreCase(coordsvar, "nodes", "").equals("")) {
                v.addAttribute(new Attribute("nodes", ds.findAttValueIgnoreCase(coordsvar, "nodes", "")));
            }
            if (!ds.findAttValueIgnoreCase(coordsvar, "node_count", "").equals("")) {
                v.addAttribute(new Attribute("node_count", ds.findAttValueIgnoreCase(coordsvar, "node_count", "")));
            }
            v.addAttribute(new Attribute("node_coordinates", ds.findAttValueIgnoreCase(coordsvar, "node_coordinates", "")));
            v.addAttribute(new Attribute("part_node_count", ds.findAttValueIgnoreCase(coordsvar, "part_node_count", "")));
            if ("polygon".equalsIgnoreCase(ds.findAttValueIgnoreCase(coordsvar, "geometry_type", "")) && !ds.findAttValueIgnoreCase(coordsvar, "interior_ring", "").equals("")) {
                v.addAttribute(new Attribute("interior_ring", ds.findAttValueIgnoreCase(coordsvar, "interior_ring", "")));
            }
            if (v.findAttribute("node_coordinates") == null) continue;
            String[] coords = ds.findAttValueIgnoreCase(coordsvar, "node_coordinates", "").split(" ");
            String cds = "";
            for (String coord : coords) {
                Attribute axis;
                Variable temp = ds.findVariable(coord);
                if (temp == null || (axis = temp.findAttribute("axis")) == null) continue;
                if ("x".equalsIgnoreCase(axis.getStringValue())) {
                    temp.addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryX.toString()));
                }
                if ("y".equalsIgnoreCase(axis.getStringValue())) {
                    temp.addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryY.toString()));
                }
                if ("z".equalsIgnoreCase(axis.getStringValue())) {
                    temp.addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryZ.toString()));
                }
                cds = cds + coord + " ";
            }
            List dims = v.getDimensions();
            String pre = "";
            for (Dimension di : dims) {
                if (!di.getShortName().equals("time") && ds.findVariable(di.getFullNameEscaped()) != null) {
                    ds.findVariable(di.getFullNameEscaped()).addAttribute(new Attribute("_CoordinateAxisType", AxisType.SimpleGeometryID.toString()));
                }
                pre = di.getShortName() + " " + pre;
            }
            v.addAttribute(new Attribute("_CoordinateAxes", pre + cds.trim()));
        }
        if (!got_grid_mapping) {
            for (Variable v : ds.getVariables()) {
                String grid_mapping_name = ds.findAttValueIgnoreCase(v, "grid_mapping_name", null);
                if (grid_mapping_name == null) continue;
                v.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Projection.toString()));
                if (grid_mapping_name.equals("latitude_longitude")) {
                    v.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.Lat) + " " + (Object)((Object)AxisType.Lon)));
                    continue;
                }
                v.addAttribute(new Attribute("_CoordinateAxisTypes", (Object)((Object)AxisType.GeoX) + " " + (Object)((Object)AxisType.GeoY)));
            }
        }
        if ((src = ds.findAttValueIgnoreCase(null, "Source", "")).equals("NOAA/National Climatic Data Center")) {
            String title = ds.findAttValueIgnoreCase(null, "title", "");
            this.avhrr_oiv2 = title.indexOf("OI-V2") > 0;
        }
        ds.finish();
    }

    private void makeAtmLnCoordinate(NetcdfDataset ds, Variable v) {
        String msg;
        String formula = ds.findAttValueIgnoreCase(v, "formula_terms", null);
        if (null == formula) {
            String msg2 = " Need attribute 'formula_terms' on Variable " + v.getFullName() + "\n";
            this.parseInfo.format(msg2, new Object[0]);
            this.userAdvice.format(msg2, new Object[0]);
            return;
        }
        Variable p0Var = null;
        Variable levelVar = null;
        StringTokenizer stoke = new StringTokenizer(formula, " :");
        while (stoke.hasMoreTokens()) {
            String name;
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("p0")) {
                name = stoke.nextToken();
                p0Var = ds.findVariable(name);
                continue;
            }
            if (!toke.equalsIgnoreCase("lev")) continue;
            name = stoke.nextToken();
            levelVar = ds.findVariable(name);
        }
        if (null == p0Var) {
            msg = " Need p0:varName on Variable " + v.getFullName() + " formula_terms\n";
            this.parseInfo.format(msg, new Object[0]);
            this.userAdvice.format(msg, new Object[0]);
            return;
        }
        if (null == levelVar) {
            msg = " Need lev:varName on Variable " + v.getFullName() + " formula_terms\n";
            this.parseInfo.format(msg, new Object[0]);
            this.userAdvice.format(msg, new Object[0]);
            return;
        }
        String units = ds.findAttValueIgnoreCase(p0Var, "units", "hPa");
        try {
            double p0 = p0Var.readScalarDouble();
            Array levelData = levelVar.read();
            Array pressureData = Array.factory(DataType.DOUBLE, levelData.getShape());
            IndexIterator ii = levelData.getIndexIterator();
            IndexIterator iip = pressureData.getIndexIterator();
            while (ii.hasNext()) {
                double val = p0 * Math.exp(-1.0 * ii.getDoubleNext());
                iip.setDoubleNext(val);
            }
            CoordinateAxis1D p = new CoordinateAxis1D(ds, null, v.getShortName() + "_pressure", DataType.DOUBLE, levelVar.getDimensionsString(), units, "Vertical Pressure coordinate synthesized from atmosphere_ln_pressure_coordinate formula");
            p.setCachedData(pressureData, false);
            p.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            p.addAttribute(new Attribute("_CoordinateAliasForDimension", p.getDimensionsString()));
            ds.addVariable(null, p);
            this.parseInfo.format(" added Vertical Pressure coordinate %s from CF-1 %s%n", p.getFullName(), "atmosphere_ln_pressure_coordinate");
        }
        catch (IOException e) {
            String msg3 = " Unable to read variables from " + v.getFullName() + " formula_terms\n";
            this.parseInfo.format(msg3, new Object[0]);
            this.userAdvice.format(msg3, new Object[0]);
        }
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        String axis;
        AxisType at;
        String sname = ncDataset.findAttValueIgnoreCase((Variable)((Object)v), "standard_name", null);
        if (sname != null) {
            sname = sname.trim();
            for (String vertical_coord : vertical_coords) {
                if (!sname.equalsIgnoreCase(vertical_coord)) continue;
                return AxisType.GeoZ;
            }
        }
        if ((at = super.getAxisType(ncDataset, v)) != null) {
            return at;
        }
        if (sname != null) {
            if (sname.equalsIgnoreCase("realization")) {
                return AxisType.Ensemble;
            }
            if (sname.equalsIgnoreCase("latitude")) {
                return AxisType.Lat;
            }
            if (sname.equalsIgnoreCase("longitude")) {
                return AxisType.Lon;
            }
            if (sname.equalsIgnoreCase("projection_x_coordinate") || sname.equalsIgnoreCase("projection_x_angular_coordinate") || sname.equalsIgnoreCase("grid_longitude") || sname.equalsIgnoreCase("rotated_longitude")) {
                return AxisType.GeoX;
            }
            if (sname.equalsIgnoreCase("projection_y_coordinate") || sname.equalsIgnoreCase("projection_y_angular_coordinate") || sname.equalsIgnoreCase("grid_latitude") || sname.equalsIgnoreCase("rotated_latitude")) {
                return AxisType.GeoY;
            }
            if (sname.equalsIgnoreCase("forecast_reference_time")) {
                return AxisType.RunTime;
            }
            if (sname.equalsIgnoreCase("forecast_period")) {
                return AxisType.TimeOffset;
            }
        }
        if ((axis = ncDataset.findAttValueIgnoreCase((Variable)((Object)v), "axis", null)) != null) {
            axis = axis.trim();
            String unit = v.getUnitsString();
            if (axis.equalsIgnoreCase("X")) {
                if (SimpleUnit.isCompatible("m", unit)) {
                    return AxisType.GeoX;
                }
            } else if (axis.equalsIgnoreCase("Y")) {
                if (SimpleUnit.isCompatible("m", unit)) {
                    return AxisType.GeoY;
                }
            } else if (axis.equalsIgnoreCase("Z")) {
                if (unit == null) {
                    return AxisType.GeoZ;
                }
                if (SimpleUnit.isCompatible("m", unit)) {
                    return AxisType.Height;
                }
                if (SimpleUnit.isCompatible("mbar", unit)) {
                    return AxisType.Pressure;
                }
                return AxisType.GeoZ;
            }
        }
        if (this.avhrr_oiv2 && v.getShortName().equals("zlev")) {
            return AxisType.Height;
        }
        try {
            String units = v.getUnitsString();
            CalendarDateUnit cd = CalendarDateUnit.of(null, units);
            return AxisType.Time;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void correctGoes16(Attribute productionLocation, Attribute icdVersion, Variable gridMappingVar) {
        String prodLoc = productionLocation.getStringValue();
        String icdVer = icdVersion.getStringValue();
        if (prodLoc != null && icdVer != null) {
            prodLoc = prodLoc.toLowerCase().trim();
            icdVer = icdVer.toLowerCase().trim();
            boolean mightNeedCorrected = prodLoc.contains("wcdas");
            mightNeedCorrected = mightNeedCorrected && icdVer.contains("ground segment");
            boolean bl = mightNeedCorrected = mightNeedCorrected && icdVer.contains("awips");
            if (mightNeedCorrected) {
                ImmutableMap<String, String> possibleCorrections = ImmutableMap.of("semi_minor", "semi_minor_axis", "semi_major", "semi_major_axis");
                possibleCorrections.forEach((incorrect, correct) -> {
                    Array vals;
                    Attribute attr = gridMappingVar.findAttributeIgnoreCase((String)incorrect);
                    if (attr != null && (vals = attr.getValues()) != null) {
                        gridMappingVar.addAttribute(new Attribute((String)correct, vals));
                        gridMappingVar.remove(attr);
                        log.debug("Renamed {} attribute {} to {}", gridMappingVar, incorrect, correct);
                    }
                });
            }
        }
    }
}

