/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.ft.point.writer.WriterCFProfileCollection;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.ft.point.writer.WriterCFStationProfileCollection;
import ucar.nc2.ft.point.writer.WriterCFTrajectoryCollection;
import ucar.nc2.ft.point.writer.WriterCFTrajectoryProfileCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public abstract class CFPointWriter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CFPointWriter.class);
    public static final String recordName = "obs";
    public static final String recordDimName = "obs";
    public static final String latName = "latitude";
    public static final String lonName = "longitude";
    public static String altName = "altitude";
    public static String timeName = "time";
    public static final String stationStructName = "station";
    public static final String stationDimName = "station";
    public static final String stationIdName = "station_id";
    public static final String stationAltName = "stationAltitude";
    public static final String descName = "station_description";
    public static final String wmoName = "wmo_id";
    public static final String stationIndexName = "stationIndex";
    public static final String profileStructName = "profile";
    public static final String profileDimName = "profile";
    public static final String profileIdName = "profileId";
    public static final String numberOfObsName = "nobs";
    public static final String profileTimeName = "profileTime";
    public static final String trajStructName = "trajectory";
    public static final String trajDimName = "traj";
    public static final String trajIdName = "trajectoryId";
    public static final int idMissingValue = -9999;
    private static boolean debug;
    protected static final List<String> reservedGlobalAtts;
    protected static final List<String> reservedVariableAtts;
    protected final CFPointWriterConfig config;
    protected NetcdfFileWriter writer;
    protected CalendarDateUnit timeUnit;
    protected String altUnits;
    protected String altitudeCoordinateName = altName;
    protected final boolean isExtendedModel;
    protected boolean useAlt = true;
    protected int nfeatures;
    protected int id_strlen;
    private Map<String, Dimension> dimMap = new HashMap<String, Dimension>();
    protected Structure record;
    protected Dimension recordDim;
    protected Map<String, Variable> dataMap = new HashMap<String, Variable>();
    protected List<VariableSimpleIF> dataVars;
    protected List<CoordinateAxis> coordVars;
    private Map<String, Variable> extraMap;
    protected List<Variable> extra = new ArrayList<Variable>();
    protected LatLonRect llbb;
    protected CalendarDate minDate;
    protected CalendarDate maxDate;

    public static int writeFeatureCollection(FeatureDatasetPoint fdpoint, String fileOut, NetcdfFileWriter.Version version) throws IOException {
        return CFPointWriter.writeFeatureCollection(fdpoint, fileOut, new CFPointWriterConfig(version));
    }

    public static int writeFeatureCollection(FeatureDatasetPoint fdpoint, String fileOut, CFPointWriterConfig config) throws IOException {
        for (DsgFeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            if (fc instanceof PointFeatureCollection) {
                return CFPointWriter.writePointFeatureCollection(fdpoint, (PointFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof StationTimeSeriesFeatureCollection) {
                return CFPointWriter.writeStationFeatureCollection(fdpoint, (StationTimeSeriesFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof ProfileFeatureCollection) {
                return CFPointWriter.writeProfileFeatureCollection(fdpoint, (ProfileFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof TrajectoryFeatureCollection) {
                return CFPointWriter.writeTrajectoryFeatureCollection(fdpoint, (TrajectoryFeatureCollection)fc, fileOut, config);
            }
            if (fc instanceof StationProfileFeatureCollection) {
                return CFPointWriter.writeStationProfileFeatureCollection(fdpoint, (StationProfileFeatureCollection)fc, fileOut, config);
            }
            if (!(fc instanceof TrajectoryProfileFeatureCollection)) continue;
            return CFPointWriter.writeTrajectoryProfileFeatureCollection(fdpoint, (TrajectoryProfileFeatureCollection)fc, fileOut, config);
        }
        return 0;
    }

    private static int writePointFeatureCollection(FeatureDatasetPoint fdpoint, PointFeatureCollection pfc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFPointCollection pointWriter = new WriterCFPointCollection(fileOut, fdpoint.getGlobalAttributes(), fdpoint.getDataVariables(), pfc.getTimeUnit(), pfc.getAltUnits(), config);){
            pointWriter.setExtraVariables(pfc.getExtraVariables());
            pointWriter.writeHeader(pfc);
            int count = 0;
            for (PointFeature pf : pfc) {
                pointWriter.writeRecord(pf, pf.getFeatureData());
                if (debug && ++count % 100 == 0) {
                    logger.debug(String.format("%d ", count));
                }
                if (!debug || count % 1000 != 0) continue;
                logger.debug(String.format("%n ", new Object[0]));
            }
            pointWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeStationFeatureCollection(FeatureDatasetPoint dataset, StationTimeSeriesFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        int count = 0;
        try (WriterCFStationCollection cfWriter = new WriterCFStationCollection(fileOut, dataset.getGlobalAttributes(), dataset.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            ArrayList<StationFeature> flattenFeatures = new ArrayList<StationFeature>();
            ArrayList<Variable> extraVariables = new ArrayList<Variable>();
            for (DsgFeatureCollection station : dataset.getPointFeatureCollectionList()) {
                extraVariables.addAll(station.getExtraVariables());
                flattenFeatures.addAll(((StationTimeSeriesFeatureCollection)station).getStationFeatures());
            }
            cfWriter.setExtraVariables(extraVariables);
            cfWriter.writeHeader(flattenFeatures, null);
            for (DsgFeatureCollection featureCollection : dataset.getPointFeatureCollectionList()) {
                cfWriter.obsRecno = 0;
                for (StationTimeSeriesFeature station : (StationTimeSeriesFeatureCollection)featureCollection) {
                    for (PointFeature pf : station) {
                        cfWriter.writeRecord(((StationPointFeature)pf).getStation(), pf, pf.getFeatureData());
                        if (debug && ++count % 100 == 0) {
                            logger.debug(String.format("%d ", count));
                        }
                        if (!debug || count % 1000 != 0) continue;
                        logger.debug(String.format("%n ", new Object[0]));
                    }
                }
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeProfileFeatureCollection(FeatureDatasetPoint fdpoint, ProfileFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFProfileCollection cfWriter = new WriterCFProfileCollection(fileOut, fdpoint.getGlobalAttributes(), fdpoint.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            ArrayList<Variable> extraVariables = new ArrayList<Variable>();
            ArrayList<ProfileFeature> flattenFeatures = new ArrayList<ProfileFeature>();
            int count = 0;
            int nprofiles = 0;
            int name_strlen = 0;
            for (DsgFeatureCollection featureCollection : fdpoint.getPointFeatureCollectionList()) {
                if ((nprofiles += featureCollection.size()) >= 0) continue;
                for (ProfileFeature profile : (ProfileFeatureCollection)featureCollection) {
                    flattenFeatures.add(profile);
                    name_strlen = Math.max(name_strlen, profile.getName().length());
                    ++count;
                }
                nprofiles = count;
            }
            cfWriter.setExtraVariables(extraVariables);
            cfWriter.setFeatureAuxInfo(nprofiles, name_strlen);
            cfWriter.writeHeader(flattenFeatures);
            count = 0;
            for (ProfileFeature profile : fc) {
                if (debug && (count += cfWriter.writeProfile(profile)) % 10 == 0) {
                    logger.debug(String.format("%d ", count));
                }
                if (!debug || count % 100 != 0) continue;
                logger.debug(String.format("%n ", new Object[0]));
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeTrajectoryFeatureCollection(FeatureDatasetPoint fdpoint, TrajectoryFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFTrajectoryCollection cfWriter = new WriterCFTrajectoryCollection(fileOut, fdpoint.getGlobalAttributes(), fdpoint.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            ArrayList<Variable> extraVariables = new ArrayList<Variable>();
            ArrayList<TrajectoryFeature> flattenFeatures = new ArrayList<TrajectoryFeature>();
            int count = 0;
            int name_strlen = 0;
            int ntrajs = 0;
            for (DsgFeatureCollection featureCollection : fdpoint.getPointFeatureCollectionList()) {
                for (TrajectoryFeature trajectory : (TrajectoryFeatureCollection)featureCollection) {
                    flattenFeatures.add(trajectory);
                    extraVariables.addAll(trajectory.getExtraVariables());
                    name_strlen = Math.max(name_strlen, trajectory.getName().length());
                    ++ntrajs;
                }
            }
            cfWriter.setExtraVariables(extraVariables);
            cfWriter.setFeatureAuxInfo(ntrajs, name_strlen);
            cfWriter.writeHeader(flattenFeatures);
            count = 0;
            for (DsgFeatureCollection featureCollection : fdpoint.getPointFeatureCollectionList()) {
                for (TrajectoryFeature trajectory : (TrajectoryFeatureCollection)featureCollection) {
                    if (debug && (count += cfWriter.writeTrajectory(trajectory)) % 10 == 0) {
                        logger.debug(String.format("%d ", count));
                    }
                    if (!debug || count % 100 != 0) continue;
                    logger.debug(String.format("%n ", new Object[0]));
                }
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeStationProfileFeatureCollection(FeatureDatasetPoint dataset, StationProfileFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFStationProfileCollection cfWriter = new WriterCFStationProfileCollection(fileOut, dataset.getGlobalAttributes(), dataset.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            ArrayList<Variable> extraVariables = new ArrayList<Variable>();
            ArrayList<StationFeature> flattenFeatures = new ArrayList<StationFeature>();
            int countProfiles = 0;
            int name_strlen = 0;
            for (DsgFeatureCollection dsgFeatures : dataset.getPointFeatureCollectionList()) {
                extraVariables.addAll(dsgFeatures.getExtraVariables());
                flattenFeatures.addAll(((StationProfileFeatureCollection)dsgFeatures).getStationFeatures());
                for (StationProfileFeature station : (StationProfileFeatureCollection)dsgFeatures) {
                    name_strlen = Math.max(name_strlen, station.getName().length());
                    for (ProfileFeature fp : station) {
                        ++countProfiles;
                    }
                }
            }
            cfWriter.setExtraVariables(extraVariables);
            cfWriter.setStations(flattenFeatures);
            cfWriter.setFeatureAuxInfo(countProfiles, name_strlen);
            cfWriter.writeHeader(flattenFeatures);
            int count = 0;
            for (DsgFeatureCollection featureCollection : dataset.getPointFeatureCollectionList()) {
                for (StationProfileFeature station : (StationProfileFeatureCollection)featureCollection) {
                    for (ProfileFeature pf : station) {
                        if (pf.getTime() == null) continue;
                        if (debug && (count += cfWriter.writeProfile(station, pf)) % 100 == 0) {
                            logger.debug(String.format("%d ", count));
                        }
                        if (!debug || count % 1000 != 0) continue;
                        logger.debug(String.format("%n ", new Object[0]));
                    }
                }
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    private static int writeTrajectoryProfileFeatureCollection(FeatureDatasetPoint dataset, TrajectoryProfileFeatureCollection fc, String fileOut, CFPointWriterConfig config) throws IOException {
        try (WriterCFTrajectoryProfileCollection cfWriter = new WriterCFTrajectoryProfileCollection(fileOut, dataset.getGlobalAttributes(), dataset.getDataVariables(), fc.getTimeUnit(), fc.getAltUnits(), config);){
            ArrayList<Variable> extraVariables = new ArrayList<Variable>();
            ArrayList<TrajectoryProfileFeature> flattenFeatures = new ArrayList<TrajectoryProfileFeature>();
            int traj_strlen = 0;
            int prof_strlen = 0;
            int countTrajectories = 0;
            int countProfiles = 0;
            for (DsgFeatureCollection featureCollection : dataset.getPointFeatureCollectionList()) {
                for (TrajectoryProfileFeature trajProfile : (TrajectoryProfileFeatureCollection)featureCollection) {
                    extraVariables.addAll(trajProfile.getExtraVariables());
                    flattenFeatures.add(trajProfile);
                    ++countTrajectories;
                    traj_strlen = Math.max(traj_strlen, trajProfile.getName().length());
                    if (trajProfile.size() >= 0) {
                        countProfiles += trajProfile.size();
                        continue;
                    }
                    for (ProfileFeature profile : trajProfile) {
                        prof_strlen = Math.max(prof_strlen, profile.getName().length());
                        ++countProfiles;
                    }
                }
            }
            cfWriter.setExtraVariables(extraVariables);
            cfWriter.setFeatureAuxInfo(countProfiles, prof_strlen);
            cfWriter.setFeatureAuxInfo2(countTrajectories, traj_strlen);
            cfWriter.writeHeader(flattenFeatures);
            int count = 0;
            for (DsgFeatureCollection tpfc : dataset.getPointFeatureCollectionList()) {
                for (TrajectoryProfileFeature spf : (TrajectoryProfileFeatureCollection)tpfc) {
                    for (ProfileFeature profile : spf) {
                        if (profile.getTime() == null) continue;
                        if (debug && (count += cfWriter.writeProfile(spf, profile)) % 100 == 0) {
                            logger.debug(String.format("%d ", count));
                        }
                        if (!debug || count % 1000 != 0) continue;
                        logger.debug(String.format("%n ", new Object[0]));
                    }
                }
            }
            cfWriter.finish();
            int n = count;
            return n;
        }
    }

    protected CFPointWriter(String fileOut, List<Attribute> atts, NetcdfFileWriter.Version version) throws IOException {
        this(fileOut, atts, null, null, null, new CFPointWriterConfig(version));
    }

    protected CFPointWriter(String fileOut, List<Attribute> atts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        this.createWriter(fileOut, config);
        this.dataVars = dataVars;
        this.timeUnit = timeUnit != null ? timeUnit : CalendarDateUnit.unixDateUnit;
        this.altUnits = altUnits;
        this.config = config;
        this.isExtendedModel = this.writer.getVersion().isExtendedModel();
        this.addGlobalAtts(atts);
        this.addNetcdf3UnknownAtts();
    }

    protected CFPointWriter(String fileOut, List<Attribute> atts, List<VariableSimpleIF> dataVars, CFPointWriterConfig config, List<CoordinateAxis> coords) throws IOException {
        this.createWriter(fileOut, config);
        this.dataVars = dataVars;
        this.config = config;
        this.isExtendedModel = this.writer.getVersion().isExtendedModel();
        this.coordVars = new ArrayList<CoordinateAxis>(coords);
        this.coordVars.sort(new CoordinateAxis.AxisComparator());
        this.addGlobalAtts(atts);
        this.addNetcdf3UnknownAtts();
    }

    public void setFeatureAuxInfo(int nfeatures, int id_strlen) {
        this.nfeatures = nfeatures;
        this.id_strlen = id_strlen;
    }

    protected VariableSimpleIF getDataVar(String name) {
        for (VariableSimpleIF v : this.dataVars) {
            if (!v.getShortName().equals(name)) continue;
            return v;
        }
        return null;
    }

    private void createWriter(String fileOut, CFPointWriterConfig config) throws IOException {
        this.writer = NetcdfFileWriter.createNew(config.version, fileOut, config.chunking);
        this.writer.setFill(false);
    }

    private void addGlobalAtts(List<Attribute> atts) {
        this.writer.addGroupAttribute(null, new Attribute("Conventions", this.isExtendedModel ? "CDM-Extended-CF" : "CF-1.9"));
        this.writer.addGroupAttribute(null, new Attribute("history", "Written by CFPointWriter"));
        for (Attribute att : atts) {
            if (reservedGlobalAtts.contains(att.getShortName())) continue;
            this.writer.addGroupAttribute(null, att);
        }
    }

    private void addNetcdf3UnknownAtts() {
        CalendarDate now = CalendarDate.of(new Date());
        this.writer.addGroupAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeStringISO(now)));
        this.writer.addGroupAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeStringISO(now)));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lat_min", 0.0));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lat_max", 0.0));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lon_min", 0.0));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lon_max", 0.0));
    }

    void setExtraVariables(List<Variable> extra) {
        this.extra = extra;
        if (extra != null) {
            for (Variable v : extra) {
                CoordinateAxis axis;
                if (!(v instanceof CoordinateAxis) || (axis = (CoordinateAxis)v).getAxisType() != AxisType.Height) continue;
                this.useAlt = false;
                this.altitudeCoordinateName = v.getFullName();
            }
        }
    }

    protected abstract void makeFeatureVariables(List<StructureData> var1, boolean var2);

    protected void makeMiddleVariables(List<StructureData> middleData, boolean isExtended) {
    }

    protected void writeHeader(List<VariableSimpleIF> obsCoords, List<? extends PointFeatureCollection> stationFeatures, List<StructureData> featureDataStructs, List<StructureData> middleDataStructs) throws IOException {
        PointFeatureCollection stnFeature;
        PeekingIterator iter;
        Iterator<? extends PointFeatureCollection> iterator;
        this.recordDim = this.writer.addUnlimitedDimension("obs");
        this.addExtraVariables();
        if (this.writer.getVersion().isExtendedModel()) {
            this.record = (Structure)this.writer.addVariable(null, "obs", DataType.STRUCTURE, "obs");
            this.addCoordinatesExtended(this.record, obsCoords);
        }
        if (featureDataStructs != null) {
            this.makeFeatureVariables(featureDataStructs, this.writer.getVersion().isExtendedModel());
        }
        if (middleDataStructs != null) {
            this.makeMiddleVariables(middleDataStructs, this.writer.getVersion().isExtendedModel());
        }
        if ((iterator = stationFeatures.iterator()).hasNext() && (iter = Iterators.peekingIterator((stnFeature = iterator.next()).iterator())).hasNext()) {
            PointFeature pointFeat = (PointFeature)iter.peek();
            Formatter coordNames = new Formatter().format("%s %s %s", stnFeature.getTimeName(), latName, lonName);
            if (!Double.isNaN(pointFeat.getLocation().getAltitude())) {
                coordNames.format(" %s", this.altitudeCoordinateName);
            }
            if (this.writer.getVersion().isExtendedModel()) {
                this.addDataVariablesExtended(pointFeat.getFeatureData(), coordNames.toString());
            }
            this.addDataVariablesClassic(this.recordDim, pointFeat.getFeatureData(), this.dataMap, coordNames.toString());
        }
        this.addCoordinatesClassic(this.recordDim, obsCoords, this.dataMap);
        this.writer.create();
        if (!this.writer.getVersion().isExtendedModel()) {
            this.record = this.writer.addRecordStructure();
        }
        this.writeExtraVariables();
    }

    protected void writeHeader(List<VariableSimpleIF> obsCoords, List<StructureData> featureData, StructureData obsData, String coordNames) throws IOException {
        this.recordDim = this.writer.addUnlimitedDimension("obs");
        this.addExtraVariables();
        if (this.writer.getVersion().isExtendedModel()) {
            this.makeFeatureVariables(featureData, true);
            this.record = (Structure)this.writer.addVariable(null, "obs", DataType.STRUCTURE, "obs");
            this.addCoordinatesExtended(this.record, obsCoords);
            this.addDataVariablesExtended(obsData, coordNames);
            this.writer.create();
        } else {
            this.makeFeatureVariables(featureData, false);
            this.addCoordinatesClassic(this.recordDim, obsCoords, this.dataMap);
            this.addDataVariablesClassic(this.recordDim, obsData, this.dataMap, coordNames);
            this.writer.create();
            this.record = this.writer.addRecordStructure();
        }
        this.writeExtraVariables();
    }

    protected void addExtraVariables() {
        if (this.extra == null) {
            return;
        }
        if (this.extraMap == null) {
            this.extraMap = new HashMap<String, Variable>();
        }
        this.addDimensionsClassic(this.extra, this.dimMap);
        for (VariableSimpleIF variableSimpleIF : this.extra) {
            List<Dimension> dims = this.makeDimensionList(this.dimMap, variableSimpleIF.getDimensions());
            Variable mv = this.writer.addVariable(null, variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dims);
            for (Attribute att : variableSimpleIF.attributes()) {
                mv.addAttribute(att);
            }
            this.extraMap.put(mv.getShortName(), mv);
        }
    }

    protected void writeExtraVariables() throws IOException {
        if (this.extra == null) {
            return;
        }
        for (Variable v : this.extra) {
            Variable mv = this.extraMap.get(v.getShortName());
            if (mv == null) continue;
            try {
                this.writer.write(mv, v.read());
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addCoordinatesClassic(Dimension recordDim, List<VariableSimpleIF> coords, Map<String, Variable> varMap) {
        this.addDimensionsClassic(coords, this.dimMap);
        for (VariableSimpleIF oldVar : coords) {
            List<Dimension> dims = this.makeDimensionList(this.dimMap, oldVar.getDimensions());
            dims.add(0, recordDim);
            Variable newVar = oldVar.getDataType() == DataType.STRING && !this.writer.getVersion().isExtendedModel() ? (oldVar instanceof Variable ? this.writer.addStringVariable(null, (Variable)oldVar, dims) : this.writer.addStringVariable(null, oldVar.getShortName(), dims, 20)) : this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), dims);
            if (newVar == null) {
                logger.warn("Variable already exists =" + oldVar.getShortName());
                continue;
            }
            for (Attribute att : oldVar.attributes()) {
                newVar.addAttribute(att);
            }
            varMap.put(newVar.getShortName(), newVar);
        }
    }

    protected void addCoordinatesExtended(Structure parent, List<VariableSimpleIF> coords) {
        for (VariableSimpleIF vs : coords) {
            String dims = Dimensions.makeDimensionsString(vs.getDimensions());
            Variable member = this.writer.addStructureMember(parent, vs.getShortName(), vs.getDataType(), dims);
            if (member == null) {
                logger.warn("Variable already exists =" + vs.getShortName());
                continue;
            }
            for (Attribute att : vs.attributes()) {
                member.addAttribute(att);
            }
        }
    }

    protected void addDataVariablesClassic(Dimension recordDim, StructureData stnData, Map<String, Variable> varMap, String coordVars) {
        this.addDimensionsClassic(this.dataVars, this.dimMap);
        for (StructureMembers.Member m : stnData.getMembers()) {
            Variable newVar;
            VariableSimpleIF oldVar = this.getDataVar(m.getName());
            if (oldVar == null) continue;
            List<Dimension> dims = this.makeDimensionList(this.dimMap, oldVar.getDimensions());
            dims.add(0, recordDim);
            if (oldVar.getDataType() == DataType.STRING && !this.writer.getVersion().isExtendedModel()) {
                newVar = oldVar instanceof Variable ? this.writer.addStringVariable(null, (Variable)oldVar, dims) : this.writer.addStringVariable(null, oldVar.getShortName(), dims, 20);
            } else {
                Variable prevVar = this.writer.findVariable(oldVar.getShortName());
                if (prevVar != null && this.extraMap != null && this.extraMap.get(oldVar.getShortName()) != null) {
                    this.writer.deleteVariable(oldVar.getShortName());
                    this.extraMap.remove(oldVar.getShortName());
                }
                if ((newVar = this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), dims)) == null) {
                    logger.warn("Variable already exists =" + oldVar.getShortName());
                    continue;
                }
            }
            for (Attribute att : oldVar.attributes()) {
                String attName = att.getShortName();
                if (reservedVariableAtts.contains(attName) || attName.startsWith("_Coordinate")) continue;
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordVars));
            varMap.put(newVar.getShortName(), newVar);
        }
    }

    protected void addDataVariablesExtended(StructureData obsData, String coordVars) {
        for (StructureMembers.Member m : obsData.getMembers()) {
            VariableSimpleIF oldVar = this.getDataVar(m.getName());
            if (oldVar == null || this.record.findVariable(oldVar.getShortName()) != null) continue;
            StringBuilder dimNames = new StringBuilder();
            for (Dimension d : oldVar.getDimensions()) {
                if (d.isUnlimited() || d.getShortName() != null && d.getShortName().equals("obs")) continue;
                dimNames.append(" ").append(d.getLength());
            }
            Variable newVar = this.writer.addStructureMember(this.record, oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            if (newVar == null) {
                logger.warn("Variable already exists =" + oldVar.getShortName());
                continue;
            }
            for (Attribute att : oldVar.attributes()) {
                String attName = att.getShortName();
                if (reservedVariableAtts.contains(attName) || attName.startsWith("_Coordinate")) continue;
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordVars));
        }
    }

    protected void addDimensionsClassic(List<? extends VariableSimpleIF> vars, Map<String, Dimension> dimMap) {
        HashSet<Dimension> oldDims = new HashSet<Dimension>(20);
        for (VariableSimpleIF variableSimpleIF : vars) {
            List<Dimension> dims = variableSimpleIF.getDimensions();
            oldDims.addAll(dims);
        }
        for (Dimension dimension : oldDims) {
            String dimName = CFPointWriter.getSharedDimName(dimension);
            if (this.writer.hasDimension(null, dimName)) continue;
            Dimension newDim = this.writer.addDimension(null, dimName, dimension.getLength(), false, dimension.isVariableLength());
            dimMap.put(dimName, newDim);
        }
    }

    protected List<Dimension> makeDimensionList(Map<String, Dimension> dimMap, List<Dimension> oldDims) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        for (Dimension dim : oldDims) {
            Dimension newDim = dimMap.get(CFPointWriter.getSharedDimName(dim));
            assert (newDim != null) : "Oops, we screwed up: dimMap doesn't contain " + CFPointWriter.getSharedDimName(dim);
            result.add(newDim);
        }
        return result;
    }

    public static String getSharedDimName(Dimension dim) {
        if (dim.getShortName() == null) {
            return "len" + dim.getLength();
        }
        return dim.getShortName();
    }

    protected int writeStructureData(int recno, Structure s, StructureData sdata, Map<String, Variable> varMap) throws IOException {
        int[] origin = new int[]{recno};
        try {
            if (this.isExtendedModel) {
                if (s.isUnlimited()) {
                    return this.writer.appendStructureData(s, sdata);
                }
                ArrayStructureW as = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
                as.setStructureData(sdata, 0);
                this.writer.write(s, origin, (Array)as);
                return recno + 1;
            }
            this.writeStructureDataClassic(varMap, origin, sdata);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        return recno + 1;
    }

    protected int writeStructureDataClassic(Map<String, Variable> varMap, int[] origin, StructureData sdata) throws IOException, InvalidRangeException {
        for (StructureMembers.Member m : sdata.getMembers()) {
            Variable mv = varMap.get(m.getName());
            if (mv == null) continue;
            Array org = sdata.getArray(m);
            if (m.getDataType() == DataType.STRING) {
                int strlen = mv.getDimension(((AbstractCollection)((Object)mv.getDimensions())).size() - 1).getLength();
                org = ArrayChar.makeFromStringArray((ArrayObject)org, strlen);
            }
            Array orgPlus1 = Array.makeArrayRankPlusOne(org);
            int[] useOrigin = origin;
            if (org.getRank() > 0) {
                useOrigin = new int[org.getRank() + 1];
                useOrigin[0] = origin[0];
            }
            this.writer.write(mv, useOrigin, orgPlus1);
        }
        return origin[0];
    }

    protected void trackBB(LatLonPoint loc, CalendarDate obsDate) {
        if (loc != null) {
            if (this.llbb == null) {
                this.llbb = new LatLonRect(loc, 0.001, 0.001);
            } else {
                this.llbb.extend(loc);
            }
        }
        if (this.minDate == null || this.minDate.isAfter(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.isBefore(obsDate)) {
            this.maxDate = obsDate;
        }
    }

    public void finish() throws IOException {
        if (this.llbb != null) {
            this.writer.updateAttribute(null, new Attribute("geospatial_lat_min", this.llbb.getLowerLeftPoint().getLatitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lat_max", this.llbb.getUpperRightPoint().getLatitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lon_min", this.llbb.getLowerLeftPoint().getLongitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lon_max", this.llbb.getUpperRightPoint().getLongitude()));
        }
        if (this.minDate == null) {
            this.minDate = CalendarDate.present();
        }
        if (this.maxDate == null) {
            this.maxDate = CalendarDate.present();
        }
        this.writer.updateAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeStringISO(this.minDate)));
        this.writer.updateAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeStringISO(this.maxDate)));
        this.writer.close();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static void main(String[] args) throws Exception {
        String progName = CFPointWriter.class.getName();
        try {
            CommandLine cmdLine = new CommandLine(progName, args);
            if (cmdLine.help) {
                cmdLine.printUsage();
                return;
            }
            FeatureType wantFeatureType = FeatureType.ANY_POINT;
            String location = cmdLine.inputFile.getAbsolutePath();
            CancelTask cancel = null;
            Formatter errlog = new Formatter();
            try (FeatureDatasetPoint fdPoint = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(wantFeatureType, location, cancel, errlog);){
                if (fdPoint == null) {
                    System.err.println(errlog);
                } else {
                    System.out.printf("CFPointWriter: reading from %s, writing to %s%n", cmdLine.inputFile, cmdLine.outputFile);
                    CFPointWriter.writeFeatureCollection(fdPoint, cmdLine.outputFile.getAbsolutePath(), cmdLine.getCFPointWriterConfig());
                    System.out.println("Done.");
                }
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.printf("Try \"%s --help\" for more information.%n", progName);
        }
    }

    static {
        reservedGlobalAtts = Arrays.asList("Conventions", "geospatial_lat_min", "geospatial_lat_max", "geospatial_lon_min", "geospatial_lon_max", "time_coverage_start", "time_coverage_end", "_CoordSysBuilder", "CF:featureType", "CF:feature_type");
        reservedVariableAtts = Arrays.asList("sample_dimension", "instance_dimension");
    }

    private static class CommandLine {
        @Parameter(names={"-i", "--input"}, description="Input file.", required=true)
        public File inputFile;
        @Parameter(names={"-o", "--output"}, description="Output file.", required=true)
        public File outputFile;
        @Parameter(names={"-f", "--format"}, description="Output file format. Allowed values = [netcdf3, netcdf4, netcdf4_classic, netcdf3c, netcdf3c64, ncstream]")
        public NetcdfFileWriter.Version format = NetcdfFileWriter.Version.netcdf3;
        @Parameter(names={"-st", "--strategy"}, description="Chunking strategy. Only used in NetCDF 4. Allowed values = [standard, grib, none]")
        public Nc4Chunking.Strategy strategy = Nc4Chunking.Strategy.standard;
        @Parameter(names={"-d", "--deflateLevel"}, description="Compression level. Only used in NetCDF 4. Allowed values = 0 (no compression, fast) to 9 (max compression, slow)")
        public int deflateLevel = 5;
        @Parameter(names={"-sh", "--shuffle"}, description="Enable the shuffle filter, which may improve compression. Only used in NetCDF 4. This option is ignored unless a non-zero deflate level is specified.")
        public boolean shuffle = true;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help;
        private final JCommander jc;

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
            this.jc.setParameterDescriptionComparator(new ParameterDescriptionComparator());
        }

        public void printUsage() {
            this.jc.usage();
        }

        public Nc4Chunking getNc4Chunking() {
            return Nc4ChunkingStrategy.factory(this.strategy, this.deflateLevel, this.shuffle);
        }

        public CFPointWriterConfig getCFPointWriterConfig() {
            return new CFPointWriterConfig(this.format, this.getNc4Chunking());
        }

        private static class ParameterDescriptionComparator
        implements Comparator<ParameterDescription> {
            private final List<String> orderedParamNames = Arrays.asList("--input", "--output", "--format", "--strategy", "--deflateLevel", "--shuffle", "--help");

            private ParameterDescriptionComparator() {
            }

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                int index0 = this.orderedParamNames.indexOf(p0.getLongestName());
                int index1 = this.orderedParamNames.indexOf(p1.getLongestName());
                assert (index0 >= 0) : "Unexpected parameter name: " + p0.getLongestName();
                assert (index1 >= 0) : "Unexpected parameter name: " + p1.getLongestName();
                return Integer.compare(index0, index1);
            }
        }
    }
}

