/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import javax.annotation.Nullable;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.Indent;
import ucar.unidata.util.StringUtil2;

public class CDLWriter {
    private final NetcdfFile ncfile;
    private final Formatter out;
    private final boolean strict;
    private static char[] org = new char[]{'\b', '\f', '\n', '\r', '\t', '\\', '\'', '\"'};
    private static String[] replace = new String[]{"\\b", "\\f", "\\n", "\\r", "\\t", "\\\\", "\\'", "\\\""};

    @Deprecated
    public static void writeCDL(NetcdfFile ncfile, PrintStream out, boolean strict) {
        Formatter f = new Formatter();
        CDLWriter.writeCDL(ncfile, f, strict, null);
        PrintWriter pw = new PrintWriter(out);
        pw.write(f.toString());
    }

    @Deprecated
    public static void writeCDL(NetcdfFile ncfile, Writer out, boolean strict) {
        Formatter f = new Formatter();
        CDLWriter.writeCDL(ncfile, f, strict, null);
        PrintWriter pw = new PrintWriter(out);
        pw.write(f.toString());
    }

    public static void writeCDL(NetcdfFile ncfile, Formatter out, boolean strict, @Nullable String nameOverride) {
        CDLWriter writer = new CDLWriter(ncfile, out, strict);
        writer.toStringStart(new Indent(2), strict, nameOverride);
        writer.toStringEnd();
    }

    CDLWriter(NetcdfFile ncfile, Formatter out, boolean strict) {
        this.ncfile = ncfile;
        this.out = out;
        this.strict = strict;
    }

    void toStringStart(Indent indent, boolean strict, @Nullable String nameOverride) {
        String name;
        String string = name = nameOverride != null ? nameOverride : this.ncfile.getLocation();
        if (strict) {
            if (name.endsWith(".nc")) {
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".cdl")) {
                name = name.substring(0, name.length() - 4);
            }
            name = NetcdfFiles.makeValidCDLName(name);
        }
        this.out.format("%snetcdf %s {%n", indent, name);
        indent.incr();
        this.writeCDL(this.ncfile.getRootGroup(), indent);
        indent.decr();
    }

    void toStringEnd() {
        this.out.format("}%n", new Object[0]);
    }

    private void writeCDL(Group group, Indent indent) {
        boolean hasA;
        ImmutableList<EnumTypedef> enumTypedefs = group.getEnumTypedefs();
        boolean hasE = !enumTypedefs.isEmpty();
        boolean hasD = !group.getDimensions().isEmpty();
        boolean hasV = !group.getVariables().isEmpty();
        boolean bl = hasA = !Iterables.isEmpty(group.attributes());
        if (hasE) {
            this.out.format("%stypes:%n", indent);
            indent.incr();
            for (EnumTypedef e : enumTypedefs) {
                this.writeCDL(e, indent);
                this.out.format("%n", new Object[0]);
            }
            indent.decr();
            this.out.format("%n", new Object[0]);
        }
        if (hasD) {
            this.out.format("%sdimensions:%n", indent);
            indent.incr();
            for (Dimension myd : group.getDimensions()) {
                this.writeCDL(myd, indent);
                this.out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        if (hasV) {
            this.out.format("%svariables:%n", indent);
            indent.incr();
            for (Variable v : group.getVariables()) {
                if (v instanceof Structure) {
                    this.writeCDL((Structure)v, indent, false);
                } else {
                    this.writeCDL(v, indent, false);
                }
                this.out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        for (Group g : group.getGroups()) {
            String gname = this.strict ? NetcdfFiles.makeValidCDLName(g.getShortName()) : g.getShortName();
            this.out.format("%sgroup: %s {%n", indent, gname);
            indent.incr();
            this.writeCDL(g, indent);
            indent.decr();
            this.out.format("%s}%n%n", indent);
        }
        if (hasA) {
            if (group.isRoot()) {
                this.out.format("%s// global attributes:%n", indent);
            } else {
                this.out.format("%s// group attributes:%n", indent);
            }
            for (Attribute att : group.attributes()) {
                if (CDM.isspecial(att)) continue;
                this.out.format("%s", indent);
                this.writeCDL(att, null);
                this.out.format(";", new Object[0]);
                if (!this.strict && att.getDataType() != DataType.STRING) {
                    this.out.format(" // %s", new Object[]{att.getDataType()});
                }
                this.out.format("%n", new Object[0]);
            }
        }
    }

    private void writeCDL(Attribute att, String parentname) {
        if (this.strict && (att.isString() || att.getEnumType() != null)) {
            this.out.format("string ", new Object[0]);
        }
        if (this.strict && parentname != null) {
            this.out.format(NetcdfFiles.makeValidCDLName(parentname), new Object[0]);
        }
        this.out.format(":", new Object[0]);
        this.out.format("%s", this.strict ? NetcdfFiles.makeValidCDLName(att.getShortName()) : att.getShortName());
        if (att.isString()) {
            this.out.format(" = ", new Object[0]);
            for (int i = 0; i < att.getLength(); ++i) {
                String val;
                if (i != 0) {
                    this.out.format(", ", new Object[0]);
                }
                if ((val = att.getStringValue(i)) == null) continue;
                this.out.format("\"%s\"", CDLWriter.encodeString(val));
            }
        } else if (att.getEnumType() != null) {
            this.out.format(" = ", new Object[0]);
            for (int i = 0; i < att.getLength(); ++i) {
                String econst;
                EnumTypedef en;
                Integer ecint;
                if (i != 0) {
                    this.out.format(", ", new Object[0]);
                }
                if ((ecint = (en = att.getEnumType()).lookupEnumInt(econst = att.getStringValue(i))) == null) {
                    throw new ForbiddenConversionException("Illegal enum constant: " + econst);
                }
                this.out.format("\"%s\"", CDLWriter.encodeString(econst));
            }
        } else {
            this.out.format(" = ", new Object[0]);
            for (int i = 0; i < att.getLength(); ++i) {
                if (i != 0) {
                    this.out.format(", ", new Object[0]);
                }
                DataType dataType = att.getDataType();
                Number number = att.getNumericValue(i);
                if (dataType.isUnsigned()) {
                    number = DataType.widenNumber(number);
                }
                this.out.format("%s", number);
                if (dataType.isUnsigned()) {
                    this.out.format("U", new Object[0]);
                }
                if (dataType == DataType.FLOAT) {
                    this.out.format("f", new Object[0]);
                    continue;
                }
                if (dataType == DataType.SHORT || dataType == DataType.USHORT) {
                    this.out.format("S", new Object[0]);
                    continue;
                }
                if (dataType == DataType.BYTE || dataType == DataType.UBYTE) {
                    this.out.format("B", new Object[0]);
                    continue;
                }
                if (dataType != DataType.LONG && dataType != DataType.ULONG) continue;
                this.out.format("L", new Object[0]);
            }
        }
    }

    private void writeCDL(Dimension dim, Indent indent) {
        String name = this.strict ? NetcdfFiles.makeValidCDLName(dim.getShortName()) : dim.getShortName();
        this.out.format("%s%s", indent, name);
        if (dim.isUnlimited()) {
            this.out.format(" = UNLIMITED;   // (%d currently)", dim.getLength());
        } else if (dim.isVariableLength()) {
            this.out.format(" = UNKNOWN;", new Object[0]);
        } else {
            this.out.format(" = %d;", dim.getLength());
        }
    }

    private void writeCDL(EnumTypedef e, Indent indent) {
        String name = this.strict ? NetcdfFiles.makeValidCDLName(e.getShortName()) : e.getShortName();
        String basetype = "";
        switch (e.getBaseType()) {
            case ENUM1: {
                basetype = "byte ";
                break;
            }
            case ENUM2: {
                basetype = "short ";
                break;
            }
            case ENUM4: {
                basetype = "";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected basetype = " + (Object)((Object)e.getBaseType()));
            }
        }
        this.out.format("%s%senum %s { ", indent, basetype, name);
        int count = 0;
        ImmutableMap<Integer, String> map = e.getMap();
        ArrayList keysetList = new ArrayList(map.keySet());
        Collections.sort(keysetList);
        for (Integer key : keysetList) {
            String s = (String)map.get(key);
            if (0 < count++) {
                this.out.format(", ", new Object[0]);
            }
            if (this.strict) {
                this.out.format("%s = %s", NetcdfFile.makeValidCDLName(s), key);
                continue;
            }
            this.out.format("'%s' = %s", s, key);
        }
        this.out.format("};", new Object[0]);
    }

    private void writeCDL(Variable v, Indent indent, boolean useFullName) {
        this.out.format("%s", indent);
        DataType dataType = v.getDataType();
        if (dataType == null) {
            this.out.format("Unknown", new Object[0]);
        } else if (dataType.isEnum()) {
            if (v.getEnumTypedef() == null) {
                this.out.format("enum UNKNOWN", new Object[0]);
            } else {
                this.out.format("enum %s", NetcdfFile.makeValidCDLName(v.getEnumTypedef().getShortName()));
            }
        } else {
            String printname = dataType.toString();
            if (this.strict) {
                printname = printname.toLowerCase();
            }
            this.out.format("%s", printname);
        }
        this.out.format(" ", new Object[0]);
        v.getNameAndDimensions(this.out, useFullName, this.strict);
        this.out.format(";", new Object[0]);
        this.out.format("%n", new Object[0]);
        indent.incr();
        for (Attribute att : v.attributes()) {
            if (CDM.isspecial(att)) continue;
            this.out.format("%s", indent);
            this.writeCDL(att, v.getShortName());
            this.out.format(";", new Object[0]);
            if (!this.strict && att.getDataType() != DataType.STRING) {
                this.out.format(" // %s", new Object[]{att.getDataType()});
            }
            this.out.format("%n", new Object[0]);
        }
        indent.decr();
    }

    private static String encodeString(String s) {
        return StringUtil2.replace(s, org, replace);
    }

    private void writeCDL(Structure s, Indent indent, boolean useFullName) {
        this.out.format("%n%s%s {%n", new Object[]{indent, s.getDataType()});
        indent.incr();
        for (Variable v : s.getVariables()) {
            if (v instanceof Structure) {
                this.writeCDL((Structure)v, indent, useFullName);
                continue;
            }
            this.writeCDL(v, indent, useFullName);
        }
        indent.decr();
        this.out.format("%s} ", indent);
        s.getNameAndDimensions(this.out, useFullName, this.strict);
        this.out.format(";%n", new Object[0]);
        for (Attribute att : s.attributes()) {
            if (CDM.isspecial(att)) continue;
            this.out.format("%s", indent);
            this.writeCDL(att, s.getShortName());
            this.out.format(";", new Object[0]);
            if (!this.strict && att.getDataType() != DataType.STRING) {
                this.out.format(" // %s", new Object[]{att.getDataType()});
            }
            this.out.format("%n", new Object[0]);
        }
        this.out.format("%n", new Object[0]);
    }
}

