/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import com.google.common.math.DoubleMath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ucar.unidata.geoloc.ProjectionPoint;

public class ProjectionRect
implements Serializable {
    private double x;
    private double y;
    private double width;
    private double height;

    public ProjectionRect() {
        this(-5000.0, -5000.0, 5000.0, 5000.0);
    }

    public ProjectionRect(ProjectionPoint corner1, ProjectionPoint corner2) {
        this(corner1.getX(), corner1.getY(), corner2.getX(), corner2.getY());
    }

    public ProjectionRect(ProjectionPoint minimum, double width, double height) {
        this.setRect(minimum.getX(), minimum.getY(), width, height);
    }

    public ProjectionRect(ProjectionRect r) {
        this(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
    }

    public ProjectionRect(double x1, double y1, double x2, double y2) {
        double wx0 = 0.5 * (x1 + x2);
        double wy0 = 0.5 * (y1 + y2);
        double width = Math.abs(x1 - x2);
        double height = Math.abs(y1 - y2);
        this.setRect(wx0 - width / 2.0, wy0 - height / 2.0, width, height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    @Deprecated
    public void add(ProjectionRect r) {
        double x1 = Math.min(this.getMinX(), r.getMinX());
        double x2 = Math.max(this.getMaxX(), r.getMaxX());
        double y1 = Math.min(this.getMinY(), r.getMinY());
        double y2 = Math.max(this.getMaxY(), r.getMaxY());
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Deprecated
    public void add(double newx, double newy) {
        double x1 = Math.min(this.getMinX(), newx);
        double x2 = Math.max(this.getMaxX(), newx);
        double y1 = Math.min(this.getMinY(), newy);
        double y2 = Math.max(this.getMaxY(), newy);
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Deprecated
    public void add(ProjectionPoint pt) {
        this.add(pt.getX(), pt.getY());
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean intersects(ProjectionRect r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x + w > x0 && y + h > y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public static void intersect(ProjectionRect src1, ProjectionRect src2, ProjectionRect dest) {
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        dest.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean contains(ProjectionPoint point) {
        return DoubleMath.fuzzyCompare(point.getX(), this.getMinX(), 1.0E-6) >= 0 && DoubleMath.fuzzyCompare(point.getX(), this.getMaxX(), 1.0E-6) <= 0 && DoubleMath.fuzzyCompare(point.getY(), this.getMinY(), 1.0E-6) >= 0 && DoubleMath.fuzzyCompare(point.getY(), this.getMaxY(), 1.0E-6) <= 0;
    }

    public boolean contains(ProjectionRect rect) {
        boolean contained = this.equals(rect) ? true : this.contains(rect.getMinPoint()) && this.contains(rect.getMaxPoint());
        return contained;
    }

    public ProjectionPoint getLowerRightPoint() {
        return ProjectionPoint.create(this.getMaxPoint().getX(), this.getMinPoint().getY());
    }

    public ProjectionPoint getUpperRightPoint() {
        return this.getMaxPoint();
    }

    public ProjectionPoint getLowerLeftPoint() {
        return this.getMinPoint();
    }

    public ProjectionPoint getUpperLeftPoint() {
        return ProjectionPoint.create(this.getMinPoint().getX(), this.getMaxPoint().getY());
    }

    public ProjectionPoint getMinPoint() {
        return ProjectionPoint.create(this.getX(), this.getY());
    }

    public ProjectionPoint getMaxPoint() {
        return ProjectionPoint.create(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    public String toString() {
        return String.format("min: %.3f %.3f size: %.3f %.3f", this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public String toString2(int ndec) {
        String f = " %." + ndec + "f";
        return String.format("min:" + f + f + " max:" + f + f, this.getX(), this.getY(), this.getMaxX(), this.getMaxY());
    }

    @Deprecated
    public void setX(double x) {
        this.setRect(x, this.getY(), this.getWidth(), this.getHeight());
    }

    @Deprecated
    public void setY(double y) {
        this.setRect(this.getX(), y, this.getWidth(), this.getHeight());
    }

    @Deprecated
    public void setWidth(double w) {
        this.setRect(this.getX(), this.getY(), w, this.getHeight());
    }

    @Deprecated
    public void setHeight(double h) {
        this.setRect(this.getX(), this.getY(), this.getWidth(), h);
    }

    @Deprecated
    public void setRect(ProjectionRect r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Deprecated
    public void setRect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    private void readObject(ObjectInputStream s) throws IOException {
        double x = s.readDouble();
        double y = s.readDouble();
        double w = s.readDouble();
        double h = s.readDouble();
        this.setRect(x, y, w, h);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeDouble(this.getX());
        s.writeDouble(this.getY());
        s.writeDouble(this.getWidth());
        s.writeDouble(this.getHeight());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectionRect that = (ProjectionRect)o;
        if (Double.compare(that.height, this.height) != 0) {
            return false;
        }
        if (Double.compare(that.width, this.width) != 0) {
            return false;
        }
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        return Double.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean nearlyEquals(ProjectionRect other) {
        return this.nearlyEquals(other, 1.0E-5f);
    }

    public boolean nearlyEquals(ProjectionRect other, double maxRelDiff) {
        return this.getLowerLeftPoint().nearlyEquals(other.getLowerLeftPoint(), maxRelDiff) && this.getUpperRightPoint().nearlyEquals(other.getUpperRightPoint(), maxRelDiff);
    }
}

