/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.CollectionIteratorAdapter;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.PointFeatureCCImpl;
import ucar.nc2.ft.point.TrajectoryFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.LatLonRect;

public class StandardTrajectoryCollectionImpl
extends PointFeatureCCImpl
implements TrajectoryFeatureCollection {
    private NestedTable ft;
    private TrajCollectionIterator localIterator;

    protected StandardTrajectoryCollectionImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.TRAJECTORY);
    }

    protected StandardTrajectoryCollectionImpl(String name, List<CoordinateAxis> coords) {
        super(name, coords, FeatureType.TRAJECTORY);
    }

    StandardTrajectoryCollectionImpl(NestedTable ft, CalendarDateUnit timeUnit, String altUnits) {
        super(ft.getName(), timeUnit, altUnits, FeatureType.TRAJECTORY);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    StandardTrajectoryCollectionImpl(NestedTable ft, List<CoordinateAxis> coords) {
        super(ft.getName(), coords, FeatureType.TRAJECTORY);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    @Override
    public TrajectoryFeatureCollection subset(LatLonRect boundingBox) {
        return new StandardTrajectoryCollectionSubset(this, boundingBox);
    }

    @Override
    public Iterator<TrajectoryFeature> iterator() {
        try {
            PointFeatureCollectionIterator pfIterator = this.getPointFeatureCollectionIterator();
            return new CollectionIteratorAdapter<TrajectoryFeature>(pfIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
        return new TrajCollectionIterator(this.ft.getRootFeatureDataIterator());
    }

    @Override
    public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
        return new TrajCollectionIterator(this.ft.getRootFeatureDataIterator());
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public TrajectoryFeature next() {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = (TrajCollectionIterator)this.getPointFeatureCollectionIterator();
    }

    private static class StandardTrajectoryCollectionSubset
    extends StandardTrajectoryCollectionImpl {
        TrajectoryFeatureCollection from;
        LatLonRect boundingBox;

        StandardTrajectoryCollectionSubset(TrajectoryFeatureCollection from, LatLonRect boundingBox) {
            super(from.getName() + "-subset", from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.boundingBox = boundingBox;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(), new FilterBB());
        }

        private class FilterBB
        implements PointFeatureCollectionIterator.Filter {
            private FilterBB() {
            }

            @Override
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StandardTrajectoryCollectionSubset.this.boundingBox.contains(profileFeature.getLatLon());
            }
        }
    }

    private class TrajCollectionIterator
    implements PointFeatureCollectionIterator,
    IOIterator<PointFeatureCollection> {
        StructureDataIterator structIter;
        StructureData nextTraj;
        StandardTrajectoryFeature prev;
        CollectionInfo calcInfo;

        TrajCollectionIterator(StructureDataIterator structIter) {
            this.structIter = structIter;
            CollectionInfo info = StandardTrajectoryCollectionImpl.this.getInfo();
            if (!info.isComplete()) {
                this.calcInfo = info;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            do {
                if (this.prev != null && this.calcInfo != null) {
                    this.calcInfo.extend(this.prev.getInfo());
                }
                if (!this.structIter.hasNext()) {
                    this.structIter.close();
                    if (this.calcInfo != null) {
                        this.calcInfo.setComplete();
                    }
                    return false;
                }
                this.nextTraj = this.structIter.next();
            } while (StandardTrajectoryCollectionImpl.this.ft.isFeatureMissing(this.nextTraj));
            return true;
        }

        @Override
        public TrajectoryFeature next() {
            Cursor cursor = new Cursor(StandardTrajectoryCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[1] = this.structIter.getCurrentRecno();
            cursor.tableData[1] = this.nextTraj;
            cursor.currentIndex = 1;
            StandardTrajectoryCollectionImpl.this.ft.addParentJoin(cursor);
            this.prev = new StandardTrajectoryFeature(cursor, this.nextTraj);
            return this.prev;
        }

        @Override
        public void close() {
            this.structIter.close();
        }
    }

    private class StandardTrajectoryFeature
    extends TrajectoryFeatureImpl {
        Cursor cursor;
        StructureData trajData;

        StandardTrajectoryFeature(Cursor cursor, StructureData trajData) {
            super(StandardTrajectoryCollectionImpl.this.ft.getFeatureName(cursor), StandardTrajectoryCollectionImpl.this.getTimeUnit(), StandardTrajectoryCollectionImpl.this.getAltUnits(), -1);
            this.cursor = cursor;
            this.trajData = trajData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardTrajectoryCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter);
            return new StandardPointFeatureIterator(this, StandardTrajectoryCollectionImpl.this.ft, this.timeUnit, siter, cursorIter);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.trajData;
        }
    }
}

