/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.Station;

public class WriterCFStationCollection
extends CFPointWriter {
    private List<StationFeature> stnList;
    protected Structure stationStruct;
    private HashMap<String, Integer> stationIndexMap;
    private boolean useDesc;
    private boolean useAlt;
    private boolean useWmoId;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private Map<String, Variable> featureVarMap = new HashMap<String, Variable>();
    private int stnRecno;
    protected int obsRecno;

    public WriterCFStationCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeries.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Timeseries of station data in the indexed ragged array representation, H.2.5"));
    }

    public WriterCFStationCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, List<CoordinateAxis> coordVars, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, config, coordVars);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeries.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Timeseries of station data in the indexed ragged array representation, H.2.5"));
    }

    public void writeHeader(StationTimeSeriesFeatureCollection stations) throws IOException {
        this.writeHeader(stations.getStationFeatures(), null);
    }

    public void writeHeader(List<StationFeature> stns, @Nullable StationPointFeature spf) throws IOException {
        this.stnList = stns.stream().distinct().collect(Collectors.toList());
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        ArrayList<PointFeatureCollection> flattenStations = new ArrayList<PointFeatureCollection>();
        ArrayList<StructureData> stationData = new ArrayList<StructureData>();
        for (StationFeature stn : stns) {
            flattenStations.add((PointFeatureCollection)((Object)stn));
            stationData.add(stn.getFeatureData());
            boolean bl = this.useAlt = !Double.isNaN(stn.getAltitude());
            if (stn.getWmoId() != null && !stn.getWmoId().trim().isEmpty()) {
                this.useWmoId = true;
            }
            if (stn.getDescription() != null && !stn.getDescription().trim().isEmpty()) {
                this.useDesc = true;
            }
            this.id_strlen = Math.max(this.id_strlen, stn.getName().length());
            if (stn.getDescription() != null) {
                this.desc_strlen = Math.max(this.desc_strlen, stn.getDescription().length());
            }
            if (stn.getWmoId() != null) {
                this.wmo_strlen = Math.max(this.wmo_strlen, stn.getWmoId().length());
            }
            DsgFeatureCollection dsgStation = (DsgFeatureCollection)((Object)stn);
            if (!coords.stream().noneMatch(x -> x.getShortName().equals(dsgStation.getTimeName()))) continue;
            coords.add(VariableSimpleBuilder.makeScalar(dsgStation.getTimeName(), "time of measurement", dsgStation.getTimeUnit().getUdUnit(), DataType.DOUBLE).addAttribute("calendar", dsgStation.getTimeUnit().getCalendar().toString()).build());
        }
        this.llbb = CFPointWriterUtils.getBoundingBox(this.stnList);
        this.altitudeCoordinateName = "stationAltitude";
        coords.add(VariableSimpleBuilder.makeScalar("stationIndex", "station index for this observation record", null, DataType.INT).addAttribute("instance_dimension", "station").build());
        super.writeHeader(coords, flattenStations, stationData, null);
        int count = 0;
        this.stationIndexMap = new HashMap(this.stnList.size(), 1.0f);
        for (StationFeature stn : this.stnList) {
            this.writeStationData(stn);
            this.stationIndexMap.put(stn.getName(), count);
            ++count;
        }
    }

    @Override
    protected void makeFeatureVariables(List<StructureData> featureDataStructs, boolean isExtended) {
        Dimension stationDim = this.writer.addDimension(null, "station", this.stnList.size());
        ArrayList<VariableSimpleIF> stnVars = new ArrayList<VariableSimpleIF>();
        stnVars.add(VariableSimpleBuilder.makeScalar("latitude", "station latitude", "degrees_north", DataType.DOUBLE).build());
        stnVars.add(VariableSimpleBuilder.makeScalar("longitude", "station longitude", "degrees_east", DataType.DOUBLE).build());
        if (this.useAlt) {
            stnVars.add(VariableSimpleBuilder.makeScalar("stationAltitude", "station altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "station_altitude").build());
        }
        stnVars.add(VariableSimpleBuilder.makeString("station_id", "station identifier", null, this.id_strlen).addAttribute("cf_role", "timeseries_id").build());
        if (this.useDesc) {
            stnVars.add(VariableSimpleBuilder.makeString("station_description", "station description", null, this.desc_strlen).addAttribute("standard_name", "platform_name").build());
        }
        if (this.useWmoId) {
            stnVars.add(VariableSimpleBuilder.makeString("wmo_id", "station WMO id", null, this.wmo_strlen).addAttribute("standard_name", "platform_id").build());
        }
        for (StructureData featureData : featureDataStructs) {
            for (StructureMembers.Member m : featureData.getMembers()) {
                if (this.getDataVar(m.getName()) == null || !stnVars.stream().noneMatch(x -> x.getShortName().equals(m.getFullName()))) continue;
                stnVars.add(VariableSimpleBuilder.fromMember(m).build());
            }
        }
        if (isExtended) {
            this.stationStruct = (Structure)this.writer.addVariable(null, "station", DataType.STRUCTURE, "station");
            this.addCoordinatesExtended(this.stationStruct, stnVars);
        } else {
            this.addCoordinatesClassic(stationDim, stnVars, this.featureVarMap);
        }
    }

    private void writeStationData(StationFeature stn) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, stn.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, stn.getLatLon().getLongitude());
        smb.addMemberScalar("stationAltitude", null, null, DataType.DOUBLE, stn.getAltitude());
        smb.addMemberString("station_id", null, null, stn.getName().trim(), this.id_strlen);
        if (this.useDesc) {
            smb.addMemberString("station_description", null, null, stn.getDescription().trim(), this.desc_strlen);
        }
        if (this.useWmoId) {
            smb.addMemberString("wmo_id", null, null, stn.getWmoId().trim(), this.wmo_strlen);
        }
        StructureDataFromMember stnCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(stnCoords, stn.getFeatureData()));
        this.stnRecno = super.writeStructureData(this.stnRecno, this.stationStruct, sdall, this.featureVarMap);
    }

    public void writeRecord(Station s, PointFeature sobs, StructureData sdata) throws IOException {
        if (s instanceof DsgFeatureCollection) {
            DsgFeatureCollection dsgStation = (DsgFeatureCollection)((Object)s);
            this.writeRecord(dsgStation.getName(), dsgStation.getTimeName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), this.altitudeCoordinateName, sobs.getLocation().getAltitude(), sdata);
        } else {
            this.writeRecord(s.getName(), sobs.getFeatureCollection().getTimeName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), this.altitudeCoordinateName, sobs.getLocation().getAltitude(), sdata);
        }
    }

    public void writeRecord(String stnName, double timeCoordValue, CalendarDate obsDate, StructureData sdata) throws IOException {
        this.writeRecord(stnName, timeName, timeCoordValue, obsDate, this.altitudeCoordinateName, 0.0, sdata);
    }

    public void writeRecord(String stnName, String timeCoordName, double timeCoordValue, CalendarDate obsDate, String altName, double altValue, StructureData sdata) throws IOException {
        this.trackBB(null, obsDate);
        Integer parentIndex = this.stationIndexMap.get(stnName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(timeCoordName, null, null, DataType.DOUBLE, timeCoordValue);
        if (this.useAlt) {
            smb.addMemberScalar(altName, null, null, DataType.DOUBLE, altValue);
        }
        smb.addMemberScalar("stationIndex", null, null, DataType.INT, parentIndex);
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, sdata));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

