/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationProfileCollectionImpl;
import ucar.nc2.ft.point.StationProfileFeatureImpl;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft2.coverage.CoordSysSet;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.util.StringUtil2;

public class CoverageAsPoint {
    private static final boolean debug = false;
    private List<VarGroup> varGroups;
    private SubsetParams subset;
    private LatLonPoint latLonPoint;
    private LatLonPoint nearestLatLonPoint;

    public CoverageAsPoint(CoverageCollection gcd, List<String> varNames, SubsetParams subset) throws IOException {
        this.subset = subset;
        this.latLonPoint = (LatLonPoint)subset.get("latlonPoint");
        if (this.latLonPoint == null) {
            throw new IllegalArgumentException("No latlon point");
        }
        this.varGroups = new ArrayList<VarGroup>();
        for (CoordSysSet css : gcd.getCoverageSets()) {
            List<Coverage> wantCovs = css.getCoverages().stream().filter(cov -> varNames.contains(cov.getName())).collect(Collectors.toList());
            if (wantCovs.isEmpty()) continue;
            this.varGroups.add(new VarGroup(css.getCoordSys().getName(), wantCovs));
        }
    }

    public FeatureDatasetPoint asFeatureDatasetPoint() {
        return this.varGroups.isEmpty() ? null : new CoverageAsFeatureDatasetPoint();
    }

    private static FeatureType parseFeatureType(List<VarGroup> groups) {
        FeatureType fType = groups.get(0).fType;
        for (int i = 1; i < groups.size(); ++i) {
            if (groups.get(i).fType == fType) continue;
            return FeatureType.ANY_POINT;
        }
        return fType;
    }

    private class VarGroup {
        private String name;
        private List<VarData> varData;
        private FeatureType fType;
        private CoverageCoordAxis1D timeAxis;
        private CalendarDateUnit dateUnit;
        private CoverageCoordAxis1D zAxis;
        private String zUnit;

        VarGroup(String name, List<Coverage> wantCovs) throws IOException {
            this.name = name;
            this.varData = new ArrayList<VarData>();
            for (Coverage cov : wantCovs) {
                try {
                    this.varData.add(new VarData(cov));
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
            }
            if (this.varData.isEmpty()) {
                throw new IllegalArgumentException("No coverage data found for parameters " + CoverageAsPoint.this.subset);
            }
            CoverageCoordSys subsetSys = this.varData.get((int)0).array.getCoordSysForData();
            if (CoverageAsPoint.this.nearestLatLonPoint == null) {
                CoverageAsPoint.this.nearestLatLonPoint = subsetSys.getHorizCoordSys().getLatLon(0, 0);
            }
            this.timeAxis = (CoverageCoordAxis1D)subsetSys.getTimeAxis();
            if (this.timeAxis != null) {
                this.dateUnit = this.timeAxis.getCalendarDateUnit();
            }
            this.zAxis = (CoverageCoordAxis1D)subsetSys.getZAxis();
            if (this.zAxis != null) {
                this.zUnit = this.zAxis.getUnits();
            }
            this.fType = this.zAxis == null || this.zAxis.getNcoords() <= 1 ? FeatureType.STATION : FeatureType.STATION_PROFILE;
        }
    }

    private class CoverageAsFeatureDatasetPoint
    extends PointDatasetImpl {
        CoverageAsFeatureDatasetPoint() {
            super(CoverageAsPoint.parseFeatureType(CoverageAsPoint.this.varGroups));
            this.collectionList = new ArrayList();
            ArrayList<VariableSimpleIF> dataVars = new ArrayList<VariableSimpleIF>();
            for (VarGroup vg : CoverageAsPoint.this.varGroups) {
                DsgCollectionImpl featCol = vg.fType == FeatureType.STATION_PROFILE ? new CoverageAsStationProfileCollection(vg) : new CoverageAsStationFeatureCollection(vg);
                this.collectionList.add(featCol);
                for (VarData vd : vg.varData) {
                    Coverage cov = vd.cov;
                    VariableSimpleIF simple = new VariableSimpleBuilder(cov.getName(), cov.getDescription(), cov.getUnitsString(), cov.getDataType(), cov.getDimensions()).build();
                    dataVars.add(simple);
                }
            }
            this.dataVariables = dataVars;
        }
    }

    private class CoverageAsStationFeature
    extends StationTimeSeriesFeatureImpl {
        private VarGroup varGroup;

        private CoverageAsStationFeature(String name, String desc, String wmoId, double lat, double lon, double alt, CalendarDateUnit timeUnit, String altUnits, int npts, VarGroup varGroup) {
            super(name, desc, wmoId, lat, lon, alt, timeUnit, altUnits, npts, StructureData.EMPTY);
            this.varGroup = varGroup;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return StructureData.EMPTY;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() {
            return new TimeseriesIterator();
        }

        private class TimeseriesIterator
        extends PointIteratorAbstract {
            int curr;
            int nvalues;
            List<VarIter> varIters;
            CoverageCoordAxis1D timeAxis;

            TimeseriesIterator() {
                this.timeAxis = CoverageAsStationFeature.this.varGroup.timeAxis;
                this.nvalues = this.timeAxis != null ? this.timeAxis.getNcoords() : 1;
                this.varIters = new ArrayList<VarIter>();
                for (VarData vd : CoverageAsStationFeature.this.varGroup.varData) {
                    Array data = vd.array.getData();
                    this.varIters.add(new VarIter(vd.cov, vd.array, data.getIndexIterator()));
                }
            }

            @Override
            public boolean hasNext() {
                boolean more;
                boolean bl = more = this.curr < this.nvalues;
                if (!more) {
                    this.close();
                }
                return more;
            }

            @Override
            public PointFeature next() {
                double obsTime = this.timeAxis != null ? this.timeAxis.getCoordMidpoint(this.curr) : 0.0;
                StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
                for (VarIter vi : this.varIters) {
                    smb.addMemberScalar(vi.cov.getName(), null, null, vi.cov.getDataType(), (Number)vi.dataIter.getObjectNext());
                }
                StructureDataFromMember coords = new StructureDataFromMember(smb.build());
                ++this.curr;
                CoverageAsPointFeature pf = new CoverageAsPointFeature(CoverageAsStationFeature.this, obsTime, 0.0, CoverageAsStationFeature.this.timeUnit, coords);
                this.calcBounds(pf);
                return pf;
            }

            @Override
            public void close() {
                this.finishCalcBounds();
            }
        }

        private class CoverageAsPointFeature
        extends PointFeatureImpl
        implements StationPointFeature {
            StationFeature stn;
            StructureData sdata;

            CoverageAsPointFeature(StationFeature stn, double obsTime, double nomTime, CalendarDateUnit timeUnit, StructureData sdata) {
                super(CoverageAsStationFeature.this, stn, obsTime, nomTime, timeUnit);
                this.stn = stn;
                this.sdata = sdata;
            }

            @Override
            @Nonnull
            public StationFeature getStation() {
                return this.stn;
            }

            @Override
            @Nonnull
            public StructureData getFeatureData() {
                return this.sdata;
            }

            @Override
            @Nonnull
            public StructureData getDataAll() {
                return this.sdata;
            }
        }

        private class VarIter {
            Coverage cov;
            GeoReferencedArray geoA;
            IndexIterator dataIter;

            VarIter(Coverage cov, GeoReferencedArray array, IndexIterator dataIter) {
                this.cov = cov;
                this.geoA = array;
                this.dataIter = dataIter;
            }
        }
    }

    private class CoverageAsStationProfile
    extends StationProfileFeatureImpl {
        private VarGroup varGroup;

        private CoverageAsStationProfile(String name, String desc, String wmoId, double lat, double lon, double alt, CalendarDateUnit timeUnit, String altUnits, int npts, VarGroup varGroup) {
            super(name, desc, wmoId, lat, lon, alt, timeUnit, altUnits, npts);
            this.varGroup = varGroup;
        }

        @Override
        public List<CalendarDate> getTimes() {
            return null;
        }

        @Override
        public ProfileFeature getProfileByDate(CalendarDate date) {
            return null;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return StructureData.EMPTY;
        }

        @Override
        public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
            return new TimeseriesProfileIterator();
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new TimeseriesProfileIterator();
        }

        private class TimeseriesProfileIterator
        implements PointFeatureCollectionIterator {
            int curr;
            int nvalues;
            List<VarIter> varIters;
            CoverageCoordAxis1D timeAxis;

            TimeseriesProfileIterator() {
                this.timeAxis = CoverageAsStationProfile.this.varGroup.timeAxis;
                this.nvalues = this.timeAxis != null ? this.timeAxis.getNcoords() : 1;
                this.varIters = new ArrayList<VarIter>();
                for (VarData vd : CoverageAsStationProfile.this.varGroup.varData) {
                    Array data = vd.array.getData();
                    this.varIters.add(new VarIter(vd.cov, vd.array, data.getIndexIterator()));
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.curr < this.nvalues;
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                double obsTime = this.timeAxis != null ? this.timeAxis.getCoordMidpoint(this.curr) : 0.0;
                ++this.curr;
                return new CoverageAsProfileFeature(obsTime, CoverageAsStationProfile.this.varGroup.dateUnit, CoverageAsStationProfile.this.varGroup.zUnit, CoverageAsStationProfile.this.getLatitude(), CoverageAsStationProfile.this.getLongitude(), this.varIters);
            }
        }

        private class CoverageAsPointFeature
        extends PointFeatureImpl
        implements StationPointFeature {
            StationFeature stn;
            StructureData sdata;

            CoverageAsPointFeature(StationFeature stn, double obsTime, double nomTime, CalendarDateUnit timeUnit, EarthLocation location, StructureData sdata) {
                super(CoverageAsStationProfile.this, stn, obsTime, nomTime, timeUnit);
                this.stn = stn;
                this.sdata = sdata;
                this.location = location;
            }

            @Override
            @Nonnull
            public StationFeature getStation() {
                return this.stn;
            }

            @Override
            @Nonnull
            public StructureData getFeatureData() {
                return this.sdata;
            }

            @Override
            @Nonnull
            public StructureData getDataAll() {
                return this.sdata;
            }
        }

        private class CoverageAsProfileFeature
        extends ProfileFeatureImpl {
            List<VarIter> varIters;

            CoverageAsProfileFeature(double obsTime, CalendarDateUnit timeUnit, String altUnits, double lat, double lon, List<VarIter> varIters) {
                super("", timeUnit, altUnits, lat, lon, obsTime, -1);
                this.varIters = varIters;
            }

            @Override
            public PointFeatureIterator getPointFeatureIterator() throws IOException {
                return new ProfileFeatureIterator();
            }

            @Override
            @Nonnull
            public CalendarDate getTime() {
                return this.timeUnit != null ? this.timeUnit.makeCalendarDate(this.time) : CalendarDate.UNKNOWN;
            }

            @Override
            @Nonnull
            public StructureData getFeatureData() throws IOException {
                return StructureData.EMPTY;
            }

            private class ProfileFeatureIterator
            extends PointIteratorAbstract {
                int curr;
                int nvalues;

                ProfileFeatureIterator() {
                    this.nvalues = CoverageAsStationProfile.this.varGroup.zAxis.getNcoords();
                }

                @Override
                public boolean hasNext() {
                    boolean more;
                    boolean bl = more = this.curr < this.nvalues;
                    if (!more) {
                        this.close();
                    }
                    return more;
                }

                @Override
                public PointFeature next() {
                    double alt = CoverageAsStationProfile.this.varGroup.zAxis.getCoordMidpoint(this.curr);
                    StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
                    for (VarIter vi : CoverageAsProfileFeature.this.varIters) {
                        smb.addMemberScalar(vi.cov.getName(), null, null, vi.cov.getDataType(), (Number)vi.dataIter.getObjectNext());
                    }
                    StructureDataFromMember coords = new StructureDataFromMember(smb.build());
                    ++this.curr;
                    ProfilePoint location = new ProfilePoint(CoverageAsStationProfile.this.getLatitude(), CoverageAsStationProfile.this.getLongitude(), alt);
                    CoverageAsPointFeature pf = new CoverageAsPointFeature(CoverageAsStationProfile.this, CoverageAsProfileFeature.this.time, 0.0, CoverageAsProfileFeature.this.timeUnit, location, coords);
                    this.calcBounds(pf);
                    return pf;
                }

                @Override
                public void close() {
                    this.finishCalcBounds();
                }
            }

            private class ProfilePoint
            implements EarthLocation {
                private final double lat;
                private final double lon;
                private final double alt;
                private final LatLonPoint latlon;

                public ProfilePoint(double lat, double lon, double alt) {
                    this.lat = lat;
                    this.lon = lon;
                    this.alt = alt;
                    this.latlon = LatLonPoint.create(lat, lon);
                }

                @Override
                public double getLatitude() {
                    return this.lat;
                }

                @Override
                public double getLongitude() {
                    return this.lon;
                }

                @Override
                public double getAltitude() {
                    return this.alt;
                }

                @Override
                public LatLonPoint getLatLon() {
                    return this.latlon;
                }

                @Override
                public boolean isMissing() {
                    return false;
                }
            }
        }

        private class VarIter {
            Coverage cov;
            GeoReferencedArray geoA;
            IndexIterator dataIter;

            VarIter(Coverage cov, GeoReferencedArray array, IndexIterator dataIter) {
                this.cov = cov;
                this.geoA = array;
                this.dataIter = dataIter;
            }
        }
    }

    private class CoverageAsStationFeatureCollection
    extends StationTimeSeriesCollectionImpl {
        private VarGroup varGroup;

        CoverageAsStationFeatureCollection(VarGroup varGroup) {
            super(varGroup.name + " AsStationFeatureCollection", varGroup.dateUnit, varGroup.zUnit);
            this.timeName = varGroup.timeAxis != null ? varGroup.timeAxis.getName() : "time";
            this.timeUnit = varGroup.timeAxis != null ? varGroup.timeAxis.getCalendarDateUnit() : CalendarDateUnit.unixDateUnit;
            this.altName = varGroup.zAxis != null ? varGroup.zAxis.getName() : "altitude";
            this.varGroup = varGroup;
            this.collectionFeatureType = varGroup.fType;
        }

        @Override
        protected StationHelper createStationHelper() {
            StationHelper helper = new StationHelper();
            String name = String.format("GridPointRequestedAt[%s]", LatLonPoints.toString(CoverageAsPoint.this.latLonPoint, 3));
            name = StringUtil2.replace(name, ' ', "_");
            helper.addStation(this.createStationFeature(name));
            return helper;
        }

        private StationFeature createStationFeature(String name) {
            double stationZ = this.varGroup.zAxis != null ? this.varGroup.zAxis.getCoordMidpoint(0) : 0.0;
            return new CoverageAsStationFeature(name, name, null, CoverageAsPoint.this.nearestLatLonPoint.getLatitude(), CoverageAsPoint.this.nearestLatLonPoint.getLongitude(), stationZ, this.timeUnit, this.altUnits, -1, this.varGroup);
        }
    }

    private class CoverageAsStationProfileCollection
    extends StationProfileCollectionImpl {
        private VarGroup varGroup;

        CoverageAsStationProfileCollection(VarGroup varGroup) {
            super(varGroup.name + " AsStationProfileCollection", varGroup.dateUnit, varGroup.zUnit);
            this.timeName = varGroup.timeAxis != null ? varGroup.timeAxis.getName() : "time";
            this.altName = varGroup.zAxis != null ? varGroup.zAxis.getName() : "altitude";
            this.varGroup = varGroup;
            this.collectionFeatureType = varGroup.fType;
        }

        @Override
        public IOIterator<PointFeatureCC> getCollectionIterator() throws IOException {
            return null;
        }

        @Override
        public PointFeatureCCIterator getNestedPointFeatureCollectionIterator() throws IOException {
            return null;
        }

        @Override
        protected StationHelper createStationHelper() throws IOException {
            StationHelper helper = new StationHelper();
            String name = String.format("GridPointRequestedAt[%s]", LatLonPoints.toString(CoverageAsPoint.this.latLonPoint, 3));
            name = StringUtil2.replace(name, ' ', "_");
            helper.addStation(this.createStationFeature(name));
            return helper;
        }

        private StationFeature createStationFeature(String name) {
            double stationZ = this.varGroup.zAxis != null ? this.varGroup.zAxis.getCoordEdgeFirst() : 0.0;
            return new CoverageAsStationProfile(name, name, null, CoverageAsPoint.this.nearestLatLonPoint.getLatitude(), CoverageAsPoint.this.nearestLatLonPoint.getLongitude(), stationZ, this.timeUnit, this.altUnits, -1, this.varGroup);
        }
    }

    private class VarData {
        Coverage cov;
        GeoReferencedArray array;

        VarData(Coverage cov) throws IOException, InvalidRangeException {
            this.cov = cov;
            this.array = cov.readData(CoverageAsPoint.this.subset);
        }
    }
}

