/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.CF1Convention;
import ucar.nc2.internal.dataset.conv.DefaultConventions;
import ucar.nc2.internal.dataset.spi.CFSubConventionProvider;
import ucar.nc2.internal.ncml.NcmlReader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil2;

public class CoordSystemFactory {
    protected static Logger log = LoggerFactory.getLogger(CoordSystemFactory.class);
    public static final String resourcesDir = "resources/nj22/coords/";
    private static List<Convention> conventionList = new ArrayList<Convention>();
    private static Map<String, String> ncmlHash = new HashMap<String, String>();
    private static boolean useMaximalCoordSys = true;

    public static void registerNcml(String conventionName, String ncmlLocation) {
        ncmlHash.put(conventionName, ncmlLocation);
    }

    public static void registerConvention(String conventionName, CoordSystemBuilderFactory c) {
        CoordSystemFactory.registerConvention(conventionName, c, null);
    }

    public static void registerConvention(String conventionName, CoordSystemBuilderFactory factory, ConventionNameOk match) {
        conventionList.add(new Convention(conventionName, factory, match));
    }

    @Nullable
    private static CoordSystemBuilderFactory matchConvention(String convName) {
        for (Convention c : conventionList) {
            if (c.match == null && c.convName.equalsIgnoreCase(convName)) {
                return c.factory;
            }
            if (c.match == null || !c.match.isMatch(convName, c.convName)) continue;
            return c.factory;
        }
        return null;
    }

    public static void setUseMaximalCoordSys(boolean b) {
        useMaximalCoordSys = b;
    }

    public static boolean getUseMaximalCoordSys() {
        return useMaximalCoordSys;
    }

    public static List<String> breakupConventionNames(String convAttValue) {
        ArrayList<String> names = new ArrayList<String>();
        if (convAttValue.indexOf(44) > 0 || convAttValue.indexOf(59) > 0) {
            StringTokenizer stoke = new StringTokenizer(convAttValue, ",;");
            while (stoke.hasMoreTokens()) {
                String name = stoke.nextToken();
                names.add(name.trim());
            }
        } else if (convAttValue.indexOf(47) > 0) {
            StringTokenizer stoke = new StringTokenizer(convAttValue, "/");
            while (stoke.hasMoreTokens()) {
                String name = stoke.nextToken();
                names.add(name.trim());
            }
        } else {
            return ImmutableList.of(convAttValue);
        }
        return names;
    }

    public static String buildConventionAttribute(String mainConv, String ... convAtts) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(mainConv);
        for (String convs : convAtts) {
            if (convs == null) continue;
            List<String> ss = CoordSystemFactory.breakupConventionNames(convs);
            for (String s : ss) {
                if (CoordSystemFactory.matchConvention(s) != null) continue;
                result.add(s);
            }
        }
        boolean start = true;
        Formatter f = new Formatter();
        for (String s : result) {
            if (start) {
                f.format("%s", s);
            } else {
                f.format(", %s", s);
            }
            start = false;
        }
        return f.toString();
    }

    @Nonnull
    public static Optional<CoordSystemBuilder> factory(NetcdfDataset.Builder ds, CancelTask cancelTask) throws IOException {
        CoordSystemBuilderFactory potentialCoordSysFactory;
        List<String> convs;
        String convNcml;
        Group.Builder root = ds.rootGroup;
        String convName = root.getAttributeContainer().findAttributeString("Conventions", null);
        if (convName == null) {
            convName = root.getAttributeContainer().findAttributeString("Convention", null);
        }
        if (convName != null) {
            convName = convName.trim();
        }
        if (convName != null && (convNcml = ncmlHash.get(convName)) != null) {
            CoordSystemBuilder csb = new CoordSystemBuilder(ds);
            NcmlReader.wrapNcml(ds, convNcml, cancelTask);
            return Optional.of(csb);
        }
        CoordSystemBuilderFactory coordSysFactory = null;
        if (convName != null) {
            coordSysFactory = CoordSystemFactory.findConventionByName(convName);
        }
        if (coordSysFactory != null && ds.orgFile != null && coordSysFactory instanceof CF1Convention.Factory && (convs = CoordSystemFactory.breakupConventionNames(convName)).size() > 1 && (potentialCoordSysFactory = CoordSystemFactory.findCfSubConvention(ds.orgFile, convs)) != null && potentialCoordSysFactory instanceof CFSubConventionProvider) {
            coordSysFactory = potentialCoordSysFactory;
        }
        if (coordSysFactory == null && ds.orgFile != null) {
            coordSysFactory = CoordSystemFactory.findConventionByIsMine(ds.orgFile);
        }
        boolean isDefault = false;
        if (coordSysFactory == null) {
            coordSysFactory = new DefaultConventions.Factory();
            isDefault = true;
        }
        CoordSystemBuilder coordSystemBuilder = coordSysFactory.open(ds);
        if (convName == null) {
            coordSystemBuilder.addUserAdvice("No 'Conventions' global attribute.");
        } else if (isDefault) {
            coordSystemBuilder.addUserAdvice("No CoordSystemBuilder is defined for Conventions= '" + convName + "'\n");
        } else {
            coordSystemBuilder.setConventionUsed(coordSysFactory.getConventionName());
        }
        ds.rootGroup.addAttribute(new Attribute("_CoordSysBuilder", coordSystemBuilder.getClass().getName()));
        return Optional.of(coordSystemBuilder);
    }

    @Nullable
    private static CoordSystemBuilderFactory findConventionByIsMine(NetcdfFile orgFile) {
        for (Convention conv : conventionList) {
            CoordSystemBuilderFactory candidate = conv.factory;
            if (!candidate.isMine(orgFile)) continue;
            return candidate;
        }
        for (CoordSystemBuilderFactory csb : ServiceLoader.load(CoordSystemBuilderFactory.class)) {
            if (!csb.isMine(orgFile)) continue;
            return csb;
        }
        return null;
    }

    @Nullable
    private static CoordSystemBuilderFactory findCfSubConvention(NetcdfFile orgFile, List<String> convs) {
        for (Convention conv : conventionList) {
            CoordSystemBuilderFactory candidate = conv.factory;
            if (!(candidate instanceof CFSubConventionProvider) || !candidate.isMine(orgFile)) continue;
            return candidate;
        }
        for (CFSubConventionProvider cfSubCon : ServiceLoader.load(CFSubConventionProvider.class)) {
            if (!cfSubCon.isMine(orgFile) && !cfSubCon.isMine(convs)) continue;
            return cfSubCon;
        }
        return null;
    }

    @Nullable
    private static CoordSystemBuilderFactory findConventionByName(String convName) {
        CoordSystemBuilderFactory coordSysFactory = CoordSystemFactory.findRegisteredConventionByName(convName);
        if (coordSysFactory != null) {
            return coordSysFactory;
        }
        coordSysFactory = CoordSystemFactory.findLoadedConventionByName(convName);
        if (coordSysFactory != null) {
            return coordSysFactory;
        }
        List<String> names = CoordSystemFactory.breakupConventionNames(convName);
        for (String name : names) {
            coordSysFactory = CoordSystemFactory.findRegisteredConventionByName(name);
            if (coordSysFactory == null) continue;
            return coordSysFactory;
        }
        for (String name : names) {
            coordSysFactory = CoordSystemFactory.findLoadedConventionByName(name);
            if (coordSysFactory == null) continue;
            return coordSysFactory;
        }
        Iterable<String> tokens = StringUtil2.split(convName);
        for (String name : tokens) {
            coordSysFactory = CoordSystemFactory.findRegisteredConventionByName(name);
            if (coordSysFactory == null) continue;
            return coordSysFactory;
        }
        for (String name : tokens) {
            coordSysFactory = CoordSystemFactory.findLoadedConventionByName(name);
            if (coordSysFactory == null) continue;
            return coordSysFactory;
        }
        return null;
    }

    private static CoordSystemBuilderFactory findRegisteredConventionByName(String convName) {
        return CoordSystemFactory.matchConvention(convName);
    }

    @Nullable
    private static CoordSystemBuilderFactory findLoadedConventionByName(String convName) {
        for (CoordSystemBuilderFactory csb : ServiceLoader.load(CoordSystemBuilderFactory.class)) {
            if (!convName.equals(csb.getConventionName())) continue;
            return csb;
        }
        return null;
    }

    static {
        CoordSystemFactory.registerConvention("_Coordinates", new CoordSystemBuilder.Factory());
        for (CFSubConventionProvider provider : ServiceLoader.load(CFSubConventionProvider.class)) {
            CoordSystemFactory.registerConvention(provider.getConventionName(), provider);
        }
        CoordSystemFactory.registerConvention("CF-1.", new CF1Convention.Factory(), String::startsWith);
        CoordSystemFactory.registerConvention("CDM-Extended-CF", new CF1Convention.Factory());
        CoordSystemFactory.registerConvention("MARS", new DefaultConventions.Factory());
    }

    public static interface ConventionNameOk {
        public boolean isMatch(String var1, String var2);
    }

    private static class Convention {
        String convName;
        CoordSystemBuilderFactory factory;
        ConventionNameOk match;

        Convention(String convName, CoordSystemBuilderFactory factory, ConventionNameOk match) {
            this.convName = convName;
            this.factory = factory;
            this.match = match;
        }
    }
}

