/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.UtmProjection;

public class M3IOConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "M3IO";
    private static final double earthRadius = 6370.0;
    private ProjectionCT projCT;

    private M3IOConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        boolean isLatLon;
        if (this.rootGroup.findVariableLocal("x").isPresent() || this.rootGroup.findVariableLocal("lon").isPresent()) {
            return;
        }
        int projType = this.rootGroup.getAttributeContainer().findAttributeInteger("GDTYP", 1);
        boolean bl = isLatLon = projType == 1;
        if (isLatLon) {
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeCoordLLAxis("lon", "COL", "XORIG", "XCELL", "degrees east"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeCoordLLAxis("lat", "ROW", "YORIG", "YCELL", "degrees north"));
            this.projCT = this.makeLatLongProjection();
            VariableDS.Builder v = this.makeCoordinateTransformVariable(this.projCT);
            this.rootGroup.addVariable(v);
            v.addAttribute(new Attribute("_CoordinateAxes", "lon lat"));
        } else {
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeCoordAxis("x", "COL", "XORIG", "XCELL", "km"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeCoordAxis("y", "ROW", "YORIG", "YCELL", "km"));
            if (projType == 2) {
                this.projCT = this.makeLCProjection();
            } else if (projType == 3) {
                this.projCT = this.makeTMProjection();
            } else if (projType == 4) {
                this.projCT = this.makeSTProjection();
            } else if (projType == 5) {
                this.projCT = this.makeUTMProjection();
            } else if (projType == 6) {
                this.projCT = this.makePolarStereographicProjection();
            } else if (projType == 7) {
                this.projCT = this.makeEquitorialMercatorProjection();
            } else if (projType == 8) {
                this.projCT = this.makeTransverseMercatorProjection();
            } else if (projType == 9) {
                this.projCT = this.makeAlbersProjection();
            } else if (projType == 10) {
                this.projCT = this.makeLambertAzimuthalProjection();
            }
            if (this.projCT != null) {
                VariableDS.Builder v = this.makeCoordinateTransformVariable(this.projCT);
                this.rootGroup.addVariable(v);
                v.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            }
        }
        this.makeZCoordAxis("LAY", "VGLVLS", "sigma");
        this.makeTimeCoordAxis("TSTEP");
    }

    @Override
    protected void makeCoordinateTransforms() {
        if (this.projCT != null) {
            CoordSystemBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = CoordinateTransform.builder().setPreBuilt(this.projCT);
        }
        super.makeCoordinateTransforms();
    }

    private CoordinateAxis.Builder makeCoordAxis(String name, String dimName, String startName, String incrName, String unitName) {
        double start = 0.001 * this.findAttributeDouble(startName);
        double incr = 0.001 * this.findAttributeDouble(incrName);
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimName)).setUnits(unitName)).setDesc("synthesized coordinate from " + startName + " " + incrName + " global attributes");
        v.setAutoGen(start += incr / 2.0, incr);
        return v;
    }

    private CoordinateAxis.Builder makeCoordLLAxis(String name, String dimName, String startName, String incrName, String unitName) {
        double start = this.findAttributeDouble(startName);
        double incr = this.findAttributeDouble(incrName);
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimName)).setUnits(unitName)).setDesc("synthesized coordinate from " + startName + " " + incrName + " global attributes");
        v.setAutoGen(start += incr / 2.0, incr);
        return v;
    }

    private void makeZCoordAxis(String dimName, String levelsName, String unitName) {
        int i;
        Dimension dimz = this.rootGroup.findDimension(dimName).get();
        int nz = dimz.getLength();
        ArrayDouble.D1 dataLev = new ArrayDouble.D1(nz);
        ArrayDouble.D1 dataLayers = new ArrayDouble.D1(nz + 1);
        Attribute layers = this.rootGroup.getAttributeContainer().findAttribute(levelsName);
        for (i = 0; i <= nz; ++i) {
            dataLayers.set(i, layers.getNumericValue(i).doubleValue());
        }
        for (i = 0; i < nz; ++i) {
            double midpoint = (dataLayers.get(i) + dataLayers.get(i + 1)) / 2.0;
            dataLev.set(i, midpoint);
        }
        CoordinateAxis.Builder v = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName("level")).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimName)).setUnits(unitName)).setDesc("synthesized coordinate from " + levelsName + " global attributes");
        v.setCachedData(dataLev, true);
        v.addAttribute(new Attribute("positive", "down"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoZ.toString()));
        String edge_name = "layer";
        Dimension lay_edge = new Dimension(edge_name, nz + 1);
        this.rootGroup.addDimension(lay_edge);
        CoordinateAxis.Builder vedge = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(edge_name)).setDataType(DataType.DOUBLE)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(edge_name)).setUnits(unitName)).setDesc("synthesized coordinate from " + levelsName + " global attributes");
        vedge.setCachedData(dataLayers, true);
        v.setBoundary(edge_name);
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, v);
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, vedge);
    }

    private void makeTimeCoordAxis(String timeName) {
        int start_date = this.findAttributeInt("SDATE");
        int start_time = this.findAttributeInt("STIME");
        int time_step = this.findAttributeInt("TSTEP");
        int year = start_date / 1000;
        int doy = start_date % 1000;
        int hour = start_time / 10000;
        int min = (start_time %= 10000) / 100;
        int sec = start_time % 100;
        GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
        cal.clear();
        cal.set(1, year);
        cal.set(6, doy);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        SimpleDateFormat dateFormatOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        String units = "seconds since " + dateFormatOut.format(cal.getTime()) + " UTC";
        hour = time_step / 10000;
        min = (time_step %= 10000) / 100;
        sec = time_step % 100;
        time_step = hour * 3600 + min * 60 + sec;
        CoordinateAxis1D.Builder timeCoord = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName("time")).setDataType(DataType.INT)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(timeName)).setUnits(units)).setDesc("synthesized time coordinate from SDATE, STIME, STEP global attributes");
        timeCoord.setAutoGen(0.0, time_step);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, timeCoord);
    }

    private ProjectionCT makeLatLongProjection() {
        double x1 = this.findAttributeDouble("XORIG");
        double y1 = this.findAttributeDouble("YORIG");
        double x2 = x1 + this.findAttributeDouble("XCELL") * this.findAttributeDouble("NCOLS");
        double y2 = y1 + this.findAttributeDouble("YCELL") * this.findAttributeDouble("NROWS");
        LatLonProjection ll = new LatLonProjection("LatitudeLongitudeProjection", new ProjectionRect(x1, y1, x2, y2));
        return new ProjectionCT("LatitudeLongitudeProjection", "FGDC", ll);
    }

    private ProjectionCT makeLCProjection() {
        double par1 = this.findAttributeDouble("P_ALP");
        double par2 = this.findAttributeDouble("P_BET");
        double lon0 = this.findAttributeDouble("XCENT");
        double lat0 = this.findAttributeDouble("YCENT");
        LambertConformal lc = new LambertConformal(lat0, lon0, par1, par2, 0.0, 0.0, 6370.0);
        return new ProjectionCT("LambertConformalProjection", "FGDC", lc);
    }

    private ProjectionCT makePolarStereographicProjection() {
        double lon0 = this.findAttributeDouble("XCENT");
        double lat0 = this.findAttributeDouble("YCENT");
        double latts = this.findAttributeDouble("P_BET");
        Stereographic sg = new Stereographic(latts, lat0, lon0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("PolarStereographic", "FGDC", sg);
    }

    private ProjectionCT makeEquitorialMercatorProjection() {
        double lon0 = this.findAttributeDouble("XCENT");
        double par = this.findAttributeDouble("P_ALP");
        Mercator p = new Mercator(lon0, par, 0.0, 0.0, 6370.0);
        return new ProjectionCT("EquitorialMercator", "FGDC", p);
    }

    private ProjectionCT makeTransverseMercatorProjection() {
        double lat0 = this.findAttributeDouble("P_ALP");
        double tangentLon = this.findAttributeDouble("P_GAM");
        TransverseMercator p = new TransverseMercator(lat0, tangentLon, 1.0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("TransverseMercator", "FGDC", p);
    }

    private ProjectionCT makeAlbersProjection() {
        double lat0 = this.findAttributeDouble("YCENT");
        double lon0 = this.findAttributeDouble("XCENT");
        double par1 = this.findAttributeDouble("P_ALP");
        double par2 = this.findAttributeDouble("P_BET");
        AlbersEqualArea p = new AlbersEqualArea(lat0, lon0, par1, par2, 0.0, 0.0, 6370.0);
        return new ProjectionCT("Albers", "FGDC", p);
    }

    private ProjectionCT makeLambertAzimuthalProjection() {
        double lat0 = this.findAttributeDouble("YCENT");
        double lon0 = this.findAttributeDouble("XCENT");
        LambertAzimuthalEqualArea p = new LambertAzimuthalEqualArea(lat0, lon0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("LambertAzimuthal", "FGDC", p);
    }

    private ProjectionCT makeSTProjection() {
        double lont;
        double latt = this.findAttributeDouble("PROJ_ALPHA");
        if (Double.isNaN(latt)) {
            latt = this.findAttributeDouble("P_ALP");
        }
        if (Double.isNaN(lont = this.findAttributeDouble("PROJ_BETA"))) {
            lont = this.findAttributeDouble("P_BET");
        }
        Stereographic st = new Stereographic(latt, lont, 1.0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("StereographicProjection", "FGDC", st);
    }

    private ProjectionCT makeTMProjection() {
        double tangentLon;
        double lat0 = this.findAttributeDouble("PROJ_ALPHA");
        if (Double.isNaN(lat0)) {
            lat0 = this.findAttributeDouble("P_ALP");
        }
        if (Double.isNaN(tangentLon = this.findAttributeDouble("PROJ_BETA"))) {
            tangentLon = this.findAttributeDouble("P_BET");
        }
        TransverseMercator tm = new TransverseMercator(lat0, tangentLon, 1.0, 0.0, 0.0, 6370.0);
        return new ProjectionCT("MercatorProjection", "FGDC", tm);
    }

    private ProjectionCT makeUTMProjection() {
        int zone = (int)this.findAttributeDouble("P_ALP");
        double ycent = this.findAttributeDouble("YCENT");
        boolean isNorth = true;
        if (ycent < 0.0) {
            isNorth = false;
        }
        UtmProjection utm = new UtmProjection(zone, isNorth);
        return new ProjectionCT("UTM", "EPSG", utm);
    }

    @Override
    protected AxisType getAxisType(VariableDS.Builder ve) {
        String vname = ve.shortName;
        if (vname.equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        if (vname.equalsIgnoreCase("level")) {
            return AxisType.GeoZ;
        }
        return null;
    }

    private double findAttributeDouble(String attname) {
        return this.rootGroup.getAttributeContainer().findAttributeDouble(attname, Double.NaN);
    }

    private int findAttributeInt(String attname) {
        return this.rootGroup.getAttributeContainer().findAttributeInteger(attname, 0);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return M3IOConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            return null != ncfile.findGlobalAttribute("XORIG") && null != ncfile.findGlobalAttribute("YORIG") && null != ncfile.findGlobalAttribute("XCELL") && null != ncfile.findGlobalAttribute("YCELL") && null != ncfile.findGlobalAttribute("NCOLS") && null != ncfile.findGlobalAttribute("NROWS");
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new M3IOConvention(datasetBuilder);
        }
    }
}

