/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.IndexChunkerTiled;
import ucar.nc2.iosp.LayoutBB;

public class LayoutBBTiled
implements LayoutBB {
    private Section want;
    private int[] chunkSize;
    private int elemSize;
    private DataChunkIterator chunkIterator;
    private IndexChunkerTiled index;
    private long totalNelems;
    private long totalNelemsDone;
    private static final boolean debug = false;
    private static final boolean debugIntersection = false;
    private Chunk next;

    public LayoutBBTiled(DataChunkIterator chunkIterator, int[] chunkSize, int elemSize, Section wantSection) {
        this.chunkIterator = chunkIterator;
        this.chunkSize = chunkSize;
        this.elemSize = elemSize;
        this.want = wantSection;
        this.totalNelems = this.want.computeSize();
        this.totalNelemsDone = 0L;
    }

    @Override
    public long getTotalNelems() {
        return this.totalNelems;
    }

    @Override
    public int getElemSize() {
        return this.elemSize;
    }

    @Override
    public boolean hasNext() {
        if (this.totalNelemsDone >= this.totalNelems) {
            return false;
        }
        if (this.index == null || !this.index.hasNext()) {
            try {
                DataChunk dataChunk;
                Section dataSection;
                do {
                    if (!this.chunkIterator.hasNext()) {
                        this.next = null;
                        return false;
                    }
                    try {
                        dataChunk = this.chunkIterator.next();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.next = null;
                        return false;
                    }
                } while (!(dataSection = new Section(dataChunk.getOffset(), this.chunkSize)).intersects(this.want));
                this.index = new IndexChunkerTiled(dataSection, this.want);
                this.next = new Chunk(dataChunk.getByteBuffer());
            }
            catch (IOException | InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }
        IndexChunker.Chunk chunk = this.index.next();
        this.totalNelemsDone += (long)chunk.getNelems();
        this.next.setDelegate(chunk);
        return true;
    }

    @Override
    public LayoutBB.Chunk next() {
        return this.next;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("want=").append(this.want).append("; ");
        sbuff.append("chunkSize=[");
        for (int i = 0; i < this.chunkSize.length; ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.chunkSize[i]);
        }
        sbuff.append("] totalNelems=").append(this.totalNelems);
        sbuff.append(" elemSize=").append(this.elemSize);
        return sbuff.toString();
    }

    public static interface DataChunkIterator {
        public boolean hasNext();

        public DataChunk next() throws IOException;
    }

    private static class Chunk
    implements LayoutBB.Chunk {
        IndexChunker.Chunk delegate;
        private ByteBuffer bb;
        private ShortBuffer sb;
        private IntBuffer ib;
        private LongBuffer longb;
        private FloatBuffer fb;
        private DoubleBuffer db;

        Chunk(ByteBuffer bb) {
            this.bb = bb;
        }

        public void setDelegate(IndexChunker.Chunk delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getSrcElem() {
            return (int)this.delegate.getSrcElem();
        }

        @Override
        public int getNelems() {
            return this.delegate.getNelems();
        }

        @Override
        public long getDestElem() {
            return this.delegate.getDestElem();
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.bb;
        }

        @Override
        public ShortBuffer getShortBuffer() {
            if (this.sb == null) {
                this.sb = this.bb.asShortBuffer();
            }
            return this.sb;
        }

        @Override
        public IntBuffer getIntBuffer() {
            if (this.ib == null) {
                this.ib = this.bb.asIntBuffer();
            }
            return this.ib;
        }

        @Override
        public LongBuffer getLongBuffer() {
            if (this.longb == null) {
                this.longb = this.bb.asLongBuffer();
            }
            return this.longb;
        }

        @Override
        public FloatBuffer getFloatBuffer() {
            if (this.fb == null) {
                this.fb = this.bb.asFloatBuffer();
            }
            return this.fb;
        }

        @Override
        public DoubleBuffer getDoubleBuffer() {
            if (this.db == null) {
                this.db = this.bb.asDoubleBuffer();
            }
            return this.db;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public long getSrcPos() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface DataChunk {
        public int[] getOffset();

        public ByteBuffer getByteBuffer() throws IOException;
    }
}

