/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.hdf5.BTree2;
import ucar.nc2.iosp.hdf5.H5headerIF;
import ucar.nc2.iosp.hdf5.MemTracker;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.SpecialMathFunction;

public class FractalHeap {
    private static Logger log = LoggerFactory.getLogger(FractalHeap.class);
    private PrintStream debugOut = System.out;
    static boolean debugDetail;
    static boolean debugFractalHeap;
    static boolean debugPos;
    private final H5headerIF h5;
    private final RandomAccessFile raf;
    int version;
    short heapIdLen;
    byte flags;
    int maxSizeOfObjects;
    long nextHugeObjectId;
    long freeSpace;
    long managedSpace;
    long allocatedManagedSpace;
    long offsetDirectBlock;
    long nManagedObjects;
    long sizeHugeObjects;
    long nHugeObjects;
    long sizeTinyObjects;
    long nTinyObjects;
    long btreeAddressHugeObjects;
    long freeSpaceTrackerAddress;
    short maxHeapSize;
    short startingNumRows;
    short currentNumRows;
    long maxDirectBlockSize;
    short tableWidth;
    long startingBlockSize;
    long rootBlockAddress;
    IndirectBlock rootBlock;
    short ioFilterLen;
    long sizeFilteredRootDirectBlock;
    int ioFilterMask;
    byte[] ioFilterInfo;
    DoublingTable doublingTable;
    BTree2 btreeHugeObjects;

    public FractalHeap(H5headerIF h5, String forWho, long address, MemTracker memTracker) throws IOException {
        boolean hasFilters;
        String magic;
        this.h5 = h5;
        this.raf = h5.getRandomAccessFile();
        this.raf.order(1);
        this.raf.seek(h5.getFileOffset(address));
        if (debugDetail) {
            this.debugOut.println("-- readFractalHeap position=" + this.raf.getFilePointer());
        }
        if (!(magic = this.raf.readString(4)).equals("FRHP")) {
            throw new IllegalStateException(magic + " should equal FRHP");
        }
        this.version = this.raf.readByte();
        this.heapIdLen = this.raf.readShort();
        this.ioFilterLen = this.raf.readShort();
        this.flags = this.raf.readByte();
        this.maxSizeOfObjects = this.raf.readInt();
        this.nextHugeObjectId = h5.readLength();
        this.btreeAddressHugeObjects = h5.readOffset();
        this.freeSpace = h5.readLength();
        this.freeSpaceTrackerAddress = h5.readOffset();
        this.managedSpace = h5.readLength();
        this.allocatedManagedSpace = h5.readLength();
        this.offsetDirectBlock = h5.readLength();
        this.nManagedObjects = h5.readLength();
        this.sizeHugeObjects = h5.readLength();
        this.nHugeObjects = h5.readLength();
        this.sizeTinyObjects = h5.readLength();
        this.nTinyObjects = h5.readLength();
        this.tableWidth = this.raf.readShort();
        this.startingBlockSize = h5.readLength();
        this.maxDirectBlockSize = h5.readLength();
        this.maxHeapSize = this.raf.readShort();
        this.startingNumRows = this.raf.readShort();
        this.rootBlockAddress = h5.readOffset();
        this.currentNumRows = this.raf.readShort();
        boolean bl = hasFilters = this.ioFilterLen > 0;
        if (hasFilters) {
            this.sizeFilteredRootDirectBlock = h5.readLength();
            this.ioFilterMask = this.raf.readInt();
            this.ioFilterInfo = new byte[this.ioFilterLen];
            this.raf.readFully(this.ioFilterInfo);
        }
        int checksum = this.raf.readInt();
        if (debugDetail || debugFractalHeap) {
            this.debugOut.println("FractalHeap for " + forWho + " version=" + this.version + " heapIdLen=" + this.heapIdLen + " ioFilterLen=" + this.ioFilterLen + " flags= " + this.flags);
            this.debugOut.println(" maxSizeOfObjects=" + this.maxSizeOfObjects + " nextHugeObjectId=" + this.nextHugeObjectId + " btreeAddress=" + this.btreeAddressHugeObjects + " managedSpace=" + this.managedSpace + " allocatedManagedSpace=" + this.allocatedManagedSpace + " freeSpace=" + this.freeSpace);
            this.debugOut.println(" nManagedObjects=" + this.nManagedObjects + " nHugeObjects= " + this.nHugeObjects + " nTinyObjects=" + this.nTinyObjects + " maxDirectBlockSize=" + this.maxDirectBlockSize + " maxHeapSize= 2^" + this.maxHeapSize);
            this.debugOut.println(" DoublingTable: tableWidth=" + this.tableWidth + " startingBlockSize=" + this.startingBlockSize);
            this.debugOut.println(" rootBlockAddress=" + this.rootBlockAddress + " startingNumRows=" + this.startingNumRows + " currentNumRows=" + this.currentNumRows);
        }
        if (debugPos) {
            this.debugOut.println("    *now at position=" + this.raf.getFilePointer());
        }
        long pos = this.raf.getFilePointer();
        if (debugDetail) {
            this.debugOut.println("-- end FractalHeap position=" + this.raf.getFilePointer());
        }
        int hsize = 8 + 2 * h5.getSizeLengths() + h5.getSizeOffsets();
        if (memTracker != null) {
            memTracker.add("Group FractalHeap (" + forWho + ")", address, pos);
        }
        this.doublingTable = new DoublingTable(this.tableWidth, this.startingBlockSize, this.allocatedManagedSpace, this.maxDirectBlockSize);
        this.rootBlock = new IndirectBlock(this.currentNumRows, this.startingBlockSize);
        if (this.currentNumRows == 0) {
            DataBlock dblock = new DataBlock();
            this.doublingTable.blockList.add(dblock);
            this.readDirectBlock(h5.getFileOffset(this.rootBlockAddress), address, dblock);
            dblock.size = this.startingBlockSize;
            this.rootBlock.add(dblock);
        } else {
            this.readIndirectBlock(this.rootBlock, h5.getFileOffset(this.rootBlockAddress), address, hasFilters);
            for (DataBlock dblock : this.doublingTable.blockList) {
                if (dblock.address <= 0L) continue;
                this.readDirectBlock(h5.getFileOffset(dblock.address), address, dblock);
            }
        }
    }

    public void showDetails(Formatter f) {
        f.format("FractalHeap version=" + this.version + " heapIdLen=" + this.heapIdLen + " ioFilterLen=" + this.ioFilterLen + " flags= " + this.flags + "%n", new Object[0]);
        f.format(" maxSizeOfObjects=" + this.maxSizeOfObjects + " nextHugeObjectId=" + this.nextHugeObjectId + " btreeAddress=" + this.btreeAddressHugeObjects + " managedSpace=" + this.managedSpace + " allocatedManagedSpace=" + this.allocatedManagedSpace + " freeSpace=" + this.freeSpace + "%n", new Object[0]);
        f.format(" nManagedObjects=" + this.nManagedObjects + " nHugeObjects= " + this.nHugeObjects + " nTinyObjects=" + this.nTinyObjects + " maxDirectBlockSize=" + this.maxDirectBlockSize + " maxHeapSize= 2^" + this.maxHeapSize + "%n", new Object[0]);
        f.format(" rootBlockAddress=" + this.rootBlockAddress + " startingNumRows=" + this.startingNumRows + " currentNumRows=" + this.currentNumRows + "%n%n", new Object[0]);
        this.rootBlock.showDetails(f);
    }

    public DHeapId getFractalHeapId(byte[] heapId) {
        return new DHeapId(heapId);
    }

    void readIndirectBlock(IndirectBlock iblock, long pos, long heapAddress, boolean hasFilter) throws IOException {
        int i;
        int row;
        this.raf.seek(pos);
        String magic = this.raf.readString(4);
        if (!magic.equals("FHIB")) {
            throw new IllegalStateException(magic + " should equal FHIB");
        }
        byte version = this.raf.readByte();
        long heapHeaderAddress = this.h5.readOffset();
        if (heapAddress != heapHeaderAddress) {
            throw new IllegalStateException();
        }
        int nbytes = this.maxHeapSize / 8;
        if (this.maxHeapSize % 8 != 0) {
            ++nbytes;
        }
        long blockOffset = this.h5.readVariableSizeUnsigned(nbytes);
        if (debugDetail || debugFractalHeap) {
            this.debugOut.println(" -- FH IndirectBlock version=" + version + " blockOffset= " + blockOffset);
        }
        long npos = this.raf.getFilePointer();
        if (debugPos) {
            this.debugOut.println("    *now at position=" + npos);
        }
        long blockSize = this.startingBlockSize;
        for (row = 0; row < iblock.directRows; ++row) {
            if (row > 1) {
                blockSize *= 2L;
            }
            for (i = 0; i < this.doublingTable.tableWidth; ++i) {
                DataBlock directBlock = new DataBlock();
                iblock.add(directBlock);
                directBlock.address = this.h5.readOffset();
                if (hasFilter) {
                    directBlock.sizeFilteredDirectBlock = this.h5.readLength();
                    directBlock.filterMask = this.raf.readInt();
                }
                if (debugDetail || debugFractalHeap) {
                    this.debugOut.println("  DirectChild " + i + " address= " + directBlock.address);
                }
                directBlock.size = blockSize;
                this.doublingTable.blockList.add(directBlock);
            }
        }
        for (row = 0; row < iblock.indirectRows; ++row) {
            blockSize *= 2L;
            for (i = 0; i < this.doublingTable.tableWidth; ++i) {
                IndirectBlock iblock2 = new IndirectBlock(-1, blockSize);
                iblock.add(iblock2);
                long childIndirectAddress = this.h5.readOffset();
                if (debugDetail || debugFractalHeap) {
                    this.debugOut.println("  InDirectChild " + row + " address= " + childIndirectAddress);
                }
                if (childIndirectAddress < 0L) continue;
                this.readIndirectBlock(iblock2, childIndirectAddress, heapAddress, hasFilter);
            }
        }
    }

    void readDirectBlock(long pos, long heapAddress, DataBlock dblock) throws IOException {
        if (pos < 0L) {
            return;
        }
        this.raf.seek(pos);
        String magic = this.raf.readString(4);
        if (!magic.equals("FHDB")) {
            throw new IllegalStateException(magic + " should equal FHDB");
        }
        byte version = this.raf.readByte();
        long heapHeaderAddress = this.h5.readOffset();
        if (heapAddress != heapHeaderAddress) {
            throw new IllegalStateException();
        }
        dblock.extraBytes = 5;
        dblock.extraBytes = dblock.extraBytes + (this.h5.isOffsetLong() ? 8 : 4);
        int nbytes = this.maxHeapSize / 8;
        if (this.maxHeapSize % 8 != 0) {
            ++nbytes;
        }
        dblock.offset = this.h5.readVariableSizeUnsigned(nbytes);
        dblock.dataPos = pos;
        dblock.extraBytes += nbytes;
        if ((this.flags & 2) != 0) {
            dblock.extraBytes += 4;
        }
        dblock.wasRead = true;
        if (debugDetail || debugFractalHeap) {
            this.debugOut.println("  DirectBlock offset= " + dblock.offset + " dataPos = " + dblock.dataPos);
        }
    }

    private class DoublingTable {
        int tableWidth;
        long startingBlockSize;
        long managedSpace;
        long maxDirectBlockSize;
        List<DataBlock> blockList;

        DoublingTable(int tableWidth, long startingBlockSize, long managedSpace, long maxDirectBlockSize) {
            this.tableWidth = tableWidth;
            this.startingBlockSize = startingBlockSize;
            this.managedSpace = managedSpace;
            this.maxDirectBlockSize = maxDirectBlockSize;
            this.blockList = new ArrayList<DataBlock>(tableWidth * FractalHeap.this.currentNumRows);
        }

        private int calcNrows(long max) {
            int n = 0;
            long blockSize = this.startingBlockSize;
            for (long sizeInBytes = 0L; sizeInBytes < max; sizeInBytes += blockSize * (long)this.tableWidth) {
                if (++n <= 1) continue;
                blockSize *= 2L;
            }
            return n;
        }

        private void assignSizes() {
            int block = 0;
            long blockSize = this.startingBlockSize;
            for (DataBlock db : this.blockList) {
                db.size = blockSize;
                if (++block % this.tableWidth != 0 || block / this.tableWidth <= 1) continue;
                blockSize *= 2L;
            }
        }

        long getPos(long offset) {
            int block = 0;
            for (DataBlock db : this.blockList) {
                if (db.address < 0L) continue;
                if (offset >= db.offset && offset <= db.offset + db.size) {
                    long localOffset = offset - db.offset;
                    return db.dataPos + localOffset;
                }
                ++block;
            }
            log.error("DoublingTable: illegal offset=" + offset);
            throw new IllegalStateException("offset=" + offset);
        }

        void showDetails(Formatter f) {
            f.format(" DoublingTable: tableWidth= %d startingBlockSize = %d managedSpace=%d maxDirectBlockSize=%d%n", this.tableWidth, this.startingBlockSize, this.managedSpace, this.maxDirectBlockSize);
            f.format(" DataBlocks:%n", new Object[0]);
            f.format("  address            dataPos            offset size%n", new Object[0]);
            for (DataBlock dblock : this.blockList) {
                f.format("  %#-18x %#-18x %5d  %4d%n", dblock.address, dblock.dataPos, dblock.offset, dblock.size);
            }
        }
    }

    private class IndirectBlock {
        long size;
        int nrows;
        int directRows;
        int indirectRows;
        List<DataBlock> directBlocks;
        List<IndirectBlock> indirectBlocks;

        IndirectBlock(int nrows, long iblock_size) {
            int maxrows_directBlocks;
            this.nrows = nrows;
            this.size = iblock_size;
            if (nrows < 0) {
                double n = SpecialMathFunction.log2(iblock_size) - SpecialMathFunction.log2(FractalHeap.this.startingBlockSize * (long)FractalHeap.this.tableWidth) + 1.0;
                nrows = (int)n;
            }
            if (nrows < (maxrows_directBlocks = (int)(SpecialMathFunction.log2(FractalHeap.this.maxDirectBlockSize) - SpecialMathFunction.log2(FractalHeap.this.startingBlockSize)) + 2)) {
                this.directRows = nrows;
                this.indirectRows = 0;
            } else {
                this.directRows = maxrows_directBlocks;
                this.indirectRows = nrows - maxrows_directBlocks;
            }
            if (debugFractalHeap) {
                FractalHeap.this.debugOut.println("  readIndirectBlock directChildren" + this.directRows + " indirectChildren= " + this.indirectRows);
            }
        }

        void add(DataBlock dblock) {
            if (this.directBlocks == null) {
                this.directBlocks = new ArrayList<DataBlock>();
            }
            this.directBlocks.add(dblock);
        }

        void add(IndirectBlock iblock) {
            if (this.indirectBlocks == null) {
                this.indirectBlocks = new ArrayList<IndirectBlock>();
            }
            this.indirectBlocks.add(iblock);
        }

        void showDetails(Formatter f) {
            f.format("%n IndirectBlock: nrows= %d directRows = %d indirectRows=%d startingSize=%d%n", this.nrows, this.directRows, this.indirectRows, this.size);
            f.format(" DataBlocks:%n", new Object[0]);
            f.format("  address            dataPos            offset size end%n", new Object[0]);
            if (this.directBlocks != null) {
                for (DataBlock dblock : this.directBlocks) {
                    f.format("  %#-18x %#-18x %5d  %4d %5d %n", dblock.address, dblock.dataPos, dblock.offset, dblock.size, dblock.offset + dblock.size);
                }
            }
            if (this.indirectBlocks != null) {
                for (IndirectBlock iblock : this.indirectBlocks) {
                    iblock.showDetails(f);
                }
            }
        }
    }

    private static class DataBlock {
        long address;
        long sizeFilteredDirectBlock;
        int filterMask;
        long dataPos;
        long offset;
        long size;
        int extraBytes;
        boolean wasRead;

        private DataBlock() {
        }

        public String toString() {
            return "DataBlock{offset=" + this.offset + ", size=" + this.size + ", dataPos=" + this.dataPos + '}';
        }
    }

    public class DHeapId {
        int type;
        int subtype;
        int n;
        int m;
        int offset;
        int size;

        DHeapId(byte[] heapId) {
            this.type = (heapId[0] & 0x30) >> 4;
            if (this.type == 0) {
                this.n = FractalHeap.this.maxHeapSize / 8;
                this.m = FractalHeap.this.h5.getNumBytesFromMax(FractalHeap.this.maxDirectBlockSize - 1L);
                this.offset = FractalHeap.this.h5.makeIntFromBytes(heapId, 1, this.n);
                this.size = FractalHeap.this.h5.makeIntFromBytes(heapId, 1 + this.n, this.m);
            } else if (this.type == 1) {
                boolean hasFilters;
                boolean hasBtree = FractalHeap.this.btreeAddressHugeObjects > 0L;
                boolean bl = hasFilters = FractalHeap.this.ioFilterLen > 0;
                this.subtype = hasBtree ? (hasFilters ? 2 : 1) : (hasFilters ? 4 : 3);
                switch (this.subtype) {
                    case 1: 
                    case 2: {
                        this.offset = FractalHeap.this.h5.makeIntFromBytes(heapId, 1, heapId.length - 1);
                    }
                }
            } else if (this.type == 2) {
                this.subtype = heapId.length <= 18 ? 1 : 2;
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public long getPos() throws IOException {
            switch (this.type) {
                case 0: {
                    return FractalHeap.this.doublingTable.getPos(this.offset);
                }
                case 1: {
                    switch (this.subtype) {
                        case 1: 
                        case 2: {
                            BTree2.Record1 record1;
                            if (FractalHeap.this.btreeHugeObjects == null) {
                                FractalHeap.this.btreeHugeObjects = new BTree2(FractalHeap.this.h5, "FractalHeap btreeHugeObjects", FractalHeap.this.btreeAddressHugeObjects);
                                assert (FractalHeap.this.btreeHugeObjects.btreeType == this.subtype);
                            }
                            if ((record1 = FractalHeap.this.btreeHugeObjects.getEntry1(this.offset)) == null) {
                                FractalHeap.this.btreeHugeObjects.getEntry1(this.offset);
                                throw new RuntimeException("Cant find DHeapId=" + this.offset);
                            }
                            return record1.hugeObjectAddress;
                        }
                        case 3: 
                        case 4: {
                            return this.offset;
                        }
                    }
                }
            }
            throw new RuntimeException("Unknown DHeapId type =" + this.type);
        }

        public String toString() {
            return this.type + "," + this.n + "," + this.m + "," + this.offset + "," + this.size;
        }

        public void show(Formatter f) throws IOException {
            f.format("   %2d %2d %2d %6d %4d %8d", this.type, this.n, this.m, this.offset, this.size, this.getPos());
        }
    }
}

