/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.JulianChronology;
import uk.ac.rdg.resc.edal.time.AllLeapChronology;
import uk.ac.rdg.resc.edal.time.NoLeapChronology;
import uk.ac.rdg.resc.edal.time.ThreeSixtyDayChronology;

public enum Calendar {
    gregorian,
    proleptic_gregorian,
    noleap,
    all_leap,
    uniform30day,
    julian,
    none;

    private static final Map<Calendar, Chronology> CHRONOLOGIES;
    private static final Map<Chronology, Calendar> CALENDARS;

    public static Calendar get(String s) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("gregorian") || s.equalsIgnoreCase("standard")) {
            return gregorian;
        }
        if (s.equalsIgnoreCase("proleptic_gregorian") || s.equalsIgnoreCase("ISO8601")) {
            return proleptic_gregorian;
        }
        if (s.equalsIgnoreCase("noleap") || s.equalsIgnoreCase("365_day")) {
            return noleap;
        }
        if (s.equalsIgnoreCase("all_leap") || s.equalsIgnoreCase("366_day")) {
            return all_leap;
        }
        if (s.equalsIgnoreCase("uniform30day") || s.equalsIgnoreCase("360_day")) {
            return uniform30day;
        }
        if (s.equalsIgnoreCase("julian")) {
            return julian;
        }
        if (s.equalsIgnoreCase("none")) {
            return none;
        }
        return null;
    }

    public static Calendar getDefault() {
        return proleptic_gregorian;
    }

    public static boolean isDefaultChronology(Calendar cal) {
        return cal == null || cal == Calendar.getDefault() || cal == none;
    }

    private static void associate(Calendar cal, Chronology cron) {
        CHRONOLOGIES.put(cal, cron);
        CALENDARS.put(cron, cal);
    }

    static Chronology getChronology(Calendar cal) {
        if (cal == null) {
            cal = Calendar.getDefault();
        }
        return CHRONOLOGIES.get((Object)cal);
    }

    static Calendar of(Chronology cron) {
        if (cron == null) {
            return Calendar.getDefault();
        }
        return CALENDARS.get(cron);
    }

    static {
        CHRONOLOGIES = new HashMap<Calendar, Chronology>();
        CALENDARS = new HashMap<Chronology, Calendar>();
        Calendar.associate(gregorian, GJChronology.getInstanceUTC());
        Calendar.associate(none, ISOChronology.getInstanceUTC());
        Calendar.associate(proleptic_gregorian, ISOChronology.getInstanceUTC());
        Calendar.associate(julian, JulianChronology.getInstanceUTC());
        Calendar.associate(all_leap, AllLeapChronology.getInstanceUTC());
        Calendar.associate(noleap, NoLeapChronology.getInstanceUTC());
        Calendar.associate(uniform30day, ThreeSixtyDayChronology.getInstanceUTC());
    }
}

