/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.client.catalog.Dataset;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.server.metadata.controller.AbstractMetadataController;
import thredds.server.metadata.service.EnhancedMetadataService;
import thredds.server.metadata.util.DatasetHandlerAdapter;
import thredds.util.ContentType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;

@Controller
@RequestMapping(value={"/ncml/"})
public class NcmlController
extends AbstractMetadataController {
    private static Logger _log = LoggerFactory.getLogger(NcmlController.class);
    @Autowired
    private AllowedServices as;

    @Override
    protected String getPath() {
        return this._metadataServiceType + "/";
    }

    @EventListener
    public void init(ContextRefreshedEvent event) throws ServletException {
        if (event.getApplicationContext().getDisplayName().equals("Root WebApplicationContext")) {
            this._allow = this.as.isAllowed(StandardService.iso_ncml);
            this._metadataServiceType = "NCML";
            this._servletPath = "/ncml";
            _logServerStartup.info("Metadata NCML - initialization start");
            _logServerStartup.info("NCISO.ncmlAllow = " + this._allow);
        }
    }

    public void destroy() {
        NetcdfDatasets.shutdown();
        _logServerStartup.info("Metadata NCML - destroy done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequestMapping(value={"**"}, params={})
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        _log.info("Handling NCML metadata request.");
        NetcdfDataset netCdfDataset = null;
        try {
            this.isAllowed(this.as.isAllowed(StandardService.iso), this._metadataServiceType, res);
            res.setContentType(ContentType.xml.getContentHeader());
            netCdfDataset = DatasetHandlerAdapter.openDataset(req, res, this.getInfoPath(req));
            if (netCdfDataset == null) {
                res.sendError(404, "ThreddsIso Extension: Requested resource not found.");
            } else {
                PrintWriter writer = res.getWriter();
                Dataset ids = this.getThreddsDataset(req, res);
                EnhancedMetadataService.enhance(netCdfDataset, ids, writer);
                ((Writer)writer).flush();
            }
            DatasetHandlerAdapter.closeDataset(netCdfDataset);
        }
        catch (Exception e) {
            String errMsg = "Error in " + this._metadataServiceType + ": " + req.getQueryString();
            _log.error(errMsg, e);
            try {
                this.returnError(errMsg, this._metadataServiceType, res);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            DatasetHandlerAdapter.closeDataset(netCdfDataset);
        }
    }
}

