/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLUtil {
    private static Logger _log = LoggerFactory.getLogger(XMLUtil.class);
    private Document _doc = null;

    public XMLUtil(String fileName) {
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            this._doc = saxBuilder.build(fileName);
        }
        catch (JDOMException jde) {
            _log.error("JDOMException in XMLUtil: ", (Throwable)jde);
        }
        catch (IOException ioe) {
            _log.error("IOException in XMLUtil: ", (Throwable)ioe);
        }
    }

    public XMLUtil(InputStream is) {
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            this._doc = saxBuilder.build(is);
        }
        catch (JDOMException jde) {
            _log.error("JDOMException in XMLUtil: ", (Throwable)jde);
        }
        catch (IOException ioe) {
            _log.error("IOException in XMLUtil: ", (Throwable)ioe);
        }
    }

    public Document getDocument() {
        return this._doc;
    }

    public void listElements(List<Element> es, String indent) {
        for (Element e : es) {
            this.listElement(e, indent);
        }
    }

    public void listElement(Element e, String indent) {
        _log.debug(indent + "*Element, name:" + e.getName() + ", text:" + e.getText().trim());
        List as = e.getAttributes();
        XMLUtil.listAttributes(as, indent + " ");
        List c = e.getChildren();
        this.listElements(c, indent + " ");
    }

    public static void listAttributes(List<Attribute> as, String indent) {
        for (Attribute a : as) {
            System.out.println(indent + "*Attribute, name:" + a.getName() + ", value:" + a.getValue());
        }
    }

    public List<Element> elemFinder(String xPathExpr, String prefix, String nameSpace) {
        XPath x = null;
        try {
            x = XPath.newInstance((String)xPathExpr);
            x.addNamespace(prefix, nameSpace);
            List list = x.selectNodes((Object)this._doc);
            return list;
        }
        catch (JDOMException e) {
            _log.error("JDOMException in XMLUtil: ", (Throwable)e);
            return null;
        }
    }

    public void sortElements(Element parent, Comparator c) {
        ArrayList children = new ArrayList(parent.getChildren());
        Collections.sort(children, c);
        ListIterator childrenIter = children.listIterator();
        ArrayList content = new ArrayList(parent.getContent());
        ListIterator contentIter = content.listIterator();
        while (contentIter.hasNext()) {
            Object obj = contentIter.next();
            if (!(obj instanceof Element)) continue;
            contentIter.set(childrenIter.next());
        }
        ArrayList emptyList = new ArrayList();
        parent.setContent(emptyList);
        parent.setContent(content);
    }

    private void sort(List<Element> list, Comparator<Element> c) {
        int i;
        Element[] a = list.toArray(new Element[list.size()]);
        Arrays.sort(a, c);
        for (i = 0; i < a.length; ++i) {
            a[i].detach();
        }
        for (i = 0; i < a.length; ++i) {
            list.add(a[i]);
        }
    }

    public void write(String fileName) {
        try {
            FileWriter writer = new FileWriter(fileName);
            this.doWrite(writer);
        }
        catch (IOException e) {
            _log.error("IOException in XMLUtil: ", (Throwable)e);
        }
    }

    public void write(Writer writer) {
        this.doWrite(writer);
    }

    private void doWrite(Writer writer) {
        try {
            XMLOutputter outputter = new XMLOutputter();
            Format newFormat = outputter.getFormat();
            newFormat = Format.getCompactFormat();
            newFormat.setIndent("  ");
            outputter.setFormat(newFormat);
            outputter.output(this._doc, writer);
        }
        catch (IOException e) {
            _log.error("IOException in XMLUtil: ", (Throwable)e);
        }
    }
}

