/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.eds.service;

import gov.noaa.eds.threddsutilities.bean.MetadataContainer;
import gov.noaa.eds.threddsutilities.bean.ThreddsDatasetTree;
import gov.noaa.eds.threddsutilities.service.impl.CatalogCrawlerImpl;
import gov.noaa.eds.util.FileUtility;
import gov.noaa.eds.util.NCMLModifier;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.metadata.bean.Extent;
import thredds.server.metadata.util.ElementNameComparator;
import thredds.server.metadata.util.ThreddsExtentUtil;
import thredds.server.metadata.util.ThreddsTranslatorUtil;
import thredds.server.metadata.util.XMLUtil;

public class DatasetTreeService {
    private static Logger logger = LoggerFactory.getLogger(DatasetTreeService.class);
    private static final String _xsltMetadataAssessmentUrl = "https://cdn.rawgit.com/NOAA-PMEL/uafnciso/fdb7f86515c21a8b5c087978975addf9ad5d0027/transforms/UnidataDDCount-HTML.xsl";
    private static final String _xsltIsoUrl = "https://cdn.rawgit.com/noaaroland/uafnciso/e84d6e26b87a799eb996173358c72ec7a4ed4912/transforms/UnidataDD2MI.xsl";
    private String _xsltFilePath = null;
    private String _threddsServer = null;
    ThreddsDatasetTree root;
    ArrayList<String> threddsAl = new ArrayList();
    private FileUtility fu;
    String rootStr = "";
    private String nodeIndent = "";
    private String pad = "\t      ";
    private static String childrenIndent = "       ";
    private boolean _iso = true;
    private boolean _custom = false;
    private int _numSample = 1;
    private int _depth = -1;

    public void setServer(String tdsServer, int depth, int numSample, boolean isoExtract, boolean customExtract, String customXsltFile) {
        this._depth = depth;
        this._threddsServer = tdsServer;
        this._numSample = numSample;
        this._iso = isoExtract;
        this._xsltFilePath = "xsl/" + customXsltFile;
        this._custom = customExtract;
    }

    private void evaluateTopDown(String evalStr) {
        logger.debug("evalStr=" + evalStr);
        if (evalStr.indexOf("/") < 0) {
            this.threddsAl.add(evalStr);
            return;
        }
        String parsedStr = evalStr.substring(0, evalStr.indexOf("/"));
        evalStr = evalStr.substring(parsedStr.length() + 1, evalStr.length());
        this.threddsAl.add(parsedStr);
        this.evaluateTopDown(evalStr);
    }

    private String writeChildrenFromNode(Enumeration<ThreddsDatasetTree> e) {
        String children = this.pad + this.nodeIndent + childrenIndent + "children:[";
        while (e.hasMoreElements()) {
            ThreddsDatasetTree newTree = e.nextElement();
            if (newTree._isLeaf) {
                logger.debug(newTree._displayName + " is leaf");
                int pos = -1;
                pos = newTree._displayName.lastIndexOf(".nc") > 0 || newTree._displayName.lastIndexOf(".cdf") > 0 ? newTree._displayName.lastIndexOf(".") : newTree._displayName.length();
                String ncmlFile = newTree._displayName.substring(0, pos) + "_NCML.xml";
                String reportFile = newTree._displayName.substring(0, pos) + "_REPORT.html";
                String isoFile = newTree._displayName.substring(0, pos) + "_ISO.xml";
                children = children + "{_reference:'" + newTree._id.toString() + "." + ncmlFile + "'},";
                if (this._iso) {
                    children = children + "{_reference:'" + newTree._id.toString() + "." + reportFile + "'},";
                    children = children + "{_reference:'" + newTree._id.toString() + "." + isoFile + "'}";
                } else {
                    children = children + "{_reference:'" + newTree._id.toString() + "." + reportFile + "'}";
                }
            } else {
                children = children + "{_reference:'" + newTree._id.toString() + "." + newTree.getName() + "'}";
            }
            if (!e.hasMoreElements()) continue;
            children = children + ",";
        }
        children = children + "] },";
        return children;
    }

    private void getNodes(ThreddsDatasetTree tree) {
        logger.debug("getNodes()=" + tree._displayName);
        Enumeration<ThreddsDatasetTree> e = tree.elements();
        if (!tree._isLeaf) {
            String children = this.writeChildrenFromNode(e);
            this.fu.writeln(children);
            e = tree.elements();
        }
        while (e.hasMoreElements()) {
            ThreddsDatasetTree newTree = e.nextElement();
            this.nodeIndent = "";
            int level = newTree._level;
            for (int i2 = 0; i2 < level; ++i2) {
                this.nodeIndent = this.nodeIndent + "    ";
            }
            if (!newTree._isLeaf) {
                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + newTree._displayName + "', name:'" + newTree._displayName + "', type:'level" + newTree._level + "',");
            } else {
                String ncmlFullFilePath = "";
                int startPos = newTree._url.indexOf("/", 7);
                String urlSrcRoot = newTree._url.substring(startPos + 1, newTree._url.lastIndexOf("/") + 1);
                int pos = -1;
                pos = newTree._displayName.lastIndexOf(".nc") > 0 || newTree._displayName.lastIndexOf(".cdf") > 0 ? newTree._displayName.lastIndexOf(".") : newTree._displayName.length();
                String ncmlFileStr = newTree._displayName.substring(0, pos) + "_NCML.xml";
                String reportFile = newTree._displayName.substring(0, pos) + "_REPORT.html";
                String isoFile = newTree._displayName.substring(0, pos) + "_ISO.xml";
                String customMetaFile = newTree._displayName.substring(0, pos) + "_META.xml";
                ncmlFullFilePath = urlSrcRoot + ncmlFileStr;
                FileUtility mdu = new FileUtility(urlSrcRoot);
                mdu.mkdirs();
                try {
                    File ncmlFile = ThreddsTranslatorUtil.getNcml(newTree._url, ncmlFullFilePath);
                    if (ncmlFile != null) {
                        Extent ext = ThreddsExtentUtil.getExtent(newTree._url);
                        XMLUtil xmlUtil = new XMLUtil(ncmlFullFilePath);
                        NCMLModifier ncmlMod = new NCMLModifier();
                        List<Element> list = xmlUtil.elemFinder("//ncml:netcdf", "ncml", "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
                        Element rootElem = list.get(0);
                        Element cfGroupElem = ncmlMod.doAddGroupElem(rootElem, "CFMetadata");
                        ncmlMod.addCFMetadata(ext, cfGroupElem);
                        Element threddsGroupElem = ncmlMod.doAddGroupElem(rootElem, "THREDDSMetadata");
                        ncmlMod.addThreddsMetadata(tree._mdc.getDataset(), threddsGroupElem);
                        Element ncisoGroupElem = ncmlMod.doAddGroupElem(rootElem, "NCISOMetadata");
                        ncmlMod.addNcIsoMetadata(ncisoGroupElem);
                        xmlUtil.sortElements(rootElem, new ElementNameComparator());
                        xmlUtil.write(ncmlFullFilePath);
                        String scoreReportLoc = null;
                        scoreReportLoc = urlSrcRoot + reportFile;
                        ThreddsTranslatorUtil.transform(_xsltMetadataAssessmentUrl, ncmlFullFilePath, scoreReportLoc);
                        this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + ncmlFileStr + "', name:'" + ncmlFileStr + "', urlSrc: '" + ncmlFullFilePath + "', type:'level" + newTree._level + "' },");
                        if (!this._iso) {
                            if (!newTree._isLastElement) {
                                logger.info("LAST ELEMENT: " + newTree._id.toString() + "." + reportFile);
                                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + reportFile + "', name:'" + reportFile + "', urlSrc: '" + urlSrcRoot + reportFile + "', type:'level" + newTree._level + "' },");
                            } else {
                                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + reportFile + "', name:'" + reportFile + "', urlSrc: '" + urlSrcRoot + reportFile + "', type:'level" + newTree._level + "' }");
                            }
                        } else {
                            this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + reportFile + "', name:'" + reportFile + "', urlSrc: '" + urlSrcRoot + reportFile + "', type:'level" + newTree._level + "' },");
                        }
                        if (this._iso) {
                            ThreddsTranslatorUtil.transform(_xsltIsoUrl, ncmlFullFilePath, urlSrcRoot + isoFile);
                            if (!newTree._isLastElement) {
                                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + isoFile + "', name:'" + isoFile + "', urlSrc: '" + urlSrcRoot + isoFile + "', type:'level" + newTree._level + "' },");
                            } else {
                                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + isoFile + "', name:'" + isoFile + "', urlSrc: '" + urlSrcRoot + isoFile + "', type:'level" + newTree._level + "' }");
                            }
                        }
                        if (this._custom) {
                            ThreddsTranslatorUtil.transform(this._xsltFilePath, ncmlFullFilePath, urlSrcRoot + customMetaFile);
                            if (!newTree._isLastElement) {
                                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + customMetaFile + "', name:'" + isoFile + "', urlSrc: '" + urlSrcRoot + customMetaFile + "', type:'level" + newTree._level + "' },");
                            } else {
                                this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + customMetaFile + "', name:'" + isoFile + "', urlSrc: '" + urlSrcRoot + customMetaFile + "', type:'level" + newTree._level + "' }");
                            }
                        }
                    } else {
                        this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + ncmlFileStr + "', name:'" + ncmlFileStr + "', urlSrc: 'NOTAVAILABLE', type:'level" + newTree._level + "' },");
                        this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + reportFile + "', name:'" + reportFile + "', urlSrc: 'NOTAVAILABLE', type:'level" + newTree._level + "' },");
                        if (this._iso) {
                            this.fu.writeln(this.pad + this.nodeIndent + "{ id: '" + newTree._id.toString() + "." + isoFile + "', name:'" + isoFile + "', urlSrc: 'NOTAVAILABLE', type:'level" + newTree._level + "' },");
                        }
                    }
                }
                catch (Exception exc) {
                    logger.error("_id=" + newTree._id, exc);
                }
            }
            this.getNodes(newTree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTree() {
        CatalogCrawlerImpl crawler = new CatalogCrawlerImpl();
        this.rootStr = this._threddsServer.substring(0, this._threddsServer.lastIndexOf("/"));
        int rootNodeStart = this.rootStr.lastIndexOf("/") + 1;
        String rootNode = this.rootStr.substring(rootNodeStart, this.rootStr.length());
        int i2 = 0;
        int cnt = 0;
        ThreddsDatasetTree tree = new ThreddsDatasetTree(new Integer(cnt), null, "ROOT", "/ROOT", null, new Integer(i2));
        ++cnt;
        logger.debug("root=" + this.rootStr);
        logger.info("rootNode=" + rootNode);
        this.fu = new FileUtility(rootNode + ".json");
        this.fu.openFileWriter();
        try {
            Vector<MetadataContainer> mdcs = new Vector<MetadataContainer>();
            crawler.crawlThredds(this._threddsServer, this._depth, this._numSample, mdcs);
            ThreddsDatasetTree lastNode = tree;
            logger.info("mdcs.size()=" + mdcs.size());
            for (MetadataContainer mdc : mdcs) {
                String urlStr = mdc.getOpenDapUrl();
                logger.info("cnt=" + cnt + " ------------------ Processing: " + urlStr);
                int startPos = urlStr.indexOf("/", 7);
                String evalStr = urlStr.substring(startPos + 1, urlStr.length());
                this.evaluateTopDown(evalStr);
                i2 = 1;
                String nodePath = "/";
                lastNode = tree.getChild("/ROOT");
                for (String element : this.threddsAl) {
                    ThreddsDatasetTree node = null;
                    logger.debug(i2 + ":" + element + ":theddsAl.size()=" + this.threddsAl.size());
                    if (i2 == this.threddsAl.size()) {
                        logger.debug("Adding new leaf:" + cnt + ";" + lastNode._displayName + ";" + element + ";" + nodePath + ";" + i2);
                        node = new ThreddsDatasetTree(new Integer(cnt), lastNode, element.replace(":", "_"), urlStr, mdc, new Integer(i2));
                        node.setLeaf(true);
                        if (cnt == mdcs.size()) {
                            node.setLastElement(true);
                        }
                        lastNode.add(node);
                    } else {
                        nodePath = nodePath + element + "/";
                        logger.debug("nodePath=" + nodePath);
                        node = tree.getChild(nodePath);
                        if (node == null) {
                            logger.debug("Adding new node:" + cnt + ";" + lastNode._displayName + ";" + element + ";" + nodePath + ";" + i2);
                            node = new ThreddsDatasetTree(new Integer(cnt), lastNode, element.replace(":", "_"), nodePath, mdc, new Integer(i2));
                            lastNode.add(node);
                        } else {
                            logger.debug("found a an existing node:" + node._displayName);
                        }
                    }
                    lastNode = node;
                    ++i2;
                }
                this.threddsAl.clear();
                ++cnt;
            }
            this.fu.writeln("{");
            this.fu.writeln("\tidentifier: 'id',");
            this.fu.writeln("\tlabel: 'name',");
            this.fu.writeln("\titems: [");
            this.fu.write(this.pad + "{ id: '" + tree._id.toString() + "." + tree._displayName + "', name:'" + tree._displayName + "', type:'level" + tree._level + "'");
            if (tree.elements().hasMoreElements()) {
                this.fu.writeln(",");
                try {
                    this.getNodes(tree);
                }
                catch (Exception e) {
                    logger.error("Exception encountered.", e);
                }
            }
            this.fu.writeln("");
            this.fu.writeln("]}");
        }
        catch (Exception e) {
            logger.error("Exception encountered.", e);
        }
        finally {
            this.fu.close();
        }
    }
}

