/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentWrapper
extends DOMNodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected long documentNumber;
    protected boolean domLevel3;
    private HashMap<String, Object> userData;

    public DocumentWrapper(Node doc, String baseURI, Configuration config) {
        super(doc, null, null, 0);
        if (doc.getNodeType() != 9 && doc.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        this.node = doc;
        this.nodeKind = (short)9;
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.domLevel3 = true;
        if (config.getExternalObjectModel(doc.getClass()) == null) {
            throw new IllegalArgumentException("Node class " + doc.getClass().getName() + " is not recognized in this Saxon configuration");
        }
        this.setConfiguration(config);
    }

    public DOMNodeWrapper wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        Document doc = node.getOwnerDocument();
        if (doc == this.node || this.domLevel3 && doc != null && doc.isSameNode(this.node)) {
            return this.makeWrapper(node, this);
        }
        throw new IllegalArgumentException("DocumentWrapper#wrap: supplied node does not belong to the wrapped DOM document");
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public String getSystemId() {
        return this.baseURI;
    }

    @Override
    public void setSystemId(String uri) {
        this.baseURI = uri;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void setDOMLevel(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel3 = level == 3;
    }

    public int getDOMLevel() {
        return this.domLevel3 ? 3 : 2;
    }

    @Override
    public boolean isTyped() {
        return false;
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public synchronized NodeInfo selectID(String id, boolean getParent) {
        if (this.node instanceof Document) {
            Element el = ((Document)this.node).getElementById(id);
            if (el == null) {
                return null;
            }
            return this.wrap(el);
        }
        return null;
    }

    @Override
    public synchronized boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof DocumentWrapper && this.node == ((DocumentWrapper)other).node;
    }

    @Override
    public synchronized Iterator<String> getUnparsedEntityNames() {
        DocumentType docType = ((Document)this.node).getDoctype();
        if (docType == null) {
            List ls = Collections.emptyList();
            return ls.iterator();
        }
        NamedNodeMap map = docType.getEntities();
        if (map == null) {
            List ls = Collections.emptyList();
            return ls.iterator();
        }
        ArrayList<String> names = new ArrayList<String>(map.getLength());
        for (int i2 = 0; i2 < map.getLength(); ++i2) {
            Entity e = (Entity)map.item(i2);
            if (e.getNotationName() == null) continue;
            names.add(e.getLocalName());
        }
        return names.iterator();
    }

    @Override
    public synchronized String[] getUnparsedEntity(String name) {
        DocumentType docType = ((Document)this.node).getDoctype();
        if (docType == null) {
            return null;
        }
        NamedNodeMap map = docType.getEntities();
        if (map == null) {
            return null;
        }
        Entity entity = (Entity)map.getNamedItem(name);
        if (entity == null || entity.getNotationName() == null) {
            return null;
        }
        String systemId = entity.getSystemId();
        try {
            URI systemIdURI = new URI(systemId);
            if (!systemIdURI.isAbsolute()) {
                String base = this.getBaseURI();
                if (base != null) {
                    systemIdURI = new URI(base).resolve(systemIdURI);
                    systemId = systemIdURI.toString();
                }
                systemIdURI = new URI(this.getBaseURI()).resolve(systemIdURI);
                systemId = systemIdURI.toString();
            }
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        return new String[]{systemId, entity.getPublicId()};
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }

    @Override
    public SchemaType getSchemaType() {
        return Untyped.getInstance();
    }

    @Override
    public synchronized void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public synchronized Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

