/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class StartElementEvent
implements PullEvent {
    PipelineConfiguration pipe;
    private NodeName elementName;
    private SchemaType typeCode;
    private NamespaceBinding[] localNamespaces;
    private List<NodeInfo> attributes;
    private int locationId = -1;

    public StartElementEvent(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void setElementName(NodeName elementName) {
        this.elementName = elementName;
    }

    public NodeName getElementName() {
        return this.elementName;
    }

    public void setTypeCode(SchemaType typeCode) {
        this.typeCode = typeCode;
    }

    public SchemaType getTypeCode() {
        return this.typeCode;
    }

    public void setLocalNamespaces(NamespaceBinding[] nscodes) {
        this.localNamespaces = nscodes;
    }

    public void addNamespace(NamespaceBinding nscode) throws XPathException {
        if (this.localNamespaces == null) {
            this.localNamespaces = new NamespaceBinding[]{nscode, null, null, null};
        }
        for (int n = 0; n < this.localNamespaces.length; ++n) {
            NamespaceBinding nn = this.localNamespaces[n];
            if (nn == null) {
                this.localNamespaces[n] = nscode;
                if (n < this.localNamespaces.length - 1) {
                    this.localNamespaces[n + 1] = null;
                }
                return;
            }
            if (nn.equals(nscode)) {
                return;
            }
            if (!nn.getPrefix().equals(nscode.getPrefix())) continue;
            String prefix = nscode.getPrefix();
            String uri1 = nn.getURI();
            String uri2 = nscode.getURI();
            XPathException err = new XPathException("Cannot create two namespace nodes with the same prefix mapped to different URIs (prefix=" + (prefix.length() == 0 ? "\"\"" : prefix) + ", URI=" + (uri1.length() == 0 ? "\"\"" : uri1) + ", URI=" + (uri2.length() == 0 ? "\"\"" : uri2) + ")");
            err.setErrorCode("XTDE0430");
            throw err;
        }
        NamespaceBinding[] n2 = new NamespaceBinding[this.localNamespaces.length * 2 + 2];
        System.arraycopy(this.localNamespaces, 0, n2, 0, this.localNamespaces.length);
        n2[this.localNamespaces.length] = nscode;
        n2[this.localNamespaces.length + 1] = null;
        this.localNamespaces = n2;
    }

    public NamespaceBinding[] getLocalNamespaces() {
        if (this.localNamespaces == null) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        return this.localNamespaces;
    }

    public void addAttribute(NodeInfo att) throws XPathException {
        if (this.attributes == null) {
            this.attributes = new ArrayList<NodeInfo>(4);
        }
        int fp = att.getFingerprint();
        for (int a = 0; a < this.attributes.size(); ++a) {
            int fp2 = this.attributes.get(a).getFingerprint();
            if (fp != fp2) continue;
            if (this.pipe.getHostLanguage() == 51) {
                XPathException err = new XPathException("Cannot create an element having two attributes with the same name: " + Err.wrap(att.getDisplayName(), 2));
                err.setErrorCode("XQDY0025");
                if (this.locationId != -1) {
                    err.setLocator(new ExpressionLocation(this.pipe.getLocationProvider(), this.locationId));
                }
                throw err;
            }
            this.attributes.set(a, att);
            return;
        }
        this.attributes.add(att);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Iterator iterateAttributes() {
        if (this.attributes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.attributes.iterator();
    }

    public NodeInfo getAttribute(int index) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(index);
    }

    public void namespaceFixup() {
        this.elementName = this.fixup(this.elementName, 0);
        if (this.attributes != null) {
            for (int a = 0; a < this.attributes.size(); ++a) {
                NodeName newCode;
                NodeInfo oldAtt = this.attributes.get(a);
                NameOfNode oldCode = new NameOfNode(oldAtt);
                if (oldCode == (newCode = this.fixup(new NameOfNode(oldAtt), a))) continue;
                Orphan att = new Orphan(oldAtt.getConfiguration());
                att.setNodeKind((short)2);
                att.setNodeName(newCode);
                att.setStringValue(oldAtt.getStringValue());
                att.setTypeAnnotation(oldAtt.getSchemaType());
                att.setSystemId(oldAtt.getSystemId());
                this.attributes.set(a, att);
            }
        }
    }

    private NodeName fixup(NodeName nameCode, int seq) {
        String prefix = nameCode.getPrefix();
        String uri = nameCode.getURI();
        NamespaceBinding nsBinding = nameCode.getNamespaceBinding();
        if (prefix.length() == 0 && uri.length() == 0) {
            return nameCode;
        }
        if (this.localNamespaces != null) {
            NamespaceBinding nn;
            for (int n = 0; n < this.localNamespaces.length && (nn = this.localNamespaces[n]) != null; ++n) {
                if (!prefix.equals(nn.getPrefix())) continue;
                if (uri.equals(nn.getURI())) {
                    return nameCode;
                }
                String local = nameCode.getLocalPart();
                String prefix2 = prefix + "_" + seq;
                FingerprintedQName newCode = new FingerprintedQName(prefix2, uri, local);
                return this.fixup(newCode, seq);
            }
        }
        try {
            this.addNamespace(nsBinding);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
        return nameCode;
    }

    public void stripTypeAnnotations() {
        this.setTypeCode(Untyped.getInstance());
        if (this.attributes != null) {
            for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
                NodeInfo att = this.attributes.get(i2);
                if (BuiltInAtomicType.UNTYPED_ATOMIC.equals(att.getSchemaType())) continue;
                Orphan o = new Orphan(att.getConfiguration());
                o.setNodeKind((short)2);
                o.setNodeName(new NameOfNode(att));
                o.setStringValue(att.getStringValue());
                o.setSystemId(att.getSystemId());
                o.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
                this.attributes.set(i2, o);
            }
        }
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public int getLocationId() {
        return this.locationId;
    }
}

