/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventMappingFunction;
import net.sf.saxon.evpull.EventMappingIterator;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.StatefulMappingFunction;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class ForExpression
extends Assignation {
    int actionCardinality = 32768;

    public String getExpressionName() {
        return "for";
    }

    public boolean hasVariableBinding(Binding binding) {
        return this == binding;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.sequence = visitor.typeCheck(this.sequence, contextInfo);
        if (Literal.isEmptySequence(this.sequence)) {
            return this.sequence;
        }
        if (this.requiredType != null) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            SequenceType decl = this.requiredType;
            SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
            RoleLocator role = new RoleLocator(3, this.variableName, 0);
            this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
            ItemType actualItemType = this.sequence.getItemType();
            this.refineTypeInformation(actualItemType, this.getRangeVariableCardinality(), null, this.sequence.getSpecialProperties(), visitor, this);
        }
        this.action = visitor.typeCheck(this.action, contextInfo);
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        this.actionCardinality = this.action.getCardinality();
        return this;
    }

    protected int getRangeVariableCardinality() {
        return 16384;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression p;
        Expression act2;
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        boolean debug = opt.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/trace-optimizer-decisions");
        if (Choose.isSingleBranchChoice(this.action) && (act2 = visitor.optimize(this.action, contextItemType)) != this.action) {
            this.action = act2;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
        }
        if ((p = this.promoteWhereClause()) != null) {
            if (debug) {
                opt.trace("Promoted where clause in for $" + this.getVariableName(), p);
            }
            return visitor.optimize(p, contextItemType);
        }
        Expression seq2 = visitor.optimize(this.sequence, contextItemType);
        if (seq2 != this.sequence) {
            this.sequence = seq2;
            this.adoptChildExpression(this.sequence);
            visitor.resetStaticProperties();
            return this.optimize(visitor, contextItemType);
        }
        if (Literal.isEmptySequence(this.sequence)) {
            return this.sequence;
        }
        Expression act22 = visitor.optimize(this.action, contextItemType);
        if (act22 != this.action) {
            this.action = act22;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
            return this.optimize(visitor, contextItemType);
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        Expression e2 = this.extractLoopInvariants(visitor, contextItemType);
        if (e2 != null && e2 != this) {
            if (debug) {
                opt.trace("Extracted invariant in 'for $" + this.getVariableName() + "' loop", e2);
            }
            return visitor.optimize(e2, contextItemType);
        }
        if (this.sequence instanceof SlashExpression && this.action instanceof SlashExpression) {
            SlashExpression path2 = (SlashExpression)this.action;
            Expression start2 = path2.getSelectExpression();
            Expression step2 = path2.getActionExpression();
            if (start2 instanceof VariableReference && ((VariableReference)start2).getBinding() == this && ExpressionTool.getReferenceCount(this.action, this, false) == 1 && (step2.getDependencies() & 0xC) == 0) {
                Expression newPath = new SlashExpression(this.sequence, path2.getActionExpression());
                ExpressionTool.copyLocationInfo(this, newPath);
                newPath = visitor.typeCheck(visitor.simplify(newPath), contextItemType);
                if (newPath instanceof SlashExpression) {
                    if (debug) {
                        opt.trace("Collapsed return clause of for $" + this.getVariableName() + " into path expression", newPath);
                    }
                    return visitor.optimize(newPath, contextItemType);
                }
            }
        }
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this) {
            if (debug) {
                opt.trace("Collapsed redundant for expression $" + this.getVariableName(), this.sequence);
            }
            return this.sequence;
        }
        if (this.sequence.getCardinality() == 16384) {
            LetExpression let = new LetExpression();
            let.setVariableQName(this.variableName);
            let.setRequiredType(SequenceType.makeSequenceType(this.sequence.getItemType(), 16384));
            let.setSequence(this.sequence);
            let.setAction(this.action);
            let.setSlotNumber(this.slotNumber);
            ExpressionTool.rebindVariableReferences(this.action, this, let);
            return let.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        return this;
    }

    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        this.sequence = this.sequence.unordered(retainAllNodes, forStreaming);
        this.action = this.action.unordered(retainAllNodes, forStreaming);
        return this;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.action.getIntegerBounds();
    }

    private Expression extractLoopInvariants(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        PromotionOffer offer = new PromotionOffer(visitor.getConfiguration().obtainOptimizer());
        offer.containingExpression = this;
        offer.action = 11;
        offer.bindingList = new Binding[]{this};
        this.action = this.doPromotion(this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(offer.containingExpression, contextItemType);
        }
        return offer.containingExpression;
    }

    protected Expression promoteWhereClause() {
        if (Choose.isSingleBranchChoice(this.action)) {
            Expression condition = ((Choose)this.action).getConditions()[0];
            Binding[] bindingList = new Binding[]{this};
            ArrayList<Expression> list = new ArrayList<Expression>(5);
            Expression promotedCondition = null;
            BooleanExpression.listAndComponents(condition, list);
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                Expression term = (Expression)list.get(i2);
                if (ExpressionTool.dependsOnVariable(term, bindingList)) continue;
                promotedCondition = promotedCondition == null ? term : new AndExpression(term, promotedCondition);
                list.remove(i2);
            }
            if (promotedCondition != null) {
                if (list.isEmpty()) {
                    Expression oldThen = ((Choose)this.action).getActions()[0];
                    this.setAction(oldThen);
                    return Choose.makeConditional(condition, this);
                }
                Expression retainedCondition = (Expression)list.get(0);
                for (int i3 = 1; i3 < list.size(); ++i3) {
                    retainedCondition = new AndExpression(retainedCondition, (Expression)list.get(i3));
                }
                ((Choose)this.action).getConditions()[0] = retainedCondition;
                Expression newIf = Choose.makeConditional(promotedCondition, this, Literal.makeEmptySequence(this.getContainer()));
                ExpressionTool.copyLocationInfo(this, newIf);
                return newIf;
            }
        }
        return null;
    }

    public Expression copy() {
        ForExpression forExp = new ForExpression();
        forExp.setRequiredType(this.requiredType);
        forExp.setVariableQName(this.variableName);
        forExp.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        forExp.setAction(newAction);
        forExp.variableName = this.variableName;
        forExp.slotNumber = this.slotNumber;
        ExpressionTool.rebindVariableReferences(newAction, this, forExp);
        return forExp;
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        if (!Cardinality.allowsMany(this.sequence.getCardinality())) {
            return ExpressionTool.markTailFunctionCalls(this.action, qName, arity);
        }
        return 0;
    }

    public boolean isVacuousExpression() {
        return this.action.isVacuousExpression();
    }

    public int getImplementationMethod() {
        return 6;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.sequence.iterate(context);
        MappingAction map = new MappingAction(context, this.getLocalSlotNumber(), this.action);
        switch (this.actionCardinality) {
            case 16384: {
                return new ItemMappingIterator(base, map, true);
            }
            case 24576: {
                return new ItemMappingIterator(base, map, false);
            }
        }
        return new MappingIterator(base, map);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        SequenceIterator base = this.sequence.iterate(context);
        EventMappingAction map = new EventMappingAction(context, this.getLocalSlotNumber(), this.action);
        return new EventMappingIterator(base, map);
    }

    public void process(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter = this.sequence.iterate(context);
        boolean position = true;
        int slot = this.getLocalSlotNumber();
        while ((item = iter.next()) != null) {
            context.setLocalVariable(slot, item);
            this.action.process(context);
        }
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Item item;
        SequenceIterator iter = this.sequence.iterate(context);
        boolean position = true;
        int slot = this.getLocalSlotNumber();
        while ((item = iter.next()) != null) {
            context.setLocalVariable(slot, item);
            this.action.evaluatePendingUpdates(context, pul);
        }
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public int computeCardinality() {
        int c1 = this.sequence.getCardinality();
        int c2 = this.action.getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    public String toString() {
        return "for $" + this.getVariableEQName() + " in " + (this.sequence == null ? "(...)" : this.sequence.toString()) + " return " + (this.action == null ? "(...)" : ExpressionTool.parenthesize(this.action));
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("for");
        this.explainSpecializedAttributes(out);
        out.emitAttribute("variable", this.getVariableEQName());
        out.emitAttribute("as", this.sequence.getItemType().toString());
        out.startSubsidiaryElement("in");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    protected void explainSpecializedAttributes(ExpressionPresenter out) {
    }

    public int getConstructType() {
        return 2012;
    }

    protected static class EventMappingAction
    implements EventMappingFunction {
        private XPathContext context;
        private int slotNumber;
        private Expression action;
        private int position = 1;

        public EventMappingAction(XPathContext context, int slotNumber, Expression action) {
            this.context = context;
            this.slotNumber = slotNumber;
            this.action = action;
        }

        public EventIterator map(Item item) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            return this.action.iterateEvents(this.context);
        }
    }

    public static class MappingAction
    implements MappingFunction,
    ItemMappingFunction,
    StatefulMappingFunction {
        protected XPathContext context;
        private int slotNumber;
        private Expression action;
        private int position = 1;

        public MappingAction() {
        }

        public MappingAction(XPathContext context, int slotNumber, Expression action) {
            this.context = context;
            this.slotNumber = slotNumber;
            this.action = action;
        }

        public SequenceIterator map(Item item) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            return this.action.iterate(this.context);
        }

        public Item mapItem(Item item) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            return this.action.evaluateItem(this.context);
        }

        public StatefulMappingFunction getAnother() {
            XPathContextMajor c2 = this.context.newContext();
            StackFrame oldstack = this.context.getStackFrame();
            Sequence[] vars = oldstack.getStackFrameValues();
            Sequence[] newvars = new Sequence[vars.length];
            System.arraycopy(vars, 0, newvars, 0, vars.length);
            c2.setStackFrame(oldstack.getStackFrameMap(), newvars);
            return new MappingAction(c2, this.slotNumber, this.action);
        }
    }
}

