/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleExpression
extends Expression
implements Callable {
    public static final Expression[] NO_ARGUMENTS = new Expression[0];
    protected Expression[] arguments = NO_ARGUMENTS;

    public void setArguments(Expression[] sub) {
        this.arguments = sub;
        for (Expression aSub : sub) {
            this.adoptChildExpression(aSub);
        }
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(this.arguments.length);
        for (Expression e : this.arguments) {
            list.add(new Operand(e, OperandRole.NAVIGATE));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            if (this.arguments[i2] != original) continue;
            this.arguments[i2] = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            if (this.arguments[i2] == null) continue;
            this.arguments[i2] = visitor.typeCheck(this.arguments[i2], contextInfo);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            if (this.arguments[i2] == null) continue;
            this.arguments[i2] = visitor.optimize(this.arguments[i2], contextItemType);
        }
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("SimpleExpression.copy()");
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            if (this.arguments[i2] == null) continue;
            this.arguments[i2] = this.doPromotion(this.arguments[i2], offer);
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        if ((this.getImplementationMethod() & 1) == 0) {
            return 49152;
        }
        return 24576;
    }

    @Override
    public int computeDependencies() {
        return super.computeDependencies();
    }

    @Override
    public final Item evaluateItem(XPathContext context) throws XPathException {
        return this.call(context, this.evaluateArguments(context)).head();
    }

    @Override
    public final SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.call(context, this.evaluateArguments(context)).iterate();
    }

    @Override
    public final void process(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator iter = this.call(context, this.evaluateArguments(context)).iterate();
        while ((it = iter.next()) != null) {
            context.getReceiver().append(it, this.locationId, 2);
        }
    }

    private Sequence[] evaluateArguments(XPathContext context) throws XPathException {
        Sequence[] iters = new Sequence[this.arguments.length];
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            iters[i2] = SequenceTool.toLazySequence(this.arguments[i2].iterate(context));
        }
        return iters;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("userExpression");
        destination.emitAttribute("class", this.getExpressionType());
        for (Expression argument : this.arguments) {
            argument.explain(destination);
        }
        destination.endElement();
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

