/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class TailIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int start;

    private TailIterator(SequenceIterator base, int start) {
        this.base = base;
        this.start = start;
    }

    public static SequenceIterator make(SequenceIterator base, int start) throws XPathException {
        if (start <= 1) {
            return base;
        }
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(start, Integer.MAX_VALUE);
        }
        if ((base.getProperties() & 1) != 0) {
            GroundedValue value = ((GroundedIterator)base).materialize();
            if (start > value.getLength()) {
                return EmptyIterator.emptyIterator();
            }
            return new ValueTailIterator(value, start - 1);
        }
        for (int i2 = 0; i2 < start - 1; ++i2) {
            Item b = base.next();
            if (b != null) continue;
            return EmptyIterator.emptyIterator();
        }
        return new TailIterator(base, start);
    }

    public Item next() throws XPathException {
        return this.base.next();
    }

    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    public int getLength() throws XPathException {
        int bl = ((LastPositionFinder)((Object)this.base)).getLength() - this.start + 1;
        return bl > 0 ? bl : 0;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return TailIterator.make(this.base.getAnother(), this.start);
    }

    public int getProperties() {
        return this.base.getProperties() & 6;
    }
}

