/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.OrderByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;

public class OrderByClausePush
extends TuplePush
implements Sortable {
    private TuplePush destination;
    private OrderByClause orderByClause;
    private TupleExpression tupleExpr;
    protected AtomicComparer[] comparers;
    XPathContext context;
    int position = 0;
    private ArrayList<ItemToBeSorted> tupleArray = new ArrayList(100);

    public OrderByClausePush(TuplePush destination, TupleExpression tupleExpr, OrderByClause orderBy, XPathContext context) {
        this.destination = destination;
        this.tupleExpr = tupleExpr;
        this.orderByClause = orderBy;
        this.context = context;
        AtomicComparer[] suppliedComparers = orderBy.getAtomicComparers();
        this.comparers = new AtomicComparer[suppliedComparers.length];
        for (int n = 0; n < this.comparers.length; ++n) {
            this.comparers[n] = suppliedComparers[n].provideContext(context);
        }
    }

    public void processTuple(XPathContext context) throws XPathException {
        Tuple tuple = this.tupleExpr.evaluateItem(context);
        SortKeyDefinition[] sortKeyDefinitions = this.orderByClause.getSortKeyDefinitions();
        ItemToBeSorted itbs = new ItemToBeSorted(sortKeyDefinitions.length);
        itbs.value = tuple;
        for (int i2 = 0; i2 < sortKeyDefinitions.length; ++i2) {
            itbs.sortKeyValues[i2] = this.orderByClause.evaluateSortKey(i2, context);
        }
        itbs.originalPosition = ++this.position;
        this.tupleArray.add(itbs);
    }

    public int compare(int a, int b) {
        try {
            for (int i2 = 0; i2 < this.comparers.length; ++i2) {
                int comp = this.comparers[i2].compareAtomicValues(this.tupleArray.get((int)a).sortKeyValues[i2], this.tupleArray.get((int)b).sortKeyValues[i2]);
                if (comp == 0) continue;
                return comp;
            }
        }
        catch (NoDynamicContextException e) {
            throw new AssertionError((Object)("Sorting without dynamic context: " + e.getMessage()));
        }
        return this.tupleArray.get((int)a).originalPosition - this.tupleArray.get((int)b).originalPosition;
    }

    public void swap(int a, int b) {
        ItemToBeSorted temp = this.tupleArray.get(a);
        this.tupleArray.set(a, this.tupleArray.get(b));
        this.tupleArray.set(b, temp);
    }

    public void close() throws XPathException {
        try {
            GenericSorter.quickSort(0, this.position, this);
        }
        catch (ClassCastException e) {
            XPathException err = new XPathException("Non-comparable types found while sorting: " + e.getMessage());
            err.setErrorCode("XPTY0004");
            throw err;
        }
        for (ItemToBeSorted itbs : this.tupleArray) {
            this.tupleExpr.setCurrentTuple(this.context, (Tuple)itbs.value);
            this.destination.processTuple(this.context);
        }
        this.destination.close();
    }
}

