/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleExpression
extends Expression {
    LocalVariableReference[] slots = new LocalVariableReference[0];

    public void setVariables(List<LocalVariableReference> refs) {
        this.slots = new LocalVariableReference[refs.size()];
        this.slots = refs.toArray(this.slots);
    }

    public LocalVariableReference[] getSlots() {
        return this.slots;
    }

    @Override
    public ItemType getItemType() {
        return new JavaExternalObjectType(Object.class, this.getConfiguration());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            this.slots[i2] = (LocalVariableReference)visitor.typeCheck(this.slots[i2], contextInfo);
        }
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>();
        for (LocalVariableReference e : this.slots) {
            list.add(new Operand(e, OperandRole.SAME_FOCUS_ACTION));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            if (original != this.slots[i2]) continue;
            this.slots[i2] = (LocalVariableReference)replacement;
            return true;
        }
        return false;
    }

    @Override
    public Expression copy() {
        LocalVariableReference[] refs2 = new LocalVariableReference[this.slots.length];
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            refs2[i2] = (LocalVariableReference)this.slots[i2].copy();
        }
        TupleExpression t2 = new TupleExpression();
        t2.slots = refs2;
        return t2;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("tuple");
        for (LocalVariableReference slot : this.slots) {
            slot.explain(out);
        }
        out.endElement();
    }

    @Override
    public Tuple evaluateItem(XPathContext context) throws XPathException {
        Sequence[] tuple = new Sequence[this.slots.length];
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            tuple[i2] = this.slots[i2].evaluateVariable(context);
        }
        return new Tuple(tuple);
    }

    public void setCurrentTuple(XPathContext context, Tuple tuple) {
        Sequence[] members = tuple.getMembers();
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            context.setLocalVariable(this.slots[i2].getBinding().getLocalSlotNumber(), members[i2]);
        }
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }
}

