/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Map;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSet {
    private StructuredQName[] keys;
    private Sequence[] values;
    private boolean[] typeChecked;
    private int used = 0;
    public static ParameterSet EMPTY_PARAMETER_SET = new ParameterSet(0);
    public static final int NOT_SUPPLIED = 0;
    public static final int SUPPLIED = 1;
    public static final int SUPPLIED_AND_CHECKED = 2;

    public ParameterSet() {
        this(10);
    }

    public ParameterSet(int capacity) {
        this.keys = new StructuredQName[capacity];
        this.values = new Sequence[capacity];
        this.typeChecked = new boolean[capacity];
    }

    public ParameterSet(Map<StructuredQName, Sequence> map) {
        this(map.size());
        int i2 = 0;
        for (Map.Entry<StructuredQName, Sequence> entry : map.entrySet()) {
            this.keys[i2] = entry.getKey();
            this.values[i2] = entry.getValue();
            this.typeChecked[i2++] = false;
        }
        this.used = i2;
    }

    public ParameterSet(ParameterSet existing, int extra) {
        this(existing.used + extra);
        for (int i2 = 0; i2 < existing.used; ++i2) {
            this.put(existing.keys[i2], existing.values[i2], existing.typeChecked[i2]);
        }
    }

    public void put(StructuredQName id, Sequence value, boolean checked) {
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (!this.keys[i2].equals(id)) continue;
            this.values[i2] = value;
            this.typeChecked[i2] = checked;
            return;
        }
        if (this.used + 1 > this.keys.length) {
            int newlength = this.used <= 5 ? 10 : this.used * 2;
            StructuredQName[] newkeys = new StructuredQName[newlength];
            boolean[] newChecked = new boolean[newlength];
            Sequence[] newvalues = new Sequence[newlength];
            System.arraycopy(this.values, 0, newvalues, 0, this.used);
            System.arraycopy(this.keys, 0, newkeys, 0, this.used);
            System.arraycopy(this.typeChecked, 0, newChecked, 0, this.used);
            this.values = newvalues;
            this.keys = newkeys;
            this.typeChecked = newChecked;
        }
        this.keys[this.used] = id;
        this.typeChecked[this.used] = checked;
        this.values[this.used++] = value;
    }

    public int getIndex(StructuredQName id) {
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (!this.keys[i2].equals(id)) continue;
            return i2;
        }
        return -1;
    }

    public Sequence getValue(int index) {
        return this.values[index];
    }

    public boolean isTypeChecked(int index) {
        return this.typeChecked[index];
    }

    public void clear() {
        this.used = 0;
    }

    public void materializeValues() throws XPathException {
        for (int i2 = 0; i2 < this.used; ++i2) {
            if (!(this.values[i2] instanceof Closure)) continue;
            this.values[i2] = ((Closure)this.values[i2]).reduce();
        }
    }
}

