/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ComponentBody;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends ComponentBody
implements RuleTarget {
    private Pattern matchPattern;
    private StructuredQName templateName;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private boolean declaredStreamable;
    private StructuredQName[] modeNames;
    private List<Rule> references = new ArrayList<Rule>();

    public Template() {
        this.setHostLanguage(50);
    }

    public void setTemplateName(StructuredQName templateName) {
        this.templateName = templateName;
    }

    public void setMatchPattern(Pattern pattern) {
        if (this.matchPattern != pattern) {
            for (Rule r : this.references) {
                r.setPattern(pattern);
            }
        }
        this.matchPattern = pattern;
    }

    @Override
    public int getComponentKind() {
        return 200;
    }

    public SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    @Override
    public void setBody(Expression body2) {
        super.setBody(body2);
        this.bodyIsTailCallReturner = body2 instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.templateName;
    }

    @Override
    public void allocateAllBindingSlots(StylesheetPackage pack) {
        super.allocateAllBindingSlots(pack);
        if (this.matchPattern != null) {
            Template.allocateBindingSlotsRecursive(pack, this, new PatternSponsor(this.matchPattern));
        }
    }

    @Override
    public StructuredQName getObjectName() {
        return this.templateName;
    }

    public void setHasRequiredParams(boolean has) {
        this.hasRequiredParams = has;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    public void setModeNames(StructuredQName[] modeNames) {
        this.modeNames = modeNames;
    }

    public StructuredQName[] getModeNames() {
        return this.modeNames;
    }

    @Override
    public void regiaterRule(Rule rule) {
        this.references.add(rule);
    }

    public void setDeclaredStreamable(boolean streamable) {
        this.declaredStreamable = streamable;
    }

    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    public List<LocalParam> getLocalParams() {
        ArrayList<LocalParam> result = new ArrayList<LocalParam>();
        Template.gatherLocalParams(this.getInterpretedBody(), result);
        return result;
    }

    private static void gatherLocalParams(Expression exp, List<LocalParam> result) {
        if (exp instanceof LocalParamSetter) {
            result.add(((LocalParamSetter)exp).getBinding());
        } else {
            for (Operand o : exp.operands()) {
                Template.gatherLocalParams(o.getExpression(), result);
            }
        }
    }

    public LocalParam getLocalParam(StructuredQName id) {
        for (Operand o : this.body.operands()) {
            LocalParam lp;
            Expression child = o.getExpression();
            if (child instanceof LocalParamSetter && ((LocalParamSetter)child).getBinding().getVariableQName().equals(id)) {
                return ((LocalParamSetter)child).getBinding();
            }
            if (!ExpressionTool.containsLocalParam(child) || (lp = Template.getLocalParam(child, id)) == null) continue;
            return lp;
        }
        return null;
    }

    private static LocalParam getLocalParam(Expression exp, StructuredQName id) {
        for (Operand o : exp.operands()) {
            Expression child = o.getExpression();
            if (child instanceof LocalParamSetter && ((LocalParamSetter)child).getBinding().getVariableQName().equals(id)) {
                return ((LocalParamSetter)child).getBinding();
            }
            if (!ExpressionTool.containsLocalParam(child)) continue;
            return Template.getLocalParam(child, id);
        }
        return null;
    }

    public void apply(XPathContextMajor context) throws XPathException {
        for (TailCall tc = this.applyLeavingTail(context); tc != null; tc = tc.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContextMajor context) throws XPathException {
        try {
            if (this.bodyIsTailCallReturner) {
                return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
            }
            this.body.process(context);
            return null;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        catch (Exception e2) {
            String message = "Internal error evaluating template " + (this.getTemplateName() != null ? this.getTemplateName().getDisplayName() : "") + (this.getLineNumber() > 0 ? " at line " + this.getLineNumber() : "") + (this.getSystemId() != null ? " in module " + this.getSystemId() : "");
            throw new RuntimeException(message, e2);
        }
    }

    public TailCall expand(XPathContext context) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
        }
        if (this.body != null) {
            this.body.process(context);
        }
        return null;
    }

    @Override
    public int getConstructType() {
        return 2008;
    }

    @Override
    public void explain(ExpressionPresenter presenter) {
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        if (this.isDeclaredStreamable()) {
            presenter.emitAttribute("streamable", "true");
        }
        if (this.getBody() != null) {
            this.getBody().explain(presenter);
        }
    }

    public Expression getInterpretedBody() {
        Expression original = this.body;
        return original;
    }
}

