/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WithParam {
    public static WithParam[] EMPTY_ARRAY = new WithParam[0];
    private Expression select;
    private boolean typeChecked = false;
    private int slotNumber;
    private SequenceType requiredType;
    private StructuredQName variableQName;
    private int evaluationMode = -1;

    public void setSelectExpression(Expression select) {
        this.select = select;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s2) {
        this.slotNumber = s2;
    }

    public void setVariableQName(StructuredQName s2) {
        this.variableQName = s2;
    }

    public StructuredQName getVariableQName() {
        return this.variableQName;
    }

    public void setTypeChecked(boolean checked) {
        this.typeChecked = checked;
    }

    public int getInstructionNameCode() {
        return 208;
    }

    public static void simplify(WithParam[] params, ExpressionVisitor visitor) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                param.select = visitor.simplify(param.select);
            }
        }
    }

    public static void typeCheck(WithParam[] params, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                param.select = visitor.typeCheck(param.select, contextItemType);
            }
        }
    }

    public static void optimize(ExpressionVisitor visitor, WithParam[] params, ContextItemStaticInfo contextItemType) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                param.select = visitor.typeCheck(param.select, contextItemType);
                param.computeEvaluationMode();
            }
        }
    }

    public static void promoteParams(Expression parent, WithParam[] params, PromotionOffer offer) throws XPathException {
        if (params != null) {
            for (WithParam param : params) {
                Expression select = param.select;
                if (select == null) continue;
                param.select = select.promote(offer, parent);
                param.computeEvaluationMode();
            }
        }
    }

    public static void setSlotNumbers(WithParam[] params) {
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        return this.evaluationMode;
    }

    private void computeEvaluationMode() {
        this.evaluationMode = ExpressionTool.lazyEvaluationMode(this.select);
    }

    public static WithParam[] copy(WithParam[] params) {
        if (params == null) {
            return null;
        }
        WithParam[] result = new WithParam[params.length];
        for (int i2 = 0; i2 < params.length; ++i2) {
            result[i2] = new WithParam();
            result[i2].slotNumber = params[i2].slotNumber;
            result[i2].typeChecked = params[i2].typeChecked;
            result[i2].select = params[i2].select.copy();
            result[i2].requiredType = params[i2].requiredType;
            result[i2].variableQName = params[i2].variableQName;
        }
        return result;
    }

    public static void gatherXPathExpressions(WithParam[] params, List<Expression> list) {
        if (params != null) {
            for (WithParam param : params) {
                list.add(param.select);
            }
        }
    }

    public static void gatherOperands(WithParam[] params, List<Operand> list) {
        if (params != null) {
            for (WithParam param : params) {
                list.add(new Operand(param.select, OperandRole.NAVIGATE));
            }
        }
    }

    public static void explainParameters(WithParam[] params, ExpressionPresenter out) {
        if (params != null) {
            for (WithParam param : params) {
                out.startElement("withParam");
                out.emitAttribute("name", param.variableQName.getDisplayName());
                param.select.explain(out);
                out.endElement();
            }
        }
    }

    public static boolean replaceXPathExpression(WithParam[] params, Expression original, Expression replacement) {
        boolean found = false;
        if (params != null) {
            for (WithParam param : params) {
                boolean f = param.replaceSubExpression(original, replacement);
                found |= f;
            }
        }
        return found;
    }

    private boolean replaceSubExpression(Expression original, Expression replacement) {
        if (this.select == original) {
            this.select = replacement;
            return true;
        }
        return false;
    }

    public Sequence getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new XPathException("Internal error: No select expression on xsl:with-param");
        }
        int savedOutputState = context.getTemporaryOutputState();
        context.setTemporaryOutputState(208);
        Sequence result = ExpressionTool.evaluate(this.select, this.evaluationMode, context, 10);
        context.setTemporaryOutputState(savedOutputState);
        return result;
    }

    public boolean isTypeChecked() {
        return this.typeChecked;
    }
}

