/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.util.List;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrregularGroupFormatter
extends NumericGroupFormatter {
    private IntSet groupingPositions = null;
    private List<Integer> separators = null;

    public IrregularGroupFormatter(IntSet groupingPositions, List<Integer> sep, UnicodeString adjustedPicture) {
        this.groupingPositions = groupingPositions;
        this.separators = sep;
        this.adjustedPicture = adjustedPicture;
    }

    @Override
    public String format(FastStringBuffer value) {
        UnicodeString in = UnicodeString.makeUnicodeString(value);
        int[] out = new int[in.uLength() + this.separators.size()];
        int j = 0;
        int k = out.length - 1;
        for (int i2 = in.uLength() - 1; i2 >= 0; --i2) {
            out[k--] = in.uCharAt(i2);
            if (!this.groupingPositions.contains(in.uLength() - i2)) continue;
            out[k--] = this.separators.get(j++);
        }
        return UnicodeString.makeUnicodeString(out).toString();
    }

    @Override
    public String getSeparator() {
        if (this.separators.size() == 0) {
            return null;
        }
        int sep = this.separators.get(this.separators.size() - 1);
        FastStringBuffer fsb = new FastStringBuffer(16);
        fsb.appendWideChar(sep);
        return fsb.toString();
    }
}

