/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CodepointMatchKey
implements Comparable,
AtomicMatchKey {
    private char[] value;
    private int hash = 0;

    public CodepointMatchKey(char[] in) {
        this.value = in;
    }

    public CodepointMatchKey(String in) {
        this.value = in.toCharArray();
    }

    public int compareTo(Object o) {
        if (o instanceof CodepointMatchKey) {
            int nextb;
            int nexta;
            int c;
            char[] a = this.value;
            char[] b = ((CodepointMatchKey)o).value;
            int alen = a.length;
            int blen = b.length;
            int i2 = 0;
            int j = 0;
            do {
                if (i2 == alen) {
                    if (j == blen) {
                        return 0;
                    }
                    return -1;
                }
                if (j == blen) {
                    return 1;
                }
                if ((nexta = a[i2++]) >= 55296 && nexta <= 56319) {
                    nexta = (nexta - 55296) * 1024 + (a[i2++] - 56320) + 65536;
                }
                if ((nextb = b[j++]) < 55296 || nextb > 56319) continue;
                nextb = (nextb - 55296) * 1024 + (b[j++] - 56320) + 65536;
            } while ((c = nexta - nextb) == 0);
            return c;
        }
        throw new ClassCastException();
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            char[] val = this.value;
            int len = val.length;
            for (int i2 = 0; i2 < len; ++i2) {
                h2 = 31 * h2 + val[i2];
            }
            this.hash = h2;
        }
        return h2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CodepointMatchKey) {
            char[] a = this.value;
            int alen = a.length;
            char[] b = ((CodepointMatchKey)o).value;
            if (alen != b.length) {
                return false;
            }
            while (--alen >= 0) {
                if (a[alen] == b[alen]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this.value);
    }

    public AtomicValue asAtomic() {
        return new StringValue(this.toString());
    }
}

