/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortExpression
extends Expression
implements SortKeyEvaluator {
    private Expression select = null;
    private SortKeyDefinition[] sortKeyDefinitions = null;
    private transient AtomicComparer[] comparators = null;
    private static final OperandRole SAME_FOCUS_SORT_KEY = new OperandRole(4, OperandUsage.ABSORPTION, SequenceType.OPTIONAL_ATOMIC);
    private static final OperandRole NEW_FOCUS_SORT_KEY = new OperandRole(6, OperandUsage.ABSORPTION, SequenceType.OPTIONAL_ATOMIC);

    public SortExpression(Expression select, SortKeyDefinition[] sortKeys) {
        this.select = select;
        this.sortKeyDefinitions = sortKeys;
        for (Operand o : this.operands()) {
            this.adoptChildExpression(o.getExpression());
        }
    }

    @Override
    public String getExpressionName() {
        return "sort";
    }

    public Expression getBaseExpression() {
        return this.select;
    }

    public SortKeyDefinition[] getSortKeyDefinitions() {
        return this.sortKeyDefinitions;
    }

    public AtomicComparer[] getComparators() {
        return this.comparators;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(8);
        list.add(new Operand(this.select, OperandRole.FOCUS_CONTROLLING_SELECT));
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            list.add(new Operand(sortKeyDefinition.getSortKey(), sortKeyDefinition.isSetContextForSortKey() ? NEW_FOCUS_SORT_KEY : SAME_FOCUS_SORT_KEY));
            Expression e = sortKeyDefinition.order;
            if (e != null) {
                list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
            }
            if ((e = sortKeyDefinition.caseOrder) != null) {
                list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
            }
            if ((e = sortKeyDefinition.dataTypeExpression) != null) {
                list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
            }
            if ((e = sortKeyDefinition.language) != null) {
                list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
            }
            if ((e = sortKeyDefinition.collationName) != null) {
                list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
            }
            if ((e = sortKeyDefinition.stable) == null) continue;
            list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
        }
        return list;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        if (this.sortKeyDefinitions != null) {
            for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
                if (sortKeyDefinition.isSetContextForSortKey()) {
                    sortKeyDefinition.getSortKey().addToPathMap(pathMap, target);
                } else {
                    sortKeyDefinition.getSortKey().addToPathMap(pathMap, pathMapNodeSet);
                }
                Expression e = sortKeyDefinition.getOrder();
                if (e != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = sortKeyDefinition.getCaseOrder()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = sortKeyDefinition.getDataTypeExpression()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = sortKeyDefinition.getLanguage()) != null) {
                    e.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((e = sortKeyDefinition.getCollationNameExpression()) == null) continue;
                e.addToPathMap(pathMap, pathMapNodeSet);
            }
        }
        return target;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            if (sortKeyDefinition.getSortKey() == original) {
                sortKeyDefinition.setSortKey(replacement, true);
                found = true;
            }
            if (sortKeyDefinition.getOrder() == original) {
                sortKeyDefinition.setOrder(replacement);
                found = true;
            }
            if (sortKeyDefinition.getCaseOrder() == original) {
                sortKeyDefinition.setCaseOrder(replacement);
                found = true;
            }
            if (sortKeyDefinition.getDataTypeExpression() == original) {
                sortKeyDefinition.setDataTypeExpression(replacement);
                found = true;
            }
            if (sortKeyDefinition.getLanguage() == original) {
                sortKeyDefinition.setLanguage(replacement);
                found = true;
            }
            if (sortKeyDefinition.collationName == original) {
                sortKeyDefinition.collationName = replacement;
                found = true;
            }
            if (sortKeyDefinition.stable != original) continue;
            sortKeyDefinition.stable = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression select2 = visitor.typeCheck(this.select, contextInfo);
        if (select2 != this.select) {
            this.adoptChildExpression(select2);
            this.select = select2;
        }
        if (!Cardinality.allowsMany(select2.getCardinality())) {
            return select2;
        }
        ItemType sortedItemType = this.select.getItemType();
        boolean allKeysFixed = true;
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            if (sortKeyDefinition.isFixed()) continue;
            allKeysFixed = false;
            break;
        }
        if (allKeysFixed) {
            this.comparators = new AtomicComparer[this.sortKeyDefinitions.length];
        }
        for (int i2 = 0; i2 < this.sortKeyDefinitions.length; ++i2) {
            Expression sortKey = this.sortKeyDefinitions[i2].getSortKey();
            if (this.sortKeyDefinitions[i2].isSetContextForSortKey()) {
                ContextItemStaticInfo cit = new ContextItemStaticInfo(sortedItemType, false);
                sortKey = visitor.typeCheck(sortKey, cit);
            } else {
                sortKey = visitor.typeCheck(sortKey, contextInfo);
            }
            if (visitor.getStaticContext().isInBackwardsCompatibleMode()) {
                sortKey = FirstItemExpression.makeFirstItemExpression(sortKey);
            } else {
                RoleLocator role = new RoleLocator(4, "xsl:sort/select", 0);
                role.setErrorCode("XTTE1020");
                sortKey = TypeChecker.staticTypeCheck(sortKey, SequenceType.OPTIONAL_ATOMIC, false, role, visitor);
            }
            this.sortKeyDefinitions[i2].setSortKey(sortKey, this.sortKeyDefinitions[i2].isSetContextForSortKey());
            this.sortKeyDefinitions[i2].typeCheck(visitor, contextInfo);
            if (this.sortKeyDefinitions[i2].isFixed()) {
                AtomicComparer comp = this.sortKeyDefinitions[i2].makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                this.sortKeyDefinitions[i2].setFinalComparator(comp);
                if (allKeysFixed) {
                    this.comparators[i2] = comp;
                }
            }
            if (!this.sortKeyDefinitions[i2].isSetContextForSortKey() || ExpressionTool.dependsOnFocus(sortKey)) continue;
            visitor.getStaticContext().issueWarning("Sort key will have no effect because its value does not depend on the context item", sortKey);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ContextItemStaticInfo cit;
        Expression select2 = visitor.optimize(this.select, contextItemType);
        if (select2 != this.select) {
            this.adoptChildExpression(select2);
            this.select = select2;
        }
        if (this.sortKeyDefinitions[0].isSetContextForSortKey()) {
            ItemType sortedItemType = this.select.getItemType();
            cit = new ContextItemStaticInfo(sortedItemType, false);
        } else {
            cit = contextItemType;
        }
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            Expression sortKey = sortKeyDefinition.getSortKey();
            sortKey = visitor.optimize(sortKey, cit);
            sortKeyDefinition.setSortKey(sortKey, true);
        }
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return this;
        }
        return this.select;
    }

    @Override
    public Expression copy() {
        SortKeyDefinition[] sk2 = new SortKeyDefinition[this.sortKeyDefinitions.length];
        for (int i2 = 0; i2 < this.sortKeyDefinitions.length; ++i2) {
            sk2[i2] = this.sortKeyDefinitions[i2].copy();
        }
        SortExpression se2 = new SortExpression(this.select.copy(), sk2);
        se2.comparators = this.comparators;
        return se2;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.select = this.doPromotion(this.select, offer);
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            Expression sk2 = sortKeyDefinition.getSortKey().promote(offer, parent);
            sortKeyDefinition.setSortKey(sk2, true);
            if (sortKeyDefinition.order != null) {
                sortKeyDefinition.order = sortKeyDefinition.order.promote(offer, parent);
            }
            if (sortKeyDefinition.stable != null) {
                sortKeyDefinition.stable = sortKeyDefinition.stable.promote(offer, parent);
            }
            if (sortKeyDefinition.caseOrder != null) {
                sortKeyDefinition.caseOrder = sortKeyDefinition.caseOrder.promote(offer, parent);
            }
            if (sortKeyDefinition.dataTypeExpression != null) {
                sortKeyDefinition.dataTypeExpression = sortKeyDefinition.dataTypeExpression.promote(offer, parent);
            }
            if (sortKeyDefinition.language != null) {
                sortKeyDefinition.language = sortKeyDefinition.language.promote(offer, parent);
            }
            if (sortKeyDefinition.collationName == null) continue;
            sortKeyDefinition.collationName = sortKeyDefinition.collationName.promote(offer, parent);
        }
        return this;
    }

    public boolean isSortKey(Expression child) {
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            Expression exp = sortKeyDefinition.getSortKey();
            if (exp != child) continue;
            return true;
        }
        return false;
    }

    @Override
    public int computeCardinality() {
        return this.select.getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.select.getItemType();
    }

    @Override
    public int computeSpecialProperties() {
        int props = 0;
        if ((this.select.getSpecialProperties() & 0x10000) != 0) {
            props |= 0x10000;
        }
        if ((this.select.getSpecialProperties() & 0x800000) != 0) {
            props |= 0x800000;
        }
        if ((this.select.getSpecialProperties() & 0x400000) != 0) {
            props |= 0x400000;
        }
        return props;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator iter = this.select.iterate(context);
        if (iter instanceof EmptyIterator) {
            return iter;
        }
        AtomicComparer[] comps = this.comparators;
        if (this.comparators == null) {
            comps = new AtomicComparer[this.sortKeyDefinitions.length];
            for (int s2 = 0; s2 < this.sortKeyDefinitions.length; ++s2) {
                AtomicComparer comp = this.sortKeyDefinitions[s2].getFinalComparator();
                if (comp == null) {
                    comp = this.sortKeyDefinitions[s2].makeComparator(context);
                }
                comps[s2] = comp;
            }
        }
        iter = new SortedIterator(context, iter, this, comps, this.sortKeyDefinitions[0].isSetContextForSortKey());
        ((SortedIterator)iter).setHostLanguage(this.getHostLanguage());
        return iter;
    }

    @Override
    public AtomicValue evaluateSortKey(int n, XPathContext c) throws XPathException {
        return (AtomicValue)this.sortKeyDefinitions[n].getSortKey().evaluateItem(c);
    }

    @Override
    public String toShortString() {
        return "sort(" + this.getBaseExpression().toShortString() + ")";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("sort");
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        for (SortKeyDefinition sortKeyDefinition : this.sortKeyDefinitions) {
            out.startSubsidiaryElement("by");
            sortKeyDefinition.getSortKey().explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

