/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;

public abstract class FoldingFunction
extends SystemFunctionCall
implements Callable {
    public abstract Fold getFold(XPathContext var1, Sequence ... var2) throws XPathException;

    public int getImplementationMethod() {
        return 17;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item;
        Sequence[] additionalArgs = new Sequence[this.argument.length - 1];
        for (int i2 = 1; i2 < this.argument.length; ++i2) {
            additionalArgs[i2 - 1] = SequenceTool.toLazySequence(this.argument[i2].iterate(context));
        }
        Fold fold = this.getFold(context, additionalArgs);
        SequenceIterator iter = this.argument[0].iterate(context);
        while ((item = iter.next()) != null) {
            fold.processItem(item);
            if (!fold.isFinished()) continue;
            return fold.result().head();
        }
        return fold.result().head();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Sequence[] additionalArgs = new Sequence[this.argument.length - 1];
        for (int i2 = 1; i2 < this.argument.length; ++i2) {
            additionalArgs[i2 - 1] = SequenceTool.toLazySequence(this.argument[i2].iterate(context));
        }
        Fold fold = this.getFold(context, additionalArgs);
        SequenceIterator iter = this.argument[0].iterate(context);
        do {
            Item item;
            if ((item = iter.next()) == null) {
                return fold.result().iterate();
            }
            fold.processItem(item);
        } while (!fold.isFinished());
        return fold.result().iterate();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence[] additionalArgs = new Sequence[arguments.length - 1];
        System.arraycopy(arguments, 1, additionalArgs, 0, additionalArgs.length);
        Fold fold = this.getFold(context, additionalArgs);
        SequenceIterator iter = arguments[0].iterate();
        do {
            Item item;
            if ((item = iter.next()) == null) {
                return fold.result();
            }
            fold.processItem(item);
        } while (!fold.isFinished());
        return fold.result();
    }
}

