/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FunctionAvailable
extends Available
implements Callable {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        String lexicalQName = ((Literal)this.argument[0]).getValue().getStringValue();
        StaticContext env = visitor.getStaticContext();
        boolean b = false;
        int minArity = 0;
        int maxArity = 20;
        if (this.argument.length == 2) {
            maxArity = minArity = (int)((NumericValue)this.argument[1].evaluateItem(env.makeEarlyEvaluationContext())).longValue();
        }
        try {
            String[] parts = NameChecker.getQNameParts(lexicalQName);
            String prefix = parts[0];
            String uri = prefix.length() == 0 ? env.getDefaultFunctionNamespace() : env.getURIForPrefix(prefix);
            StructuredQName functionName = new StructuredQName(prefix, uri, parts[1]);
            if ("node-set".equals(parts[1]) && "http://exslt.org/common".equals(uri) && minArity <= 1 && maxArity >= 1) {
                return Literal.makeLiteral(BooleanValue.TRUE, this.getContainer());
            }
            for (int i2 = minArity; i2 <= maxArity; ++i2) {
                SymbolicName sn = new SymbolicName(155, functionName, i2);
                if (!env.getFunctionLibrary().isAvailable(sn)) continue;
                b = true;
                break;
            }
        }
        catch (QNameException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("XTDE1400");
            throw err;
        }
        catch (XPathException e2) {
            if ("XTDE0290".equals(e2.getErrorCodeLocalPart())) {
                e2.setErrorCode("XTDE1400");
            }
            throw e2;
        }
        return Literal.makeLiteral(BooleanValue.get(b), this.getContainer());
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        long arity = -1L;
        if (this.argument.length == 2) {
            arity = ((NumericValue)this.argument[1].evaluateItem(context)).longValue();
        }
        StringValue nameValue = (StringValue)av1;
        String lexicalName = nameValue.getStringValue();
        boolean b = this.isFunctionAvailable(lexicalName, (int)arity, context);
        return BooleanValue.get(b);
    }

    private boolean isFunctionAvailable(String lexicalName, int arity, XPathContext context) throws XPathException {
        StructuredQName qName;
        if (arity == -1) {
            for (int i2 = 0; i2 < 20; ++i2) {
                if (!this.isFunctionAvailable(lexicalName, i2, context)) continue;
                return true;
            }
            return false;
        }
        try {
            if (lexicalName.indexOf(58) < 0 && !lexicalName.startsWith("Q{")) {
                String uri = "http://www.w3.org/2005/xpath-functions";
                qName = new StructuredQName("", uri, lexicalName);
            } else {
                boolean is30 = context.getController().getExecutable().isAllowXPath30();
                qName = StructuredQName.fromLexicalQName(lexicalName, false, is30, this.nsContext);
            }
        }
        catch (XPathException e) {
            e.setErrorCode("XTDE1400");
            e.setLocator(this);
            e.setXPathContext(context);
            throw e;
        }
        if ("node-set".equals(qName.getLocalPart()) && qName.hasURI("http://exslt.org/common") && arity == 1) {
            return true;
        }
        FunctionLibraryList lib = context.getController().getExecutable().getFunctionLibrary();
        SymbolicName sn = new SymbolicName(155, qName, arity);
        return lib.isAvailable(sn);
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        String lexicalQName = arguments[0].head().getStringValue();
        int arity = -1;
        if (arguments.length == 2) {
            arity = (int)((NumericValue)arguments[1].head()).longValue();
        }
        return BooleanValue.get(this.isFunctionAvailable(lexicalQName, arity, context));
    }
}

