/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class Id
extends SystemFunctionCall
implements Callable {
    public static final int ID = 0;
    public static final int ELEMENT_WITH_ID = 1;
    private boolean isSingletonId = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Id id = (Id)super.simplify(visitor);
        if (this.argument.length == 1) {
            id.addContextDocumentArgument(1, this.getFunctionName().getLocalPart());
        }
        return id;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.argument[1] instanceof RootExpression && contextInfo != null && contextInfo.getItemType() != null && contextInfo.getItemType().isPlainType()) {
            XPathException err = new XPathException(this.getFunctionName().getLocalPart() + "() function called when the context item is not a node");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextInfo);
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        this.argument[0] = this.argument[0].unordered(false, false);
        this.isSingletonId = !Cardinality.allowsMany(this.argument[0].getCardinality());
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        target = target.createArc((byte)4, NodeKindTest.ELEMENT);
        return target;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo arg1;
        try {
            arg1 = (NodeInfo)this.argument[1].evaluateItem(context);
        }
        catch (XPathException e) {
            if (context.getContextItem() instanceof AtomicValue) {
                XPathException e2 = new XPathException("id() function called when the context item is not a node");
                e2.setErrorCode("XPTY0004");
                e2.setXPathContext(context);
                e2.setLocator(this);
                throw e2;
            }
            throw e;
        }
        arg1 = arg1.getRoot();
        if (arg1.getNodeKind() != 9) {
            this.dynamicError("In the " + this.getFunctionName().getLocalPart() + "() function," + " the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg1;
        if (this.isSingletonId) {
            AtomicValue arg = (AtomicValue)this.argument[0].evaluateItem(context);
            if (arg == null) {
                return EmptyIterator.emptyIterator();
            }
            String idrefs = arg.getStringValue();
            return Id.getIdSingle(doc, idrefs, this.operation);
        }
        SequenceIterator idrefs = this.argument[0].iterate(context);
        return Id.getIdMultiple(doc, idrefs, this.operation);
    }

    public static SequenceIterator getIdSingle(DocumentInfo doc, String idrefs, int operation) throws XPathException {
        boolean white = false;
        for (int i2 = idrefs.length() - 1; i2 >= 0; --i2) {
            char c = idrefs.charAt(i2);
            if (c > ' ' || c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
            white = true;
            break;
        }
        if (white) {
            StringTokenIterator tokens = new StringTokenIterator(idrefs);
            IdMappingFunction map = new IdMappingFunction();
            map.document = doc;
            map.operation = operation;
            MappingIterator<StringValue, NodeInfo> result = new MappingIterator<StringValue, NodeInfo>(tokens, map);
            return new DocumentOrderIterator(result, LocalOrderComparer.getInstance());
        }
        return SingletonIterator.makeIterator(doc.selectID(idrefs, operation == 1));
    }

    public static SequenceIterator getIdMultiple(DocumentInfo doc, SequenceIterator idrefs, int operation) throws XPathException {
        IdMappingFunction map = new IdMappingFunction();
        map.document = doc;
        map.operation = operation;
        MappingIterator<StringValue, NodeInfo> result = new MappingIterator<StringValue, NodeInfo>(idrefs, map);
        return new DocumentOrderIterator(result, LocalOrderComparer.getInstance());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo start = arguments.length == 1 ? this.getContextNode(context) : (NodeInfo)arguments[1].head();
        NodeInfo arg1 = start.getRoot();
        if (arg1.getNodeKind() != 9) {
            this.dynamicError("In the " + this.getFunctionName().getLocalPart() + "() function," + " the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg1;
        SequenceIterator idrefs = arguments[0].iterate();
        return SequenceTool.toLazySequence(Id.getIdMultiple(doc, idrefs, this.operation));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdMappingFunction
    implements MappingFunction<StringValue, NodeInfo> {
        public DocumentInfo document;
        private int operation;

        private IdMappingFunction() {
        }

        @Override
        public SequenceIterator map(StringValue item) throws XPathException {
            String idrefs = Whitespace.trim(item.getStringValueCS());
            if (Whitespace.containsWhitespace(idrefs)) {
                StringTokenIterator tokens = new StringTokenIterator(idrefs);
                IdMappingFunction submap = new IdMappingFunction();
                submap.document = this.document;
                submap.operation = this.operation;
                return new MappingIterator<StringValue, NodeInfo>(tokens, submap);
            }
            return SingletonIterator.makeIterator(this.document.selectID(idrefs, this.operation == 1));
        }
    }
}

