/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private BuiltInAtomicType argumentType = BuiltInAtomicType.ANY_ATOMIC;
    private boolean ignoreNaN = false;

    protected int getCollationArgument() {
        return 1;
    }

    public void setIgnoreNaN(boolean ignore) {
        this.ignoreNaN = ignore;
    }

    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    public AtomicComparer getComparer() {
        return this.getPreAllocatedAtomicComparer();
    }

    public BuiltInAtomicType getArgumentType() {
        return this.argumentType;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        this.argument[0] = this.argument[0].unordered(false, false);
        ItemType type = this.argument[0].getItemType();
        if (type instanceof AtomicType) {
            if (type == BuiltInAtomicType.UNTYPED_ATOMIC) {
                type = BuiltInAtomicType.DOUBLE;
            }
            this.preAllocateComparer((AtomicType)type, (AtomicType)type, visitor.getStaticContext(), false);
        }
    }

    public int computeCardinality() {
        int c = super.computeCardinality();
        if (!Cardinality.allowsZero(this.argument[0].getCardinality())) {
            c = 16384;
        }
        return c;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        StaticContext env = visitor.getStaticContext();
        if (Literal.isEmptySequence(this.argument[0])) {
            return this.argument[0];
        }
        this.argumentType = (BuiltInAtomicType)this.argument[0].getItemType().getPrimitiveItemType();
        PlainType t0 = (PlainType)this.argument[0].getItemType();
        if (t0.isExternalType()) {
            XPathException err = new XPathException("Cannot perform computation involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        BuiltInAtomicType p0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        if (p0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p0 = BuiltInAtomicType.DOUBLE;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        int card;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (this.getNumberOfArguments() == 1 && !Cardinality.allowsMany(card = this.argument[0].getCardinality()) && th.isSubType(this.argument[0].getItemType(), BuiltInAtomicType.NUMERIC)) {
            return this.argument[0];
        }
        return this;
    }

    public ItemType getItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType t = Atomizer.getAtomizedItemType(this.argument[0], false, th);
        if (t.getPrimitiveType() == 631) {
            return BuiltInAtomicType.DOUBLE;
        }
        return t;
    }

    public Expression copy() {
        Minimax m3 = (Minimax)super.copy();
        m3.argumentType = this.argumentType;
        m3.ignoreNaN = this.ignoreNaN;
        return m3;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        AtomicComparer comparer = this.getPreAllocatedAtomicComparer();
        if (comparer == null) {
            comparer = this.getAtomicComparer(this.getCollator(context), context);
        }
        SequenceIterator iter = this.argument[0].iterate(context);
        try {
            return Minimax.minimax(iter, this.operation, comparer, this.ignoreNaN, context);
        }
        catch (XPathException err) {
            err.setLocator(this);
            throw err;
        }
    }

    public AtomicComparer getAtomicComparer(XPathContext context) throws XPathException {
        AtomicComparer comparer = this.getPreAllocatedAtomicComparer();
        if (comparer != null) {
            return comparer;
        }
        StringCollator collator = this.getCollator(context);
        BuiltInAtomicType type = this.argumentType;
        if (type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            type = BuiltInAtomicType.DOUBLE;
        }
        return GenericAtomicComparer.makeAtomicComparer(type, type, collator, context);
    }

    public static AtomicValue minimax(SequenceIterator iter, int operation, AtomicComparer atomicComparer, boolean ignoreNaN, XPathContext context) throws XPathException {
        AtomicValue test;
        AtomicValue prim;
        AtomicValue min2;
        boolean foundString;
        boolean foundNaN;
        boolean foundFloat;
        boolean foundDouble;
        StringToDouble converter;
        ConversionRules rules;
        block40: {
            block39: {
                TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
                rules = context.getConfiguration().getConversionRules();
                converter = context.getConfiguration().getConversionRules().getStringToDoubleConverter();
                foundDouble = false;
                foundFloat = false;
                foundNaN = false;
                foundString = false;
                if (operation == 3) {
                    atomicComparer = new DescendingComparer(atomicComparer);
                }
                atomicComparer = atomicComparer.provideContext(context);
                do {
                    if ((min2 = (AtomicValue)iter.next()) == null) {
                        return null;
                    }
                    prim = min2;
                    if (min2 instanceof UntypedAtomicValue) {
                        try {
                            prim = min2 = new DoubleValue(converter.stringToNumber(min2.getStringValueCS()));
                            foundDouble = true;
                        }
                        catch (NumberFormatException e) {
                            XPathException de = new XPathException("Failure converting " + Err.wrap(min2.getStringValueCS()) + " to a number");
                            de.setErrorCode("FORG0001");
                            de.setXPathContext(context);
                            throw de;
                        }
                    } else if (prim instanceof DoubleValue) {
                        foundDouble = true;
                    } else if (prim instanceof FloatValue) {
                        foundFloat = true;
                    } else if (prim instanceof StringValue && !(prim instanceof AnyURIValue)) {
                        foundString = true;
                    }
                    if (!prim.isNaN()) break block39;
                } while (ignoreNaN);
                if (prim instanceof DoubleValue) {
                    return min2;
                }
                foundNaN = true;
                min2 = FloatValue.NaN;
                break block40;
            }
            if (!prim.getPrimitiveType().isOrdered(false)) {
                XPathException de = new XPathException("Type " + prim.getPrimitiveType() + " is not an ordered type");
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
        }
        while ((test = (AtomicValue)iter.next()) != null) {
            AtomicValue test2;
            prim = test2 = test;
            if (test instanceof UntypedAtomicValue) {
                try {
                    test2 = new DoubleValue(converter.stringToNumber(test.getStringValueCS()));
                    if (foundNaN) {
                        return DoubleValue.NaN;
                    }
                    prim = test2;
                    foundDouble = true;
                }
                catch (NumberFormatException e) {
                    XPathException de = new XPathException("Failure converting " + Err.wrap(test.getStringValueCS()) + " to a number");
                    de.setErrorCode("FORG0001");
                    de.setXPathContext(context);
                    throw de;
                }
            } else if (prim instanceof DoubleValue) {
                if (foundNaN) {
                    return DoubleValue.NaN;
                }
                foundDouble = true;
            } else if (prim instanceof FloatValue) {
                foundFloat = true;
            } else if (prim instanceof StringValue && !(prim instanceof AnyURIValue)) {
                foundString = true;
            }
            if (prim.isNaN()) {
                if (ignoreNaN) continue;
                if (foundDouble) {
                    return DoubleValue.NaN;
                }
                foundNaN = true;
                continue;
            }
            try {
                if (atomicComparer.compareAtomicValues(prim, min2) >= 0) continue;
                min2 = test2;
            }
            catch (ClassCastException err) {
                if (min2.getItemType() == test2.getItemType()) {
                    throw err;
                }
                XPathException de = new XPathException("Cannot compare " + min2.getItemType() + " with " + test2.getItemType());
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
        }
        if (foundNaN) {
            return FloatValue.NaN;
        }
        if (foundDouble) {
            if (!(min2 instanceof DoubleValue)) {
                min2 = Converter.convert(min2, BuiltInAtomicType.DOUBLE, rules);
            }
        } else if (foundFloat) {
            if (!(min2 instanceof FloatValue)) {
                min2 = Converter.convert(min2, BuiltInAtomicType.FLOAT, rules);
            }
        } else if (min2 instanceof AnyURIValue && foundString) {
            min2 = Converter.convert(min2, BuiltInAtomicType.STRING, rules);
        }
        return min2;
    }
}

