/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeUnicode
extends SystemFunctionCall
implements Callable {
    public StringValue evaluateItem(XPathContext c) throws XPathException {
        StringValue sv = (StringValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        String form = this.argument.length == 1 ? "NFC" : Whitespace.trim(this.argument[1].evaluateAsString(c));
        return this.normalize(sv, form, c);
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue sv = (StringValue)arguments[0].head();
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        String nf = arguments.length == 1 ? "NFC" : Whitespace.trim(arguments[1].head().getStringValue());
        return this.normalize(sv, nf, context);
    }

    public StringValue normalize(StringValue sv, String form, XPathContext c) throws XPathException {
        int fb = 2;
        if (this.argument.length == 2) {
            if (form.equalsIgnoreCase("NFC")) {
                fb = 2;
            } else if (form.equalsIgnoreCase("NFD")) {
                fb = 0;
            } else if (form.equalsIgnoreCase("NFKC")) {
                fb = 3;
            } else if (form.equalsIgnoreCase("NFKD")) {
                fb = 1;
            } else {
                if (form.length() == 0) {
                    return sv;
                }
                String msg = "Normalization form " + form + " is not supported";
                XPathException err = new XPathException(msg);
                err.setErrorCode("FOCH0003");
                err.setXPathContext(c);
                err.setLocator(this);
                throw err;
            }
        }
        boolean allASCII = true;
        CharSequence chars = sv.getStringValueCS();
        if (chars instanceof CompressedWhitespace) {
            return sv;
        }
        for (int i2 = chars.length() - 1; i2 >= 0; --i2) {
            if (chars.charAt(i2) <= '\u007f') continue;
            allASCII = false;
            break;
        }
        if (allASCII) {
            return sv;
        }
        Normalizer norm = new Normalizer(fb, c.getConfiguration());
        CharSequence result = norm.normalize(sv.getStringValueCS());
        return StringValue.makeStringValue(result);
    }
}

