/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Substring
extends SystemFunctionCall
implements Callable {
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression a2;
        Expression a1;
        Expression e2 = super.typeCheck(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.argument[1] instanceof NumberFn && th.isSubType((a1 = ((NumberFn)this.argument[1]).getArguments()[0]).getItemType(), BuiltInAtomicType.INTEGER)) {
            this.argument[1] = a1;
        }
        if (this.argument.length > 2 && this.argument[2] instanceof NumberFn && th.isSubType((a2 = ((NumberFn)this.argument[2]).getArguments()[0]).getItemType(), BuiltInAtomicType.INTEGER)) {
            this.argument[2] = a2;
        }
        return this;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av == null) {
            return StringValue.EMPTY_STRING;
        }
        StringValue sv = (StringValue)av;
        if (sv.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        AtomicValue a1 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue a = (NumericValue)a1;
        if (this.argument.length == 2) {
            return StringValue.makeStringValue(Substring.substring(sv, a));
        }
        AtomicValue b2 = (AtomicValue)this.argument[2].evaluateItem(context);
        NumericValue b = (NumericValue)b2;
        return StringValue.makeStringValue(Substring.substring(sv, a, b));
    }

    public static UnicodeString substring(StringValue sv, NumericValue start) {
        long lstart;
        UnicodeString s2 = sv.getUnicodeString();
        int slength = s2.uLength();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > (long)slength) {
                return UnicodeString.EMPTY_STRING;
            }
            if (lstart <= 0L) {
                lstart = 1L;
            }
        } else {
            if (start.isNaN()) {
                return UnicodeString.EMPTY_STRING;
            }
            if (start.signum() <= 0) {
                return s2;
            }
            if (start.compareTo(slength) > 0) {
                return UnicodeString.EMPTY_STRING;
            }
            lstart = Math.round(start.getDoubleValue());
        }
        if (lstart > (long)s2.uLength()) {
            return UnicodeString.EMPTY_STRING;
        }
        return s2.uSubstring((int)lstart - 1, s2.uLength());
    }

    public static UnicodeString substring(StringValue sv, NumericValue start, NumericValue len) {
        long lend;
        long llen;
        long lstart;
        int slength = sv.getStringLengthUpperBound();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > (long)slength) {
                return UnicodeString.EMPTY_STRING;
            }
        } else {
            if (start.isNaN()) {
                return UnicodeString.EMPTY_STRING;
            }
            if (start.compareTo(slength) > 0) {
                return UnicodeString.EMPTY_STRING;
            }
            double dstart = start.getDoubleValue();
            long l = lstart = Double.isInfinite(dstart) ? -2147483647L : Math.round(dstart);
        }
        if (len instanceof Int64Value) {
            llen = ((Int64Value)len).longValue();
            if (llen <= 0L) {
                return UnicodeString.EMPTY_STRING;
            }
        } else {
            if (len.isNaN()) {
                return UnicodeString.EMPTY_STRING;
            }
            if (len.signum() <= 0) {
                return UnicodeString.EMPTY_STRING;
            }
            double dlen = len.getDoubleValue();
            llen = Double.isInfinite(dlen) ? Integer.MAX_VALUE : Math.round(len.getDoubleValue());
        }
        if ((lend = lstart + llen) < lstart) {
            return UnicodeString.EMPTY_STRING;
        }
        int a1 = (int)lstart - 1;
        UnicodeString us = sv.getUnicodeString();
        int clength = us.uLength();
        if (a1 >= clength) {
            return UnicodeString.EMPTY_STRING;
        }
        int a2 = Math.min(clength, (int)lend - 1);
        if (a1 < 0) {
            if (a2 < 0) {
                return UnicodeString.EMPTY_STRING;
            }
            a1 = 0;
        }
        return us.uSubstring(a1, a2);
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg0 = (StringValue)arguments[0].head();
        NumericValue arg1 = (NumericValue)arguments[1].head();
        if (arguments.length == 2) {
            return StringValue.makeStringValue(Substring.substring(arg0, arg1));
        }
        NumericValue arg2 = (NumericValue)arguments[2].head();
        return StringValue.makeStringValue(Substring.substring(arg0, arg1, arg2));
    }
}

