/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public class Translate
extends SystemFunctionCall
implements Callable {
    private IntToIntMap staticMap = null;

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.typeCheck(visitor, contextInfo);
        if (e == this && this.argument[1] instanceof StringLiteral && this.argument[2] instanceof StringLiteral) {
            this.staticMap = Translate.buildMap((StringValue)((StringLiteral)this.argument[1]).getValue(), (StringValue)((StringLiteral)this.argument[2]).getValue());
        }
        return e;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        StringValue sv1 = (StringValue)this.argument[0].evaluateItem(context);
        if (sv1 == null) {
            return StringValue.EMPTY_STRING;
        }
        if (this.staticMap != null) {
            CharSequence sb = Translate.translateUsingMap(sv1, this.staticMap);
            return new StringValue(sb);
        }
        StringValue sv2 = (StringValue)this.argument[1].evaluateItem(context);
        StringValue sv3 = (StringValue)this.argument[2].evaluateItem(context);
        return StringValue.makeStringValue(Translate.translate(sv1, sv2, sv3));
    }

    public IntToIntMap getStaticMap() {
        return this.staticMap;
    }

    public static CharSequence translate(StringValue sv0, StringValue sv1, StringValue sv2) {
        if (sv0.containsSurrogatePairs() || sv1.containsSurrogatePairs() || sv2.containsSurrogatePairs()) {
            return Translate.translateUsingMap(sv0, Translate.buildMap(sv1, sv2));
        }
        if (sv0.getStringLength() * sv1.getStringLength() > 1000) {
            return Translate.translateUsingMap(sv0, Translate.buildMap(sv1, sv2));
        }
        CharSequence cs0 = sv0.getStringValueCS();
        CharSequence cs1 = sv1.getStringValueCS();
        CharSequence cs2 = sv2.getStringValueCS();
        String st1 = cs1.toString();
        FastStringBuffer sb = new FastStringBuffer(cs0.length());
        int s2len = cs2.length();
        int s0len = cs0.length();
        for (int i2 = 0; i2 < s0len; ++i2) {
            char c = cs0.charAt(i2);
            int j = st1.indexOf(c);
            if (j >= s2len) continue;
            sb.append(j < 0 ? c : cs2.charAt(j));
        }
        return sb;
    }

    private static IntToIntMap buildMap(StringValue arg1, StringValue arg2) {
        UnicodeString a1 = arg1.getUnicodeString();
        UnicodeString a2 = arg2.getUnicodeString();
        IntToIntHashMap map = new IntToIntHashMap(a1.uLength(), 0.5);
        for (int i2 = 0; i2 < a1.uLength(); ++i2) {
            if (map.find(a1.uCharAt(i2))) continue;
            map.put(a1.uCharAt(i2), i2 > a2.uLength() - 1 ? -1 : a2.uCharAt(i2));
        }
        return map;
    }

    public static CharSequence translateUsingMap(StringValue in, IntToIntMap map) {
        UnicodeString us = in.getUnicodeString();
        int len = us.uLength();
        FastStringBuffer sb = new FastStringBuffer(len);
        for (int i2 = 0; i2 < len; ++i2) {
            int c = us.uCharAt(i2);
            int newchar = map.get(c);
            if (newchar == Integer.MAX_VALUE) {
                newchar = c;
            }
            if (newchar == -1) continue;
            sb.appendWideChar(newchar);
        }
        return sb;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue sv0 = (StringValue)arguments[0].head();
        StringValue sv1 = (StringValue)arguments[1].head();
        StringValue sv2 = (StringValue)arguments[2].head();
        return new StringValue(Translate.translate(sv0, sv1, sv2));
    }
}

