/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.z.IntPredicate;
import org.xml.sax.XMLReader;

public class StandardCollectionURIResolver
implements CollectionURIResolver {
    public SequenceIterator resolve(String href, String base, XPathContext context) throws XPathException {
        URI relativeURI;
        if (href == null) {
            XPathException err = new XPathException("No default collection has been defined");
            err.setErrorCode("FODC0002");
            err.setXPathContext(context);
            throw err;
        }
        URIQueryParameters params = null;
        try {
            relativeURI = new URI(ResolveURI.escapeSpaces(href));
            String query = relativeURI.getQuery();
            if (query != null) {
                params = new URIQueryParameters(query, context.getConfiguration());
                int q = href.indexOf(63);
                href = ResolveURI.escapeSpaces(href.substring(0, q));
                relativeURI = new URI(href);
            }
        }
        catch (URISyntaxException e) {
            XPathException err = new XPathException("Invalid relative URI " + Err.wrap(href, 4) + " passed to collection() function");
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        URI resolvedURI = this.makeAbsoluteURI(href, base, context, relativeURI);
        if ("file".equals(resolvedURI.getScheme())) {
            File file = new File(resolvedURI);
            if (!file.exists()) {
                XPathException err = new XPathException("The file or directory " + resolvedURI + " does not exist");
                err.setErrorCode("FODC0002");
                err.setXPathContext(context);
                throw err;
            }
            if (file.isDirectory()) {
                return this.directoryContents(file, params, context);
            }
        }
        return this.catalogContents(href, base, resolvedURI.toString(), context);
    }

    protected URI makeAbsoluteURI(String href, String base, XPathContext context, URI relativeURI) throws XPathException {
        URI resolvedURI;
        if (!relativeURI.isAbsolute()) {
            if (base == null) {
                base = ResolveURI.tryToExpand(base);
            }
            try {
                resolvedURI = ResolveURI.makeAbsolute(href, base);
            }
            catch (URISyntaxException e) {
                XPathException err = new XPathException("Cannot resolve relative URI: " + e.getMessage());
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
        } else {
            resolvedURI = relativeURI;
        }
        return resolvedURI;
    }

    protected SequenceIterator directoryContents(File directory, URIQueryParameters params, XPathContext context) {
        UnfailingErrorListener oldErrorListener;
        FilenameFilter f;
        FilenameFilter filter2 = null;
        if (params != null && (f = params.getFilenameFilter()) != null) {
            filter2 = f;
        }
        File[] files = filter2 == null ? directory.listFiles() : directory.listFiles(filter2);
        Item[] fileValues = new ObjectValue[files.length];
        for (int f2 = 0; f2 < files.length; ++f2) {
            fileValues[f2] = new ObjectValue<File>(files[f2]);
        }
        int onError2 = 1;
        if (params != null && params.getOnError() != null) {
            onError2 = params.getOnError();
        }
        Controller controller = context.getController();
        PipelineConfiguration oldPipe = context.getConfiguration().makePipelineConfiguration();
        oldPipe.setController(context.getController());
        PipelineConfiguration newPipe = new PipelineConfiguration(oldPipe);
        UnfailingErrorListener unfailingErrorListener = oldErrorListener = controller == null ? new StandardErrorListener() : controller.getErrorListener();
        if (onError2 == 3) {
            newPipe.setErrorListener(new UnfailingErrorListener(){

                public void warning(TransformerException exception) {
                }

                public void error(TransformerException exception) {
                }

                public void fatalError(TransformerException exception) {
                }
            });
        } else if (onError2 == 2) {
            newPipe.setErrorListener(new UnfailingErrorListener(){

                public void warning(TransformerException exception) {
                    oldErrorListener.warning(exception);
                }

                public void error(TransformerException exception) {
                    oldErrorListener.warning(exception);
                    XPathException supp = new XPathException("The document will be excluded from the collection");
                    supp.setLocator(exception.getLocator());
                    oldErrorListener.warning(supp);
                }

                public void fatalError(TransformerException exception) {
                    this.error(exception);
                }
            });
        }
        FileExpander expander = new FileExpander(params, newPipe);
        ArrayIterator base = new ArrayIterator(fileValues);
        return new MappingIterator<ObjectValue<File>, DocumentInfo>(base, expander);
    }

    protected SequenceIterator catalogContents(String href, String baseURI, String absURI, final XPathContext context) throws XPathException {
        boolean stable = true;
        Source source = DocumentFn.resolveURI(href, baseURI, null, context);
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(4);
        DocumentInfo catalog = context.getConfiguration().buildDocument(source, options);
        if (catalog == null) {
            XPathException err = new XPathException("Failed to load collection catalog " + absURI);
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        AxisIterator iter = catalog.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        NodeInfo top = iter.next();
        if (top == null || !"collection".equals(top.getLocalPart()) || top.getURI().length() != 0) {
            String message = top == null ? "No outermost element found in collection catalog" : (top.getURI().length() != 0 ? "Collection catalog should not use a namespace" : "Collection catalog outermost element should be <catalog> (found " + top.getLocalPart() + ">)");
            XPathException err = new XPathException(message);
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        iter.close();
        String stableAtt = top.getAttributeValue("", "stable");
        if (stableAtt != null) {
            if ("true".equals(stableAtt)) {
                stable = true;
            } else if ("false".equals(stableAtt)) {
                stable = false;
            } else {
                XPathException err = new XPathException("The 'stable' attribute of element <collection> must be true or false");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
        }
        final boolean finalStable = stable;
        AxisIterator documents = top.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        ItemMappingFunction<NodeInfo, Item> catalogueMapper = new ItemMappingFunction<NodeInfo, Item>(){

            @Override
            public Item mapItem(NodeInfo item) throws XPathException {
                String uri;
                if (!"doc".equals(item.getLocalPart()) || item.getURI().length() != 0) {
                    XPathException err = new XPathException("children of <collection> element must be <doc> elements");
                    err.setErrorCode("FODC0004");
                    err.setXPathContext(context);
                    throw err;
                }
                String href = Navigator.getAttributeValue(item, "", "href");
                if (href == null) {
                    XPathException err = new XPathException("\"<doc> element in catalog has no @href attribute\"");
                    err.setErrorCode("FODC0004");
                    err.setXPathContext(context);
                    throw err;
                }
                try {
                    uri = new URI(item.getBaseURI()).resolve(href).toString();
                }
                catch (URISyntaxException e) {
                    XPathException err = new XPathException("Invalid base URI or href URI in collection catalog: (" + item.getBaseURI() + ", " + href + ")");
                    err.setErrorCode("FODC0004");
                    err.setXPathContext(context);
                    throw err;
                }
                if (finalStable) {
                    return new AnyURIValue(uri);
                }
                return context.getConfiguration().buildDocument(new StreamSource(uri));
            }
        };
        return new ItemMappingIterator<NodeInfo, Item>(documents, catalogueMapper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FileExpander
    implements MappingFunction<ObjectValue<File>, DocumentInfo> {
        private URIQueryParameters params;
        boolean recurse = false;
        int strip = 4;
        int validation = 4;
        Boolean xinclude = null;
        boolean unparsed;
        XMLReader parser = null;
        int onError = 1;
        FilenameFilter filter = null;
        PipelineConfiguration pipe;

        public FileExpander(URIQueryParameters params, PipelineConfiguration pipe) {
            this.params = params;
            this.pipe = pipe;
            if (params != null) {
                XMLReader p;
                Integer v;
                Boolean r;
                FilenameFilter f = params.getFilenameFilter();
                if (f != null) {
                    this.filter = f;
                }
                if ((r = params.getRecurse()) != null) {
                    this.recurse = r;
                }
                if ((v = params.getValidationMode()) != null) {
                    this.validation = v;
                }
                this.xinclude = params.getXInclude();
                this.strip = params.getStripSpace();
                if (this.strip == 3) {
                    this.strip = 4;
                }
                this.unparsed = params.isUnparsed();
                Integer e = params.getOnError();
                if (e != null) {
                    this.onError = e;
                }
                if ((p = params.getXMLReader()) != null) {
                    this.parser = p;
                }
            }
        }

        @Override
        public SequenceIterator map(ObjectValue<File> item) throws XPathException {
            File file = item.getObject();
            if (file.isDirectory()) {
                if (this.recurse) {
                    File[] files = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
                    Item[] fileValues = new ObjectValue[files.length];
                    for (int f = 0; f < files.length; ++f) {
                        fileValues[f] = new ObjectValue<File>(files[f]);
                    }
                    FileExpander expander = new FileExpander(this.params, this.pipe);
                    return new MappingIterator<ObjectValue<File>, DocumentInfo>(new ArrayIterator(fileValues), expander);
                }
                return null;
            }
            if (this.unparsed) {
                try {
                    FileReader reader = new FileReader(file);
                    IntPredicate checker = this.pipe.getConfiguration().getValidCharacterChecker();
                    CharSequence content = UnparsedTextFunction.readFile(checker, reader, null);
                    String uri = file.toURI().toString();
                    TextFragmentValue doc = new TextFragmentValue(content, uri);
                    doc.setSystemId(file.toURI().toString());
                    doc.setConfiguration(this.pipe.getConfiguration());
                    return SingletonIterator.makeIterator(doc);
                }
                catch (IOException err) {
                    if (this.onError == 3) {
                        return null;
                    }
                    if (this.onError == 2) {
                        XPathException warn = new XPathException("Failed to read " + file.getPath(), err);
                        this.pipe.getErrorListener().warning(warn);
                        XPathException supp = new XPathException("The document will be excluded from the collection");
                        this.pipe.getErrorListener().warning(supp);
                        return null;
                    }
                    throw new XPathException("Failed to read " + file.getPath(), err);
                }
            }
            try {
                String escaped = file.toURI().toASCIIString();
                StreamSource source = new StreamSource(escaped);
                ParseOptions options = new ParseOptions();
                if (this.validation != 4 && this.validation != 3) {
                    options.setSchemaValidationMode(this.validation);
                }
                if (this.xinclude != null) {
                    options.setXIncludeAware(this.xinclude);
                }
                if (this.parser != null) {
                    options.setXMLReader(this.parser);
                }
                if (this.params != null) {
                    int stripSpace = this.params.getStripSpace();
                    if (stripSpace == 3) {
                        stripSpace = 4;
                    }
                    options.setStripSpace(stripSpace);
                }
                if (this.pipe.getController() != null) {
                    Builder b = this.pipe.getController().makeBuilder();
                    if (b instanceof TinyBuilder) {
                        ((TinyBuilder)b).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
                    }
                    Receiver s2 = b;
                    if (this.pipe.getController().getExecutable().stripsInputTypeAnnotations()) {
                        s2 = this.pipe.getConfiguration().getAnnotationStripper(s2);
                    }
                    s2.setPipelineConfiguration(this.pipe);
                    Sender.send(source, s2, options);
                    DocumentInfo node = (DocumentInfo)b.getCurrentRoot();
                    b.reset();
                    return SingletonIterator.makeIterator(node);
                }
                DocumentInfo doc = this.pipe.getConfiguration().buildDocument(source, options);
                return SingletonIterator.makeIterator(doc);
            }
            catch (XPathException err) {
                if (this.onError == 3) {
                    return null;
                }
                if (this.onError == 2) {
                    if (!err.hasBeenReported()) {
                        this.pipe.getErrorListener().warning(err);
                        XPathException supp = new XPathException("The document will be excluded from the collection");
                        supp.setLocator(err.getLocator());
                        this.pipe.getErrorListener().warning(supp);
                    }
                    return null;
                }
                throw err;
            }
        }
    }
}

