/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalPattern
extends Pattern {
    private Expression[] conditions;
    private Pattern[] patterns;

    public ConditionalPattern(Expression[] conditions, Pattern[] patterns) {
        this.conditions = conditions;
        this.patterns = patterns;
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            this.conditions[i2] = visitor.simplify(this.conditions[i2]);
            this.patterns[i2] = this.patterns[i2].simplify(visitor);
        }
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            this.conditions[i2] = visitor.typeCheck(this.conditions[i2], contextItemType);
            this.patterns[i2] = this.patterns[i2].analyze(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            this.conditions[i2] = this.conditions[i2].promote(offer, parent);
            this.patterns[i2].promote(offer, parent);
        }
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            found |= this.conditions[i2].replaceOperand(original, replacement);
            found |= this.patterns[i2].replaceSubExpression(original, replacement);
        }
        return found;
    }

    @Override
    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            this.patterns[i2].setOriginalText(pattern);
        }
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            nextFree = ExpressionTool.allocateSlots(this.conditions[i2], nextFree, slotManager);
            nextFree = this.patterns[i2].allocateSlots(slotManager, nextFree);
        }
        return nextFree;
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            boolean b = this.conditions[i2].effectiveBooleanValue(context);
            if (!b) continue;
            return this.patterns[i2].matches(item, context);
        }
        return false;
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        XPathContextMajor c2 = context.newContext();
        ManualIterator iter = new ManualIterator(anchor);
        c2.setCurrentIterator(iter);
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            boolean b = this.conditions[i2].effectiveBooleanValue(c2);
            if (!b) continue;
            return this.patterns[i2].matchesBeneathAnchor(node, anchor, context);
        }
        return false;
    }

    @Override
    public int getNodeKind() {
        int type = this.patterns[0].getNodeKind();
        for (int i2 = 1; i2 < this.patterns.length; ++i2) {
            int p = this.patterns[i2].getNodeKind();
            if (p == type) continue;
            return 0;
        }
        return type;
    }

    @Override
    public int getNodeKindMask() {
        int mask = this.patterns[0].getNodeKindMask();
        for (int i2 = 1; i2 < this.patterns.length; ++i2) {
            mask |= this.patterns[i2].getNodeKindMask();
        }
        return mask;
    }

    @Override
    public ItemType getItemType() {
        int nodeType = this.getNodeKind();
        if (nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(nodeType);
    }

    @Override
    public int getDependencies() {
        int d = 0;
        for (int i2 = 0; i2 < this.conditions.length; ++i2) {
            d |= this.conditions[i2].getDependencies();
            d |= this.patterns[i2].getDependencies();
        }
        return d;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(this.conditions.length * 2);
        for (int i2 = 0; i2 < this.conditions.length; i2 += 2) {
            for (Operand o : this.conditions[i2].operands()) {
                list.add(o.getExpression());
            }
            Iterator<Expression> iter = this.patterns[i2].iterateSubExpressions();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list.iterator();
    }

    @Override
    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        for (int i2 = 0; i2 < this.conditions.length; i2 += 2) {
            this.patterns[i2].setSystemId(systemId);
        }
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        for (int i2 = 0; i2 < this.conditions.length; i2 += 2) {
            this.patterns[i2].setLineNumber(lineNumber);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ConditionalPattern) {
            return Arrays.equals(this.conditions, ((ConditionalPattern)other).conditions) && Arrays.equals(this.patterns, ((ConditionalPattern)other).patterns);
        }
        return false;
    }

    public int hashCode() {
        int h2 = -2090102112;
        for (int i2 = 0; i2 < this.conditions.length; i2 += 2) {
            h2 ^= this.patterns[i2].hashCode() ^ this.conditions[i2].hashCode();
        }
        return h2;
    }
}

