/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SimpleType;

public class PullPushTee
extends PullFilter {
    private Receiver branch;
    boolean previousAtomic = false;

    public PullPushTee(PullProvider base, Receiver branch) throws XPathException {
        super(base);
        this.branch = branch;
    }

    public Receiver getReceiver() {
        return this.branch;
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.copyEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void copyEvent(int event) throws XPathException {
        PullProvider in = this.getUnderlyingProvider();
        Receiver out = this.branch;
        switch (event) {
            case 2: {
                out.startDocument(0);
                break;
            }
            case 4: {
                NamespaceBinding[] decl;
                out.startElement(new CodedName(in.getNameCode(), this.getNamePool()), in.getSchemaType(), 0, 0);
                for (NamespaceBinding aDecl : decl = in.getNamespaceDeclarations()) {
                    if (aDecl == null) break;
                    out.namespace(aDecl, 0);
                }
                AttributeCollection atts = in.getAttributes();
                for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                    out.attribute(atts.getNodeName(i2), atts.getTypeAnnotation(i2), atts.getValue(i2), 0, atts.getProperties(i2));
                }
                out.startContent();
                break;
            }
            case 8: {
                out.characters(in.getStringValue(), 0, 0);
                break;
            }
            case 9: {
                out.comment(in.getStringValue(), 0, 0);
                break;
            }
            case 10: {
                out.processingInstruction(in.getPipelineConfiguration().getConfiguration().getNamePool().getLocalName(in.getNameCode()), in.getStringValue(), 0, 0);
                break;
            }
            case 5: {
                out.endElement();
                break;
            }
            case 3: {
                List entities = in.getUnparsedEntities();
                if (entities != null) {
                    for (int i3 = 0; i3 < entities.size(); ++i3) {
                        UnparsedEntity ue = (UnparsedEntity)entities.get(i3);
                        out.setUnparsedEntity(ue.getName(), ue.getSystemId(), ue.getPublicId());
                    }
                }
                out.endDocument();
                break;
            }
            case -1: {
                in.close();
                break;
            }
            case 1: {
                if (out instanceof SequenceReceiver) {
                    ((SequenceReceiver)out).append(super.getAtomicValue(), 0, 0);
                    break;
                }
                if (this.previousAtomic) {
                    out.characters(" ", 0, 0);
                }
                CharSequence chars = in.getStringValue();
                out.characters(chars, 0, 0);
                break;
            }
            case 6: {
                if (out instanceof SequenceReceiver) {
                    Orphan o = new Orphan(in.getPipelineConfiguration().getConfiguration());
                    o.setNodeName(new CodedName(this.getNameCode(), this.getNamePool()));
                    o.setNodeKind((short)2);
                    o.setStringValue(this.getStringValue());
                    ((SequenceReceiver)out).append(o, 0, 0);
                    break;
                }
                out.attribute(new CodedName(this.getNameCode(), this.getNamePool()), (SimpleType)in.getSchemaType(), this.getStringValue(), 0, 0);
                break;
            }
            case 7: {
                if (out instanceof SequenceReceiver) {
                    Orphan o = new Orphan(in.getPipelineConfiguration().getConfiguration());
                    o.setNodeName(new CodedName(this.getNameCode(), this.getNamePool()));
                    o.setNodeKind((short)13);
                    o.setStringValue(this.getStringValue());
                    ((SequenceReceiver)out).append(o, 0, 0);
                    break;
                }
                out.namespace(this.getNamePool().getNamespaceBinding(this.getNameCode()), 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("" + event);
            }
        }
        this.previousAtomic = event == 1;
    }
}

