/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionReference;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class UnboundFunctionLibrary
implements FunctionLibrary {
    private List<UserFunctionReference> unboundFunctionReferences = new ArrayList<UserFunctionReference>(20);
    private List<StaticContext> correspondingStaticContext = new ArrayList<StaticContext>(20);
    private boolean resolving = false;

    public Expression bind(SymbolicName functionName, Expression[] arguments, StaticContext env, Container container) throws XPathException {
        if (this.resolving) {
            return null;
        }
        UserFunctionCall ufc = new UserFunctionCall();
        ufc.setFunctionName(functionName.getComponentName());
        ufc.setArguments(arguments);
        this.unboundFunctionReferences.add(ufc);
        this.correspondingStaticContext.add(env);
        return ufc;
    }

    public boolean isAvailable(SymbolicName functionName) {
        return false;
    }

    public void bindUnboundFunctionReferences(XQueryFunctionBinder lib, Configuration config) throws XPathException {
        this.resolving = true;
        for (int i2 = 0; i2 < this.unboundFunctionReferences.size(); ++i2) {
            int arity;
            UserFunctionReference ref = this.unboundFunctionReferences.get(i2);
            if (ref instanceof UserFunctionCall) {
                UserFunctionCall ufc = (UserFunctionCall)ref;
                QueryModule importingModule = (QueryModule)this.correspondingStaticContext.get(i2);
                if (importingModule == null) continue;
                this.correspondingStaticContext.set(i2, null);
                StructuredQName q = ufc.getFunctionName();
                int arity2 = ufc.getNumberOfArguments();
                XQueryFunction fd = lib.getDeclaration(q, ufc.getArguments());
                if (fd != null) {
                    fd.registerReference(ufc);
                    ufc.setStaticType(fd.getResultType());
                    importingModule.checkImportedFunctionSignature(fd);
                    continue;
                }
                String msg = "Cannot find a matching " + arity2 + "-argument function named " + q.getClarkName() + "()";
                if (!config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                    msg = msg + ". Note: external function calls have been disabled";
                } else {
                    String supplementary = XPathParser.getMissingFunctionExplanation(q, config);
                    if (supplementary != null) {
                        msg = msg + ". " + supplementary;
                    }
                }
                XPathException err = new XPathException(msg, ufc);
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            if (!(ref instanceof XQueryFunctionLibrary.UnresolvedCallable)) continue;
            XQueryFunctionLibrary.UnresolvedCallable uc = (XQueryFunctionLibrary.UnresolvedCallable)ref;
            StructuredQName q = uc.getFunctionName();
            XQueryFunction fd = lib.getDeclaration(q, new Expression[arity = uc.getArity()]);
            if (fd != null) {
                fd.registerReference(uc);
                continue;
            }
            String msg = "Cannot find a matching " + arity + "-argument function named " + q.getClarkName() + "()";
            if (!config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                msg = msg + ". Note: external function calls have been disabled";
            }
            XPathException err = new XPathException(msg);
            err.setErrorCode("XPST0017");
            err.setIsStaticError(true);
            throw err;
        }
    }

    public FunctionLibrary copy() {
        UnboundFunctionLibrary qfl = new UnboundFunctionLibrary();
        qfl.unboundFunctionReferences = new ArrayList<UserFunctionReference>(this.unboundFunctionReferences);
        qfl.correspondingStaticContext = new ArrayList<StaticContext>(this.correspondingStaticContext);
        qfl.resolving = this.resolving;
        return qfl;
    }
}

