/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntComplementPredicate;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntUnionPredicate;

public class Categories {
    private static HashMap<String, IntPredicate> CATEGORIES = null;
    public static final IntPredicate ESCAPE_s = new IntSetPredicate(IntArraySet.make(new int[]{9, 10, 13, 32}, 4));
    public static final IntPredicate ESCAPE_S = new IntComplementPredicate(ESCAPE_s);
    public static final IntPredicate ESCAPE_i = new IntPredicate(){

        public boolean matches(int value) {
            return XMLCharacterData.isNCNameStart11(value) || value == 58;
        }
    };
    public static final IntPredicate ESCAPE_I = new IntPredicate(){

        public boolean matches(int value) {
            return !XMLCharacterData.isNCNameStart11(value) && value != 58;
        }
    };
    public static final IntPredicate ESCAPE_c = new IntPredicate(){

        public boolean matches(int value) {
            return XMLCharacterData.isNCName11(value) || value == 58;
        }
    };
    public static final IntPredicate ESCAPE_C = new IntPredicate(){

        public boolean matches(int value) {
            return !XMLCharacterData.isNCName11(value) && value != 58;
        }
    };
    public static final IntPredicate ESCAPE_d = Categories.getCategory("Nd");
    public static final IntPredicate ESCAPE_D = new IntComplementPredicate(ESCAPE_d);
    static IntPredicate CATEGORY_P = Categories.getCategory("P");
    static IntPredicate CATEGORY_Z = Categories.getCategory("Z");
    static IntPredicate CATEGORY_C = Categories.getCategory("C");
    public static final IntPredicate ESCAPE_w = new IntPredicate(){

        public boolean matches(int value) {
            return !CATEGORY_P.matches(value) && !CATEGORY_Z.matches(value) && !CATEGORY_C.matches(value);
        }
    };
    public static final IntPredicate ESCAPE_W = new IntComplementPredicate(ESCAPE_w);

    static void build() {
        NodeInfo item;
        DocumentInfo doc;
        CATEGORIES = new HashMap(30);
        InputStream in = Configuration.locateResource("categories.xml", new ArrayList<String>(), new ArrayList<ClassLoader>());
        if (in == null) {
            throw new RuntimeException("Unable to read categories.xml file");
        }
        Configuration config = new Configuration();
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(4);
        try {
            doc = config.buildDocument(new StreamSource(in, "categories.xml"), options);
        }
        catch (XPathException e) {
            throw new RuntimeException("Failed to build categories.xml", e);
        }
        AxisIterator iter = doc.iterateAxis((byte)4, new NameTest(1, "", "cat", doc.getNamePool()));
        while ((item = iter.next()) != null) {
            NodeInfo r;
            String cat = Navigator.getAttributeValue(item, "", "name");
            IntRangeSet irs = new IntRangeSet();
            AxisIterator iter2 = item.iterateAxis((byte)3, NodeKindTest.ELEMENT);
            while ((r = iter2.next()) != null) {
                String from = Navigator.getAttributeValue(r, "", "f");
                String to = Navigator.getAttributeValue(r, "", "t");
                irs.addRange(Integer.parseInt(from, 16), Integer.parseInt(to, 16));
            }
            CATEGORIES.put(cat, new IntSetPredicate(irs));
        }
        String c = "CLMNPSZ";
        for (int i2 = 0; i2 < c.length(); ++i2) {
            char ch = c.charAt(i2);
            IntPredicate ip = null;
            for (Map.Entry<String, IntPredicate> entry : CATEGORIES.entrySet()) {
                if (entry.getKey().charAt(0) != ch) continue;
                ip = ip == null ? entry.getValue() : new IntUnionPredicate(ip, entry.getValue());
            }
            CATEGORIES.put(ch + "", ip);
        }
    }

    public static IntPredicate getCategory(String cat) {
        if (CATEGORIES == null) {
            Categories.build();
        }
        return CATEGORIES.get(cat);
    }
}

