/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class MetaTagAdjuster
extends ProxyReceiver {
    boolean seekingHead = true;
    int droppingMetaTags = -1;
    boolean inMetaTag = false;
    boolean foundHead = false;
    String headPrefix = null;
    NodeName metaCode;
    String requiredURI = "";
    AttributeCollectionImpl attributes;
    List<NamespaceBinding> namespaces = new ArrayList<NamespaceBinding>();
    String encoding;
    String mediaType;
    int level = 0;
    boolean isXHTML = false;

    public MetaTagAdjuster(Receiver next) {
        super(next);
    }

    public void setOutputProperties(Properties details) {
        this.encoding = details.getProperty("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.mediaType = details.getProperty("media-type");
        if (this.mediaType == null) {
            this.mediaType = "text/html";
        }
    }

    public void setIsXHTML(boolean xhtml) {
        this.isXHTML = xhtml;
        this.requiredURI = xhtml ? "http://www.w3.org/1999/xhtml" : "";
    }

    private boolean comparesEqual(String name1, String name2) {
        if (this.isXHTML) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        String localName;
        if (this.droppingMetaTags == this.level) {
            this.metaCode = nameCode;
            localName = nameCode.getLocalPart();
            if (nameCode.hasURI(this.requiredURI) && this.comparesEqual(localName, "meta")) {
                this.inMetaTag = true;
                this.attributes.clear();
                this.namespaces.clear();
                return;
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        if (this.seekingHead) {
            localName = nameCode.getLocalPart();
            if (nameCode.hasURI(this.requiredURI) && this.comparesEqual(localName, "head")) {
                this.foundHead = true;
                this.headPrefix = nameCode.getPrefix();
            }
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.inMetaTag) {
            this.attributes.addAttribute(nameCode, typeCode, value.toString(), locationId, properties);
        } else {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.inMetaTag) {
            this.namespaces.add(namespaceBinding);
        } else {
            this.nextReceiver.namespace(namespaceBinding, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.foundHead) {
            this.foundHead = false;
            NamePool namePool = this.getNamePool();
            this.nextReceiver.startContent();
            FingerprintedQName metaCode = new FingerprintedQName(this.headPrefix, this.requiredURI, "meta");
            this.nextReceiver.startElement(metaCode, Untyped.getInstance(), 0, 0);
            this.nextReceiver.attribute(new NoNamespaceName("http-equiv"), BuiltInAtomicType.UNTYPED_ATOMIC, "Content-Type", 0, 0);
            this.nextReceiver.attribute(new NoNamespaceName("content"), BuiltInAtomicType.UNTYPED_ATOMIC, this.mediaType + "; charset=" + this.encoding, 0, 0);
            this.nextReceiver.startContent();
            this.droppingMetaTags = this.level;
            this.seekingHead = false;
            this.attributes = new AttributeCollectionImpl(this.getConfiguration());
            this.nextReceiver.endElement();
        }
        if (!this.inMetaTag) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        if (this.inMetaTag) {
            Object name;
            int i2;
            this.inMetaTag = false;
            boolean found = false;
            for (i2 = 0; i2 < this.attributes.getLength(); ++i2) {
                String value;
                name = this.attributes.getLocalName(i2);
                if (!this.comparesEqual((String)name, "http-equiv") || !(value = Whitespace.trim(this.attributes.getValue(i2))).equalsIgnoreCase("Content-Type")) continue;
                found = true;
                break;
            }
            if (!found) {
                this.nextReceiver.startElement(this.metaCode, Untyped.getInstance(), 0, 0);
                for (i2 = 0; i2 < this.attributes.getLength(); ++i2) {
                    name = this.attributes.getNodeName(i2);
                    SimpleType typeCode = this.attributes.getTypeAnnotation(i2);
                    String value = this.attributes.getValue(i2);
                    int locationId = this.attributes.getLocationId(i2);
                    int properties = this.attributes.getProperties(i2);
                    this.nextReceiver.attribute((NodeName)name, typeCode, value, locationId, properties);
                }
                for (NamespaceBinding nb : this.namespaces) {
                    this.nextReceiver.namespace(nb, 0);
                }
                this.nextReceiver.startContent();
                this.nextReceiver.endElement();
            }
        } else {
            --this.level;
            if (this.droppingMetaTags == this.level + 1) {
                this.droppingMetaTags = -1;
            }
            this.nextReceiver.endElement();
        }
    }
}

