/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.NestedIntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compilation {
    public static final boolean TIMING = false;
    private CompilerInfo compilerInfo;
    private DecimalValue processorVersion;
    private StylesheetPackage stylesheetPackage;
    private PackageData packageData;
    private LocationMap locationMap = new LocationMap();
    private int errorCount = 0;
    private boolean schemaAware;
    private Map<StructuredQName, ValueAndPrecedence> staticVariables = new HashMap<StructuredQName, ValueAndPrecedence>();
    private Map<DocumentURI, DocumentInfo> stylesheetModules = new HashMap<DocumentURI, DocumentInfo>();
    private Stack<DocumentURI> importStack = new Stack();

    public Compilation(Configuration config, CompilerInfo info) {
        this.compilerInfo = info;
        this.schemaAware = info.isSchemaAware();
        this.processorVersion = info.getXsltVersion();
        PackageData pd = new PackageData(config);
        pd.setConfiguration(config);
        pd.setAllowXPath30(info.getXsltVersion().equals(DecimalValue.THREE));
        pd.setHostLanguage(50);
        pd.setSchemaAware(this.isSchemaAware());
        pd.setLocationMap(this.getLocationMap());
        this.packageData = pd;
    }

    public static PreparedStylesheet compileSingletonPackage(Configuration config, CompilerInfo compilerInfo, Source source) throws XPathException {
        Compilation compilation = new Compilation(config, compilerInfo);
        StylesheetPackage pp = compilation.compilePackage(source);
        int errs = compilation.getErrorCount();
        if (errs > 0) {
            throw new XPathException("Stylesheet compilation failed: " + errs + " error" + (errs == 1 ? "" : "s") + " reported");
        }
        PreparedStylesheet pss = new PreparedStylesheet(compilation);
        try {
            pp.getPrincipalStylesheetModule().updatePreparedStylesheet(pss);
        }
        catch (XPathException err) {
            if (!err.hasBeenReported()) {
                try {
                    compilerInfo.getErrorListener().fatalError(err);
                }
                catch (TransformerException e2) {
                    // empty catch block
                }
            }
            throw err;
        }
        errs = compilation.getErrorCount();
        if (errs > 0) {
            throw new XPathException("Stylesheet compilation failed: " + errs + " error" + (errs == 1 ? "" : "s") + " reported");
        }
        return pss;
    }

    public StylesheetPackage compilePackage(Source source) throws XPathException {
        XSLPackage xslpackage;
        block22: {
            DocumentImpl document = StylesheetModule.loadStylesheetModule(source, true, this, NestedIntegerValue.TWO);
            ElementImpl element = document.getDocumentElement();
            if (element instanceof LiteralResultElement) {
                document = ((LiteralResultElement)element).makeStylesheet(true);
                element = document.getDocumentElement();
            }
            try {
                if (element instanceof XSLPackage) {
                    LocationMap lm;
                    xslpackage = (XSLPackage)element;
                    if (element.getLocalPart().equals("package") && (lm = this.getConfiguration().getGlobalLocationMap()) != null) {
                        this.locationMap = lm;
                        this.packageData.setLocationMap(this.locationMap);
                    }
                    break block22;
                }
                throw new XPathException("Outermost element must be xsl:package, xsl:stylesheet, or xsl:transform");
            }
            catch (XPathException e) {
                if (!e.hasBeenReported()) {
                    try {
                        this.getCompilerInfo().getErrorListener().fatalError(e);
                    }
                    catch (TransformerException e1) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        CompilerInfo info = this.getCompilerInfo();
        if (this.processorVersion.equals(DecimalValue.ZERO)) {
            this.processorVersion = xslpackage.getVersion();
        }
        StyleNodeFactory factory = this.getStyleNodeFactory(true);
        StylesheetPackage pp = factory.newStylesheetPackage(xslpackage);
        pp.setVersion(xslpackage.getVersion());
        pp.setPackageVersion(xslpackage.getPackageVersion());
        pp.setPackageName(xslpackage.getName());
        pp.getRuleManager().setRecoveryPolicy(info.getRecoveryPolicy());
        this.setStylesheetPackage(pp);
        pp.createFunctionLibrary(this);
        try {
            pp.preprocess();
        }
        catch (XPathException e) {
            try {
                info.getErrorListener().fatalError(e);
            }
            catch (TransformerException e3) {
                // empty catch block
            }
            throw e;
        }
        if (this.getErrorCount() == 0) {
            try {
                pp.fixup();
            }
            catch (XPathException e) {
                this.reportError(e);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                pp.compile(this);
            }
            catch (XPathException e) {
                this.reportError(e);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                pp.complete();
            }
            catch (XPathException e) {
                this.reportError(e);
            }
        }
        return pp;
    }

    public Configuration getConfiguration() {
        return this.getPackageData().getConfiguration();
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public CompilerInfo getCompilerInfo() {
        return this.compilerInfo;
    }

    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setVersion(DecimalValue v) {
        if (v.equals(DecimalValue.THREE)) {
            this.processorVersion = v;
            this.packageData.setAllowXPath30(true);
        } else {
            this.processorVersion = DecimalValue.TWO;
            this.packageData.setAllowXPath30(false);
        }
    }

    public DecimalValue getVersion() {
        return this.processorVersion;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
        this.packageData.setSchemaAware(schemaAware);
    }

    public StyleNodeFactory getStyleNodeFactory(boolean topLevel) {
        StyleNodeFactory factory = this.getConfiguration().makeStyleNodeFactory(this);
        factory.setTopLevelModule(topLevel);
        return factory;
    }

    private void setStylesheetPackage(StylesheetPackage module) {
        this.stylesheetPackage = module;
    }

    public StylesheetPackage getStylesheetPackage() {
        return this.stylesheetPackage;
    }

    public void reportError(XPathException err) {
        ErrorListener el = this.compilerInfo.getErrorListener();
        if (el == null) {
            el = this.getConfiguration().getErrorListener();
        }
        if (!err.hasBeenReported()) {
            ++this.errorCount;
            try {
                el.fatalError(err);
                err.setHasBeenReported(true);
            }
            catch (Exception exception) {}
        } else if (this.errorCount == 0) {
            ++this.errorCount;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(XPathException err) {
        ErrorListener el = this.compilerInfo.getErrorListener();
        if (el == null) {
            el = this.getConfiguration().getErrorListener();
        }
        if (el != null) {
            try {
                el.warning(err);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void declareStaticVariable(StructuredQName name, GroundedValue value, NestedIntegerValue precedence) throws XPathException {
        ValueAndPrecedence vp = this.staticVariables.get(name);
        if (vp != null) {
            if (vp.precedence.compareTo(precedence) < 0) {
                if (!this.valuesAreCompatible(value, vp.value)) {
                    throw new XPathException("Incompatible values assigned for static variable " + name.getDisplayName(), "XTSE3450");
                }
            } else {
                return;
            }
        }
        this.staticVariables.put(name, new ValueAndPrecedence(value, precedence));
    }

    private boolean valuesAreCompatible(GroundedValue val0, GroundedValue val1) {
        if (val0.getLength() != val1.getLength()) {
            return false;
        }
        if (val0.getLength() == 1) {
            Item i0 = val0.head();
            Item i1 = val1.head();
            if (i0 instanceof AtomicValue) {
                return i1 instanceof AtomicValue && ((AtomicValue)i0).isIdentical((AtomicValue)i1);
            }
            if (i0 instanceof NodeInfo) {
                return i1 instanceof NodeInfo && ((NodeInfo)i0).isSameNodeInfo((NodeInfo)i1);
            }
            return i0 == i1;
        }
        for (int i2 = 0; i2 < val0.getLength(); ++i2) {
            if (this.valuesAreCompatible((GroundedValue)((Object)val0.itemAt(i2)), (GroundedValue)((Object)val1.itemAt(i2)))) continue;
            return false;
        }
        return true;
    }

    public GroundedValue getStaticVariable(StructuredQName name) {
        ValueAndPrecedence vp = this.staticVariables.get(name);
        return vp == null ? null : vp.value;
    }

    public Map<DocumentURI, DocumentInfo> getStylesheetModules() {
        return this.stylesheetModules;
    }

    public Stack<DocumentURI> getImportStack() {
        return this.importStack;
    }

    private static class ValueAndPrecedence {
        public GroundedValue value;
        public NestedIntegerValue precedence;

        public ValueAndPrecedence(GroundedValue v, NestedIntegerValue p) {
            this.value = v;
            this.precedence = p;
        }
    }
}

