/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UseAttributeSets;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceType;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private NodeName[] attributeNames;
    private Expression[] attributeValues;
    private Expression onEmpty;
    private int numberOfAttributes;
    private boolean toplevel;
    private List<NamespaceBinding> namespaceCodes = new ArrayList<NamespaceBinding>();
    private AttributeSet[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;
    private boolean inheritNamespaces = true;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int num = atts.getLength();
        if (num == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new NodeName[num];
            this.attributeValues = new Expression[num];
            this.numberOfAttributes = 0;
            for (int i2 = 0; i2 < num; ++i2) {
                Expression exp;
                int anameCode = atts.getNameCode(i2);
                short attURIcode = namePool.getURICode(anameCode);
                if (attURIcode == 2) {
                    int fp = anameCode & 0xFFFFF;
                    if (fp == 235 || fp == 228 || fp == 231 || fp == 229 || fp == 230 || fp == 238 || fp == 239 || fp == 234 || fp == 236 || fp == 237) continue;
                    if (fp == 232) {
                        this.inheritNamespaces = this.processBooleanAttribute("xsl:inherit-namespaces", atts.getValue(i2));
                        continue;
                    }
                    if (fp == 233) {
                        if (!this.isXslt30Processor()) {
                            this.compileError("The 'xsl:on-empty' attribute requires XSLT 3.0");
                        }
                        this.onEmpty = this.makeExpression(atts.getValue(i2));
                        continue;
                    }
                    this.compileError("Unknown XSL attribute " + namePool.getDisplayName(anameCode), "XTSE0805");
                    continue;
                }
                this.attributeNames[this.numberOfAttributes] = new FingerprintedQName(atts.getPrefix(i2), atts.getURI(i2), atts.getLocalName(i2), anameCode);
                this.attributeValues[this.numberOfAttributes] = exp = this.makeAttributeValueTemplate(atts.getValue(i2));
                ++this.numberOfAttributes;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                NodeName[] attributeNames2 = new NodeName[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, attributeNames2, 0, this.numberOfAttributes);
                this.attributeNames = attributeNames2;
                Expression[] attributeValues2 = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, attributeValues2, 0, this.numberOfAttributes);
                this.attributeValues = attributeValues2;
            }
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.toplevel = this.getParent() instanceof XSLStylesheet;
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        String elementURI = namePool.getURI(this.resultNameCode);
        if (this.toplevel) {
            if (elementURI.length() == 0) {
                this.compileError("Top level elements must have a non-null namespace URI", "XTSE0130");
            }
        } else {
            String validate;
            String useAttSets;
            Iterator<NamespaceBinding> inscope = NamespaceIterator.iterateNamespaces(this);
            while (inscope.hasNext()) {
                this.namespaceCodes.add(inscope.next());
            }
            StylesheetPackage sheet = this.getContainingPackage();
            if (sheet.hasNamespaceAliases()) {
                for (int i2 = 0; i2 < this.namespaceCodes.size(); ++i2) {
                    String suri = this.namespaceCodes.get(i2).getURI();
                    NamespaceBinding ncode = sheet.getNamespaceAlias(suri);
                    if (ncode == null || ncode.getURI().equals(suri)) continue;
                    this.namespaceCodes.set(i2, ncode);
                }
                NamespaceBinding elementAlias = sheet.getNamespaceAlias(elementURI);
                if (elementAlias != null && !elementAlias.getURI().equals(elementURI)) {
                    this.resultNameCode = namePool.allocate(elementAlias.getPrefix(), elementAlias.getURI(), this.getLocalPart());
                }
            }
            if (this.onEmpty != null) {
                RoleLocator role = new RoleLocator(4, "LRE/xsl:on-empty", 0);
                role.setErrorCode("XTTE3310");
                this.onEmpty = TypeChecker.staticTypeCheck(this.onEmpty, SequenceType.OPTIONAL_ELEMENT_NODE, false, role, this.makeExpressionVisitor());
            }
            if ((useAttSets = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "use-attribute-sets")) != null) {
                this.attributeSets = this.getAttributeSets(useAttSets, null);
            }
            this.validation = this.getDefaultValidation();
            String type = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "type");
            if (type != null) {
                if (!this.isSchemaAware()) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
                }
                this.schemaType = this.getSchemaType(type);
                this.validation = 8;
            }
            if ((validate = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "validation")) != null) {
                this.validation = this.validateValidationAttribute(validate);
                if (this.schemaType != null) {
                    this.compileError("The attributes xsl:type and xsl:validation are mutually exclusive", "XTSE1505");
                }
            }
            if (this.numberOfAttributes > 0) {
                for (int i3 = 0; i3 < this.numberOfAttributes; ++i3) {
                    NamespaceBinding newBinding;
                    NodeName anameCode;
                    NodeName alias = anameCode = this.attributeNames[i3];
                    String attURI = anameCode.getURI();
                    if (attURI.length() != 0 && (newBinding = sheet.getNamespaceAlias(attURI)) != null && !newBinding.getURI().equals(attURI)) {
                        alias = new FingerprintedQName(newBinding.getPrefix(), newBinding.getURI(), this.getAttributeList().getLocalName(i3));
                    }
                    this.attributeNames[i3] = alias;
                    this.attributeValues[i3] = this.typeCheck(alias.getDisplayName(), this.attributeValues[i3]);
                }
            }
            for (int n = this.namespaceCodes.size() - 1; n >= 0; --n) {
                String uri = this.namespaceCodes.get(n).getURI();
                if (!this.isExcludedNamespace(uri) || sheet.isAliasResultNamespace(uri)) continue;
                this.namespaceCodes.remove(n);
            }
        }
    }

    protected void validateChildren(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        if (!this.toplevel) {
            super.validateChildren(decl, excludeStylesheet);
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.toplevel) {
            return null;
        }
        NamespaceBinding[] bindings = this.namespaceCodes.toArray(new NamespaceBinding[this.namespaceCodes.size()]);
        FixedElement inst = new FixedElement(new CodedName(this.resultNameCode, this.getNamePool()), bindings, this.inheritNamespaces, true, this.schemaType, this.validation);
        inst.setBaseURI(this.getBaseURI());
        if (this.onEmpty != null) {
            inst.setOnEmpty(new CopyOf(this.onEmpty, true, this.validation, this.schemaType, false));
        }
        Expression content = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (this.numberOfAttributes > 0) {
            for (int i2 = this.attributeNames.length - 1; i2 >= 0; --i2) {
                FixedAttribute att = new FixedAttribute(this.attributeNames[i2], 4, null);
                att.setSelect(this.attributeValues[i2], exec.getConfiguration());
                att.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                Instruction exp = att;
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceExpression trace = new TraceExpression(exp);
                    trace.setNamespaceResolver(this.getNamespaceResolver());
                    trace.setConstructType(2007);
                    trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    trace.setObjectName(this.attributeNames[i2].getStructuredQName());
                    exp = trace;
                }
                if (content == null) {
                    content = exp;
                    continue;
                }
                content = Block.makeBlock(exp, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence(this);
        }
        inst.setContentExpression(content);
        return inst;
    }

    public DocumentImpl makeStylesheet(boolean topLevel) throws XPathException {
        StyleNodeFactory nodeFactory = this.getCompilation().getStyleNodeFactory(topLevel);
        if (!this.isInScopeNamespace("http://www.w3.org/1999/XSL/Transform")) {
            String message = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? (!this.isInScopeNamespace("http://www.w3.org/TR/WD-xsl") ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            XPathException err = new XPathException(message);
            err.setLocator(this);
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            this.compileError(err);
            throw err;
        }
        String version = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "version");
        if (version == null) {
            XPathException err = new XPathException("Simplified stylesheet: xsl:version attribute is missing");
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            err.setLocator(this);
            this.compileError(err);
            throw err;
        }
        try {
            DocumentImpl oldRoot = (DocumentImpl)this.getDocumentRoot();
            LinkedTreeBuilder builder = new LinkedTreeBuilder(this.getConfiguration().makePipelineConfiguration());
            builder.setNodeFactory(nodeFactory);
            builder.setSystemId(this.getSystemId());
            builder.open();
            builder.startDocument(0);
            int st = 199;
            builder.startElement(new CodedName(st, this.getNamePool()), Untyped.getInstance(), 0, 0);
            builder.namespace(new NamespaceBinding("xsl", "http://www.w3.org/1999/XSL/Transform"), 0);
            builder.attribute(new NoNamespaceName("version"), BuiltInAtomicType.UNTYPED_ATOMIC, version, 0, 0);
            builder.startContent();
            int te = 200;
            builder.startElement(new CodedName(te, this.getNamePool()), Untyped.getInstance(), 0, 0);
            builder.attribute(new NoNamespaceName("match"), BuiltInAtomicType.UNTYPED_ATOMIC, "/", 0, 0);
            builder.startContent();
            builder.graftElement(this);
            builder.endElement();
            builder.endElement();
            builder.endDocument();
            builder.close();
            DocumentImpl newRoot = (DocumentImpl)builder.getCurrentRoot();
            newRoot.graftLocationMap(oldRoot);
            return newRoot;
        }
        catch (XPathException err) {
            err.setLocator(this);
            throw err;
        }
    }

    public int getConstructType() {
        return 2006;
    }

    public StructuredQName getObjectName() {
        return new StructuredQName(this.getPrefix(), this.getURI(), this.getLocalPart());
    }

    public Object getProperty(String name) {
        if (name.equals("name")) {
            return this.getDisplayName();
        }
        return null;
    }
}

