/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.Whitespace;

public class XSLAttributeSet
extends StyleElement
implements StylesheetComponent {
    private String nameAtt;
    private String useAtt;
    private String visibilityAtt;
    private SlotManager stackFrameMap;
    private List<ComponentDeclaration> attributeSetElements = null;
    private AttributeSet[] useAttributeSets = null;
    private AttributeSet procedure = new AttributeSet();
    private int referenceCount = 0;
    private boolean validated = false;
    private Visibility visibility;
    private boolean streamable = false;

    public AttributeSet getCompiledProcedure() {
        return this.procedure;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(136, this.getObjectName());
    }

    public void checkCompatibility(Component component) throws XPathException {
    }

    public void setCompilation(Compilation compilation) {
        super.setCompilation(compilation);
        this.procedure.setPackageData(compilation.getPackageData());
    }

    public boolean isDeclaration() {
        return true;
    }

    public StructuredQName getAttributeSetName() {
        return this.getObjectName();
    }

    public AttributeSet getInstruction() {
        return this.procedure;
    }

    public boolean isDeclaredStreamable() {
        return this.streamable;
    }

    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void prepareAttributes() throws XPathException {
        this.useAtt = null;
        String streamableAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-attribute-sets")) {
                this.useAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("streamable")) {
                streamableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("visibility")) {
                this.visibilityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
            return;
        }
        if (this.visibilityAtt == null) {
            this.visibility = Visibility.PRIVATE;
        } else if (!this.isXslt30Processor()) {
            this.compileError("The xsl:attribute-set/@visibility attribute requires XSLT 3.0 to be enabled", "XTSE0020");
        } else {
            this.visibility = this.getVisibilityValue(this.visibilityAtt, "");
        }
        if (streamableAtt != null) {
            this.streamable = this.processBooleanAttribute("streamable", streamableAtt);
            if (this.streamable && !this.getConfiguration().isLicensedFeature(2)) {
                this.issueWarning("Request for streaming ignored: this Saxon configuration does not support streaming", this);
                this.streamable = false;
            }
        }
        try {
            this.setObjectName(this.makeQName(this.nameAtt));
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), err.getErrorCodeQName());
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
        }
    }

    public StructuredQName getObjectName() {
        StructuredQName o = super.getObjectName();
        if (o == null) {
            try {
                this.prepareAttributes();
                o = this.getObjectName();
            }
            catch (XPathException err) {
                o = new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-attribute-set");
                this.setObjectName(o);
            }
        }
        return o;
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        if (this.validated) {
            return;
        }
        this.checkTopLevel("XTSE0010", true);
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (!(child instanceof XSLAttribute)) {
                this.compileError("Only xsl:attribute is allowed within xsl:attribute-set", "XTSE0010");
                continue;
            }
            if (this.visibility != Visibility.ABSTRACT) continue;
            this.compileError("An abstract attribute-set must contain no xsl:attribute instructions");
        }
        if (this.useAtt != null) {
            if (this.visibility == Visibility.ABSTRACT) {
                this.compileError("An abstract attribute-set must have no @use-attribute-sets attribute");
            }
            this.attributeSetElements = new ArrayList<ComponentDeclaration>(5);
            this.useAttributeSets = this.getAttributeSets(this.useAtt, this.attributeSetElements);
            for (ComponentDeclaration attributeSetElement : this.attributeSetElements) {
                ((XSLAttributeSet)attributeSetElement.getSourceElement()).checkCircularity(this);
            }
            if (this.streamable) {
                for (ComponentDeclaration attributeSetElement : this.attributeSetElements) {
                    if (((XSLAttributeSet)attributeSetElement.getSourceElement()).streamable) continue;
                    this.compileError("Attribute set is declared streamable, but references an attribute set that is not declared streamable", "XTSE0730");
                }
            }
        }
        this.validated = true;
    }

    public void index(ComponentDeclaration decl, StylesheetPackage top) throws XPathException {
        top.indexAttributeSet(decl);
    }

    public void checkCircularity(XSLAttributeSet origin) throws XPathException {
        if (this == origin) {
            this.compileError("The definition of the attribute set is circular", "XTSE0720");
            this.useAttributeSets = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.attributeSetElements != null) {
                for (ComponentDeclaration attributeSetElement : this.attributeSetElements) {
                    XSLAttributeSet element = (XSLAttributeSet)attributeSetElement.getSourceElement();
                    element.checkCircularity(origin);
                    if (!this.streamable || element.streamable) continue;
                    this.compileError("Attribute-set is declared streamable but references a non-streamable attribute set " + element.getAttributeSetName().getDisplayName(), "XTSE3430");
                }
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        if (this.referenceCount > 0) {
            Expression body2 = this.compileSequenceConstructor(compilation, decl, this.iterateAxis((byte)3), true);
            if (body2 == null) {
                body2 = Literal.makeEmptySequence(this);
            }
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                body2 = visitor.simplify(body2);
                if (this.getConfiguration().isCompileWithTracing()) {
                    body2 = XSLAttributeSet.makeTraceInstruction(this, body2);
                }
                this.procedure.setUseAttributeSets(this.useAttributeSets);
                this.procedure.setName(this.getObjectName());
                this.procedure.setBody(body2);
                this.procedure.setSystemId(this.getSystemId());
                this.procedure.setLineNumber(this.getLineNumber());
                this.procedure.setDeclaredStreamable(this.streamable);
                Expression exp2 = body2.optimize(visitor, new ContextItemStaticInfo(AnyItemType.getInstance(), true));
                if (body2 != exp2) {
                    this.procedure.setBody(exp2);
                    body2 = exp2;
                }
                super.allocateSlots(body2);
                this.procedure.setStackFrameMap(this.stackFrameMap);
                this.checkStreamability();
            }
            catch (XPathException e) {
                this.compileError(e);
            }
        } else {
            this.procedure.setBody(Literal.makeEmptySequence(this));
        }
    }

    public void optimize(ComponentDeclaration declaration) throws XPathException {
    }

    public int getConstructType() {
        return 136;
    }

    public void generateByteCode(Optimizer opt) {
    }

    private void checkStreamability() throws XPathException {
    }
}

