/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.UseAttributeSets;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private AttributeSet[] attributeSets = null;
    private int validation;
    private SchemaType schemaType = null;
    private boolean inheritNamespaces = true;
    private Expression onEmpty;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        String namespaceAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String inheritAtt = null;
        String onEmptyAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("namespace")) {
                namespaceAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("inherit-namespaces")) {
                inheritAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-attribute-sets")) {
                this.use = atts.getValue(a);
                continue;
            }
            if (f.equals("on-empty")) {
                onEmptyAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(nameAtt);
            if (this.elementName instanceof StringLiteral && !NameChecker.isQName(((StringLiteral)this.elementName).getStringValue())) {
                this.compileError("Element name " + Err.wrap(((StringLiteral)this.elementName).getStringValue(), 1) + " is not a valid QName", "XTDE0820");
                this.elementName = new StringLiteral("saxon-error-element", (Container)this);
            }
        }
        if (namespaceAtt != null) {
            this.namespace = this.makeAttributeValueTemplate(namespaceAtt);
            if (this.namespace instanceof StringLiteral && !StandardURIChecker.getInstance().isValidURI(((StringLiteral)this.namespace).getStringValue())) {
                this.compileError("The value of the namespace attribute must be a valid URI", "XTDE0835");
            }
        }
        this.validation = validationAtt != null ? this.validateValidationAttribute(validationAtt) : this.getDefaultValidation();
        if (typeAtt != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validation = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (inheritAtt != null) {
            this.inheritNamespaces = this.processBooleanAttribute("inherit-namespaces", inheritAtt);
        }
        if (onEmptyAtt != null) {
            if (!this.isXslt30Processor()) {
                this.compileError("The 'on-empty' attribute requires XSLT 3.0");
            }
            this.onEmpty = this.makeExpression(onEmptyAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        if (this.onEmpty != null) {
            RoleLocator role = new RoleLocator(4, "xsl:element/on-empty", 0);
            role.setErrorCode("XTTE3310");
            this.onEmpty = TypeChecker.staticTypeCheck(this.onEmpty, SequenceType.OPTIONAL_ELEMENT_NODE, false, role, this.makeExpressionVisitor());
        }
        this.elementName = this.typeCheck("name", this.elementName);
        this.namespace = this.typeCheck("namespace", this.namespace);
        this.onEmpty = this.typeCheck("on-empty", this.onEmpty);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        SavedNamespaceContext nsContext = null;
        if (this.elementName instanceof StringLiteral) {
            String[] parts;
            String qName = ((StringLiteral)this.elementName).getStringValue();
            try {
                parts = NameChecker.getQNameParts(qName);
            }
            catch (QNameException e) {
                this.compileError("Invalid element name: " + qName, "XTDE0820");
                return null;
            }
            String nsuri = null;
            if (this.namespace instanceof StringLiteral) {
                nsuri = ((StringLiteral)this.namespace).getStringValue();
                if (nsuri.length() == 0) {
                    parts[0] = "";
                }
            } else if (this.namespace == null && (nsuri = this.getURIForPrefix(parts[0], true)) == null) {
                this.undeclaredNamespaceError(parts[0], "XTDE0830");
            }
            if (nsuri != null) {
                FingerprintedQName qn = new FingerprintedQName(parts[0], nsuri, parts[1]);
                qn.allocateNameCode(this.getNamePool());
                FixedElement inst = new FixedElement(qn, NamespaceBinding.EMPTY_ARRAY, this.inheritNamespaces, true, this.schemaType, this.validation);
                if (this.onEmpty != null) {
                    inst.setOnEmpty(new CopyOf(this.onEmpty, true, this.validation, this.schemaType, false));
                }
                inst.setBaseURI(this.getBaseURI());
                return this.compileContentExpression(exec, decl, inst);
            }
        } else if (this.namespace == null) {
            nsContext = this.makeNamespaceContext();
        }
        ComputedElement inst = new ComputedElement(this.elementName, this.namespace, nsContext, this.schemaType, this.validation, this.inheritNamespaces, false);
        if (this.onEmpty != null) {
            inst.setOnEmpty(new CopyOf(this.onEmpty, true, this.validation, this.schemaType, false));
        }
        return this.compileContentExpression(exec, decl, inst);
    }

    private Expression compileContentExpression(Compilation exec, ComponentDeclaration decl, ElementCreator inst) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence(this);
        }
        inst.setContentExpression(content);
        return inst;
    }
}

