/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLFunction
extends StyleElement
implements StylesheetComponent {
    private String nameAtt = null;
    private String asAtt = null;
    private SequenceType resultType;
    private String functionName;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private String overrideExtensionFunctionAtt = null;
    private boolean overrideExtensionFunction = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    private Visibility visibility;

    public UserFunction getCompiledProcedure() {
        return this.compiledFunction;
    }

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        this.overrideExtensionFunctionAtt = null;
        String visibilityAtt = null;
        String cacheAtt = null;
        String identitySensitiveAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String uri = atts.getURI(a);
            String local = atts.getLocalName(a);
            if ("".equals(uri)) {
                if (local.equals("name")) {
                    this.nameAtt = Whitespace.trim(atts.getValue(a));
                    assert (this.nameAtt != null);
                    if (this.nameAtt.indexOf(58) < 0) {
                        this.compileError("Function name must have a namespace prefix", "XTSE0740");
                    }
                    try {
                        this.setObjectName(this.makeQName(this.nameAtt));
                    }
                    catch (NamespaceException err) {
                        this.compileError(err.getMessage(), "XTSE0280");
                    }
                    catch (XPathException err) {
                        this.compileError(err);
                    }
                    continue;
                }
                if (local.equals("as")) {
                    this.asAtt = atts.getValue(a);
                    continue;
                }
                if (local.equals("visibility")) {
                    visibilityAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                if (local.equals("override")) {
                    String overrideAtt = Whitespace.trim(atts.getValue(a));
                    boolean override = this.processBooleanAttribute("override", overrideAtt);
                    if (this.overrideExtensionFunctionAtt != null) {
                        if (override != this.overrideExtensionFunction) {
                            this.compileError("Attributes override-extension-function and override are both used, but do not match", "XTSE0020");
                        }
                    } else {
                        this.overrideExtensionFunctionAtt = overrideAtt;
                        this.overrideExtensionFunction = override;
                    }
                    if (!this.isXslt30Processor()) continue;
                    this.compileWarning("The xsl:function/@override attribute is deprecated; use override-extension-function", "SXWN9014");
                    continue;
                }
                if (local.equals("override-extension-function") && this.isXslt30Processor()) {
                    String overrideExtAtt = Whitespace.trim(atts.getValue(a));
                    boolean overrideExt = this.processBooleanAttribute("override-extension-function", overrideExtAtt);
                    if (this.overrideExtensionFunctionAtt != null) {
                        if (overrideExt != this.overrideExtensionFunction) {
                            this.compileError("Attributes override-extension-function and override are both used, but do not match", "XTSE0020");
                        }
                    } else {
                        this.overrideExtensionFunctionAtt = overrideExtAtt;
                        this.overrideExtensionFunction = overrideExt;
                    }
                    if (!local.equals("override")) continue;
                    this.compileWarning("The xsl:function/@override attribute is deprecated; use override-extension-function", "SXWN9014");
                    continue;
                }
                if (local.equals("cache")) {
                    cacheAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                if (local.equals("identity-sensitive")) {
                    identitySensitiveAtt = Whitespace.trim(atts.getValue(a));
                    continue;
                }
                this.checkUnknownAttribute(atts.getNodeName(a));
                continue;
            }
            if (local.equals("memo-function") && uri.equals("http://saxon.sf.net/")) {
                this.memoFunction = this.processBooleanAttribute("saxon:memo-function", atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.nameAtt = "xsl:unnamed-function-" + this.generateId();
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        if (visibilityAtt == null) {
            this.visibility = Visibility.PRIVATE;
        } else if (!this.isXslt30Processor()) {
            this.compileError("The xsl:function/@visibility attribute requires XSLT 3.0 to be enabled", "XTSE0020");
        } else {
            this.visibility = this.getVisibilityValue(visibilityAtt, "");
        }
        boolean identitySensitive = true;
        if (identitySensitiveAtt != null) {
            identitySensitive = this.processBooleanAttribute("identity-sensitive", identitySensitiveAtt);
        }
        boolean cache = false;
        if (cacheAtt != null) {
            if ("full".equals(cacheAtt)) {
                cache = true;
            } else if ("partial".equals(cacheAtt)) {
                cache = true;
            } else if ("no".equals(cacheAtt)) {
                cache = false;
            } else {
                this.invalidAttribute("cache", "full|partial|no");
            }
        }
        if (cache && !identitySensitive) {
            this.memoFunction = true;
        }
        this.functionName = this.nameAtt;
    }

    private String generateId() {
        FastStringBuffer buff = new FastStringBuffer(16);
        this.generateId(buff);
        return buff.toString();
    }

    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            this.nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (this.nameAtt == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            try {
                qn = this.makeQName(this.nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
        }
        return qn;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam(String attName) {
        return !"required".equals(attName);
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam;
    }

    public Visibility getVisibility() {
        if (this.visibility == null) {
            try {
                String vAtt = this.getAttributeValue("", "visibility");
                return vAtt == null ? Visibility.PRIVATE : this.getVisibilityValue(Whitespace.trim(vAtt), "");
            }
            catch (XPathException e) {
                return Visibility.PRIVATE;
            }
        }
        return this.visibility;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(155, this.getObjectName(), this.getNumberOfArguments());
    }

    public void checkCompatibility(Component component) throws XPathException {
        if (this.compiledFunction == null) {
            this.getCompiledFunction();
        }
        UserFunction other = (UserFunction)component.getProcedure();
        if (!this.compiledFunction.getSymbolicName().equals(other.getSymbolicName())) {
            this.compileError("The overriding xsl:function " + this.nameAtt + " does not match the overridden function: " + "the function name/arity does not match", "XTSE3070");
        }
        if (!this.compiledFunction.getResultType().equals(other.getResultType())) {
            this.compileError("The overriding xsl:function " + this.nameAtt + " does not match the overridden function: " + "the return type does not match", "XTSE3070");
        }
        for (int i2 = 0; i2 < this.getNumberOfArguments(); ++i2) {
            if (this.compiledFunction.getArgumentType(i2).equals(other.getArgumentType(i2))) continue;
            this.compileError("The overriding xsl:function " + this.nameAtt + " does not match the overridden function: " + "the type of the " + RoleLocator.ordinal(i2 + 1) + " argument does not match", "XTSE3070");
        }
    }

    public boolean isOverrideExtensionFunction() {
        if (this.overrideExtensionFunctionAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.overrideExtensionFunction;
    }

    public void index(ComponentDeclaration decl, StylesheetPackage top) throws XPathException {
        this.getCompiledFunction();
        top.indexFunction(decl);
    }

    public void fixupReferences() throws XPathException {
        super.fixupReferences();
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010", true);
        this.getNumberOfArguments();
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        this.compileAsExpression(compilation, decl);
    }

    private void compileAsExpression(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        Expression exp = this.compileSequenceConstructor(compilation, decl, this.iterateAxis((byte)3), false);
        if (exp == null) {
            exp = Literal.makeEmptySequence(this);
        } else if (!Literal.isEmptySequence(exp)) {
            if (this.visibility == Visibility.ABSTRACT) {
                this.compileError("A function defined with visibility='abstract' must have no body", "XTSE0010");
            }
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            exp = exp.simplify(visitor);
        }
        if (compilation.getConfiguration().isCompileWithTracing()) {
            TraceExpression trace = new TraceExpression(exp);
            trace.setConstructType(155);
            trace.setNamespaceResolver(this.getNamespaceResolver());
            trace.setObjectName(this.getObjectName());
            exp = trace;
        }
        UserFunction fn = this.getCompiledFunction();
        fn.setBody(exp);
        fn.setStackFrameMap(this.stackFrameMap);
        this.bindParameterDefinitions(fn);
        if (this.memoFunction && !fn.isMemoFunction()) {
            this.compileWarning("Memo functions are not available in Saxon-HE: saxon:memo-function attribute ignored", "SXWN9011");
        }
    }

    public void typeCheckBody() throws XPathException {
        if (this.visibility != Visibility.ABSTRACT) {
            Expression exp = this.compiledFunction.getBody();
            ExpressionTool.resetPropertiesWithinSubtree(exp);
            Expression exp2 = exp;
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            try {
                ContextItemStaticInfo info = ContextItemStaticInfo.ABSENT;
                exp2 = visitor.typeCheck(exp, info);
                if (this.resultType != null) {
                    RoleLocator role = new RoleLocator(5, this.functionName, 0);
                    role.setErrorCode("XTTE0780");
                    exp2 = TypeChecker.staticTypeCheck(exp2, this.resultType, false, role, visitor);
                }
            }
            catch (XPathException err) {
                err.maybeSetLocation(this);
                this.compileError(err);
            }
            if (exp2 != exp) {
                this.compiledFunction.setBody(exp2);
            }
        }
    }

    public void optimize(ComponentDeclaration declaration) throws XPathException {
        int tailCalls;
        Expression exp3;
        Expression exp = this.compiledFunction.getBody();
        ExpressionTool.resetPropertiesWithinSubtree(exp);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        Expression exp2 = exp;
        Optimizer opt = this.getConfiguration().obtainOptimizer();
        try {
            if (opt.getOptimizationLevel() != 0) {
                exp2 = exp.optimize(visitor, null);
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            this.compileError(err);
        }
        if (opt.getOptimizationLevel() != 0 && (exp3 = opt.promoteExpressionsToGlobal(exp2, this.getCompilation().getStylesheetPackage(), visitor)) != null) {
            exp2 = visitor.optimize(exp3, null);
        }
        exp2 = XSLFunction.makeTraceInstruction(this, exp2);
        this.allocateSlots(exp2);
        if (exp2 != exp) {
            this.compiledFunction.setBody(exp2);
        }
        if ((tailCalls = ExpressionTool.markTailFunctionCalls(exp2, this.getObjectName(), this.getNumberOfArguments())) != 0) {
            this.compiledFunction.setTailRecursive(tailCalls > 0, tailCalls > 1);
            this.compiledFunction.setBody(new TailCallLoop(this.compiledFunction));
        }
        this.compiledFunction.computeEvaluationMode();
        if (this.isExplaining()) {
            exp2.explain(this.getConfiguration().getLogger());
        }
    }

    public void generateByteCode(Optimizer opt) throws XPathException {
        if (this.getCompilation().getCompilerInfo().isGenerateByteCode()) {
            try {
                Expression cbody = opt.compileToByteCode(this.compiledFunction.getBody(), this.nameAtt, 6);
                if (cbody != null) {
                    this.compiledFunction.setBody(cbody);
                }
            }
            catch (Exception e) {
                System.err.println("Failed while compiling function " + this.nameAtt);
                e.printStackTrace();
                throw new XPathException(e);
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public SequenceType getResultType() {
        String asAtt;
        if (this.resultType == null && (asAtt = this.getAttributeValue("", "as")) != null) {
            try {
                this.resultType = this.makeSequenceType(asAtt);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.resultType == null ? SequenceType.ANY_SEQUENCE : this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            NodeInfo child;
            this.numberOfArguments = 0;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = kids.next()) instanceof XSLLocalParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public void setParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = new UserFunctionParameter[this.getNumberOfArguments()];
        fn.setParameterDefinitions(params);
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while (true) {
            NodeInfo node;
            if ((node = kids.next()) == null) {
                return;
            }
            if (!(node instanceof XSLLocalParam)) break;
            UserFunctionParameter param = new UserFunctionParameter();
            params[count++] = param;
            param.setRequiredType(((XSLLocalParam)node).getRequiredType());
            param.setVariableQName(((XSLLocalParam)node).getVariableQName());
            param.setSlotNumber(((XSLLocalParam)node).getSlotNumber());
        }
    }

    public void bindParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = fn.getParameterDefinitions();
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo node;
        while ((node = kids.next()) != null) {
            if (!(node instanceof XSLLocalParam)) continue;
            UserFunctionParameter param = params[count++];
            param.setRequiredType(((XSLLocalParam)node).getRequiredType());
            param.setVariableQName(((XSLLocalParam)node).getVariableQName());
            param.setSlotNumber(((XSLLocalParam)node).getSlotNumber());
            ((XSLLocalParam)node).getSourceBinding().fixupBinding(param);
            int refs = ExpressionTool.getReferenceCount(fn.getBody(), param, false);
            param.setReferenceCount(refs);
        }
        return;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] types = new SequenceType[this.getNumberOfArguments()];
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo node;
        while ((node = kids.next()) != null) {
            if (!(node instanceof XSLLocalParam)) continue;
            types[count++] = ((XSLLocalParam)node).getRequiredType();
        }
        return types;
    }

    public UserFunction getCompiledFunction() {
        if (this.compiledFunction == null) {
            try {
                this.prepareAttributes();
                UserFunction fn = this.getConfiguration().newUserFunction(this.memoFunction);
                fn.setPackageData(this.getCompilation().getPackageData());
                fn.setHostLanguage(50);
                fn.setFunctionName(this.getObjectName());
                this.setParameterDefinitions(fn);
                fn.setResultType(this.getResultType());
                fn.setLineNumber(this.getLineNumber());
                fn.setSystemId(this.getSystemId());
                fn.makeDeclaringComponent(this.visibility, this.getContainingPackage());
                this.compiledFunction = fn;
            }
            catch (XPathException err) {
                return null;
            }
        }
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 155;
    }
}

