/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.Whitespace;

public abstract class AbstractTraceListener
implements TraceListener {
    private int indent = 0;
    private Logger out = new StandardLogger();
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    public CodeInjector getCodeInjector() {
        return new TraceCodeInjector();
    }

    public void open(Controller controller) {
        this.out.info("<trace saxon-version=\"" + Version.getProductVersion() + "\" " + this.getOpeningAttributes() + '>');
        ++this.indent;
    }

    protected abstract String getOpeningAttributes();

    public void close() {
        --this.indent;
        this.out.info("</trace>");
    }

    public void enter(InstructionInfo info, XPathContext context) {
        int infotype = info.getConstructType();
        StructuredQName qName = info.getObjectName();
        String tag = this.tag(infotype);
        if (tag == null) {
            return;
        }
        String file = StandardErrorListener.abbreviatePath(info.getSystemId());
        String msg = AbstractTraceListener.spaces(this.indent) + '<' + tag;
        String name = (String)info.getProperty("name");
        if (name != null) {
            msg = msg + " name=\"" + this.escape(name) + '\"';
        } else if (qName != null) {
            msg = msg + " name=\"" + this.escape(qName.getDisplayName()) + '\"';
        }
        Iterator<String> props = info.getProperties();
        while (props.hasNext()) {
            int rcurly;
            String prop = props.next();
            Object val = info.getProperty(prop);
            if (prop.startsWith("{") && (rcurly = prop.indexOf(125)) > 0) {
                prop = prop.substring(rcurly + 1);
            }
            if (val == null || prop.equals("name") || prop.equals("expression")) continue;
            msg = msg + ' ' + prop + "=\"" + this.escape(val.toString()) + '\"';
        }
        msg = msg + " line=\"" + info.getLineNumber() + '\"';
        int col = info.getColumnNumber();
        if (col >= 0) {
            msg = msg + " column=\"" + info.getColumnNumber() + '\"';
        }
        msg = msg + " module=\"" + this.escape(file) + "\">";
        this.out.info(msg);
        ++this.indent;
    }

    public String escape(String in) {
        if (in == null) {
            return "";
        }
        CharSequence collapsed = Whitespace.collapseWhitespace(in);
        FastStringBuffer sb = new FastStringBuffer(collapsed.length() + 10);
        for (int i2 = 0; i2 < collapsed.length(); ++i2) {
            char c = collapsed.charAt(i2);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&#34;");
                continue;
            }
            if (c == '\n') {
                sb.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                sb.append("&#xD;");
                continue;
            }
            if (c == '\t') {
                sb.append("&#x9;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void leave(InstructionInfo info) {
        int infotype = info.getConstructType();
        String tag = this.tag(infotype);
        if (tag == null) {
            return;
        }
        --this.indent;
        this.out.info(AbstractTraceListener.spaces(this.indent) + "</" + tag + '>');
    }

    protected abstract String tag(int var1);

    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo curr = (NodeInfo)item;
            this.out.info(AbstractTraceListener.spaces(this.indent) + "<source node=\"" + Navigator.getPath(curr) + "\" line=\"" + curr.getLineNumber() + "\" file=\"" + StandardErrorListener.abbreviatePath(curr.getSystemId()) + "\">");
        }
        ++this.indent;
    }

    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo) {
            NodeInfo curr = (NodeInfo)item;
            this.out.info(AbstractTraceListener.spaces(this.indent) + "</source><!-- " + Navigator.getPath(curr) + " -->");
        }
    }

    private static String spaces(int n) {
        while (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }

    public void setOutputDestination(Logger stream) {
        this.out = stream;
    }

    public Logger getOutputDestination() {
        return this.out;
    }
}

