/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.IdrefTest;
import net.sf.saxon.pattern.PathFinder;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManager {
    private static final Map<AtomicMatchKey, List<NodeInfo>> underConstruction = new HashMap<AtomicMatchKey, List<NodeInfo>>();
    private HashMap<StructuredQName, KeyDefinitionSet> keyMap = new HashMap(10);
    private transient WeakHashMap<DocumentInfo, WeakReference<HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>>>> docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration config) {
        this.registerIdrefKey(config);
    }

    private void registerIdrefKey(Configuration config) {
        IdrefTest idref = IdrefTest.getInstance();
        StringFn sf = (StringFn)SystemFunctionCall.makeSystemFunction("string", new Expression[]{new ContextItemExpression()});
        StringLiteral regex = new StringLiteral("\\s+", null);
        Tokenize use = (Tokenize)SystemFunctionCall.makeSystemFunction("tokenize", new Expression[]{sf, regex});
        KeyDefinition key = new KeyDefinition(idref, use, null, null);
        key.setPackageData(null);
        key.setIndexedItemType(BuiltInAtomicType.STRING);
        try {
            this.addKeyDefinition(StandardNames.getStructuredQName(562), key, true, config);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public void preRegisterKeyDefinition(StructuredQName keyName) {
        KeyDefinitionSet keySet = this.keyMap.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyMap.size());
            this.keyMap.put(keyName, keySet);
        }
    }

    public void addKeyDefinition(StructuredQName keyName, KeyDefinition keydef, boolean reusable, Configuration config) throws XPathException {
        boolean backwardsCompatible;
        KeyDefinitionSet keySet = this.keyMap.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyMap.size());
            this.keyMap.put(keyName, keySet);
        }
        keySet.addKeyDefinition(keydef);
        if (!reusable) {
            keySet.setReusable(false);
        }
        if (backwardsCompatible = keySet.isBackwardsCompatible()) {
            List<KeyDefinition> v = keySet.getKeyDefinitions();
            for (KeyDefinition kd : v) {
                kd.setBackwardsCompatible(true);
                if (kd.getBody().getItemType().equals(BuiltInAtomicType.STRING)) continue;
                AtomicSequenceConverter exp = new AtomicSequenceConverter(kd.getBody(), BuiltInAtomicType.STRING);
                exp.allocateConverter(config, false);
                kd.setBody(exp);
            }
        }
    }

    public KeyDefinitionSet getKeyDefinitionSet(StructuredQName qName) {
        return this.keyMap.get(qName);
    }

    public KeyDefinitionSet findKeyDefinition(PathFinder finder, Expression use, String collationName) {
        for (KeyDefinitionSet keySet : this.keyMap.values()) {
            if (keySet.keyDefinitions.size() != 1) continue;
            for (KeyDefinition keyDef : keySet.getKeyDefinitions()) {
                if (!keyDef.getMatch().equals(finder) || !keyDef.getUse().equals(use) || !keyDef.getCollationName().equals(collationName)) continue;
                return keySet;
            }
        }
        return null;
    }

    private synchronized Map<AtomicMatchKey, List<NodeInfo>> buildIndex(KeyDefinitionSet keySet, BuiltInAtomicType itemType, Set<BuiltInAtomicType> foundItemTypes, DocumentInfo doc, XPathContext context) throws XPathException {
        List<KeyDefinition> definitions = keySet.getKeyDefinitions();
        TreeMap<AtomicMatchKey, List<NodeInfo>> index = keySet.isRangeKey() ? new TreeMap() : new HashMap(100);
        for (int k = 0; k < definitions.size(); ++k) {
            this.constructIndex(doc, index, definitions.get(k), itemType, foundItemTypes, context, k == 0);
        }
        return index;
    }

    private void constructIndex(DocumentInfo doc, Map<AtomicMatchKey, List<NodeInfo>> index, KeyDefinition keydef, BuiltInAtomicType soughtItemType, Set<BuiltInAtomicType> foundItemTypes, XPathContext context, boolean isFirst) throws XPathException {
        Item item;
        PatternFinder match = keydef.getMatch();
        XPathContextMajor xc = context.newContext();
        xc.setOrigin(keydef);
        xc.setCurrentComponent(keydef.getDeclaringComponent());
        xc.setTemporaryOutputState(165);
        SlotManager map = keydef.getStackFrameMap();
        if (map != null) {
            xc.openStackFrame(map);
        }
        SequenceIterator iter = match.selectNodes(doc, xc);
        while ((item = iter.next()) != null) {
            this.processKeyNode((NodeInfo)item, soughtItemType, foundItemTypes, keydef, index, xc, isFirst);
        }
    }

    private void processKeyNode(NodeInfo curr, BuiltInAtomicType soughtItemType, Set<BuiltInAtomicType> foundItemTypes, KeyDefinition keydef, Map<AtomicMatchKey, List<NodeInfo>> index, XPathContext xc, boolean isFirst) throws XPathException {
        AtomicValue item;
        ManualIterator si = new ManualIterator(curr);
        xc.setCurrentIterator(si);
        StringCollator collation = keydef.getCollation();
        ConversionRules rules = xc.getConfiguration().getConversionRules();
        int implicitTimezone = xc.getImplicitTimezone();
        Expression use = keydef.getUse();
        SequenceIterator useval = use.iterate(xc);
        while ((item = (AtomicValue)useval.next()) != null) {
            AtomicMatchKey val;
            BuiltInAtomicType actualItemType = item.getPrimitiveType();
            if (foundItemTypes != null) {
                foundItemTypes.add(actualItemType);
            }
            if (!Type.isGuaranteedComparable(actualItemType, soughtItemType, false)) {
                if (keydef.isStrictComparison()) {
                    XPathException de = new XPathException("Cannot compare " + soughtItemType + " to " + actualItemType + " using 'eq'");
                    de.setErrorCode("XPTY0004");
                    throw de;
                }
                if (keydef.isConvertUntypedToOther() && actualItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    item = Converter.convert(item, soughtItemType, rules).asAtomic();
                } else if (!keydef.isConvertUntypedToOther() || !soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) continue;
            }
            if (soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || soughtItemType.equals(BuiltInAtomicType.STRING) || soughtItemType.equals(BuiltInAtomicType.ANY_URI)) {
                val = collation == null ? new CodepointMatchKey(item.getStringValue()) : collation.getCollationKey(item.getStringValue());
            } else {
                if (item.isNaN()) break;
                try {
                    AtomicValue av = Converter.convert(item, soughtItemType, rules).asAtomic();
                    val = av.getXPathComparable(false, collation, implicitTimezone);
                }
                catch (XPathException err) {
                    break;
                }
            }
            List<NodeInfo> nodes = index.get(val);
            if (nodes == null) {
                nodes = new ArrayList<NodeInfo>(4);
                index.put(val, nodes);
                nodes.add(curr);
                continue;
            }
            if (isFirst) {
                if (nodes.get(nodes.size() - 1) == curr) continue;
                nodes.add(curr);
                continue;
            }
            LocalOrderComparer comparer = LocalOrderComparer.getInstance();
            boolean found = false;
            for (int i2 = nodes.size() - 1; i2 >= 0; --i2) {
                int d = comparer.compare(curr, nodes.get(i2));
                if (d < 0) continue;
                if (d != 0) {
                    nodes.add(i2 + 1, curr);
                }
                found = true;
                break;
            }
            if (found) continue;
            nodes.add(0, curr);
        }
    }

    public SequenceIterator selectByKey(KeyDefinitionSet keySet, DocumentInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        HashMap indexList;
        if (soughtValue == null) {
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        List<KeyDefinition> definitions = keySet.getKeyDefinitions();
        KeyDefinition definition = definitions.get(0);
        StringCollator collation = definition.getCollation();
        if (keySet.isBackwardsCompatible()) {
            ConversionRules rules = context.getConfiguration().getConversionRules();
            soughtValue = Converter.convert(soughtValue, BuiltInAtomicType.STRING, rules).asAtomic();
        } else {
            BuiltInAtomicType itemType = soughtValue.getPrimitiveType();
            if (itemType.equals(BuiltInAtomicType.INTEGER) || itemType.equals(BuiltInAtomicType.DECIMAL) || itemType.equals(BuiltInAtomicType.FLOAT)) {
                soughtValue = new DoubleValue(((NumericValue)soughtValue).getDoubleValue());
            }
        }
        HashSet foundItemTypes = null;
        AtomicValue value = soughtValue;
        if (soughtValue instanceof UntypedAtomicValue && definition.isConvertUntypedToOther()) {
            BuiltInAtomicType useType = definition.getIndexedItemType();
            if (useType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                foundItemTypes = new HashSet(10);
                useType = BuiltInAtomicType.STRING;
            }
            ConversionRules rules = context.getConfiguration().getConversionRules();
            value = Converter.convert(soughtValue, useType, rules).asAtomic();
        }
        int keySetNumber = keySet.getKeySetNumber();
        BuiltInAtomicType itemType = value.getPrimitiveType();
        Map<AtomicMatchKey, List<NodeInfo>> index = this.obtainIndex(keySet, doc, context, foundItemTypes, itemType);
        if (foundItemTypes == null) {
            List<NodeInfo> nodes = index.get(KeyManager.getCollationKey(value, itemType, collation, context));
            if (nodes == null) {
                return EmptyIterator.emptyIterator();
            }
            return new ListIterator(nodes);
        }
        LookaheadIterator result = null;
        WeakReference<HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>>> ref = this.docIndexes.get(doc);
        if (ref != null && (indexList = (HashMap)ref.get()) != null) {
            Iterator i$ = indexList.keySet().iterator();
            while (i$.hasNext()) {
                ConversionRules rules;
                List<NodeInfo> nodes;
                long key = (Long)i$.next();
                if (key >> 32 != (long)keySetNumber) continue;
                int typefp = (int)key;
                BuiltInAtomicType type = (BuiltInAtomicType)BuiltInType.getSchemaType(typefp);
                Map<AtomicMatchKey, List<NodeInfo>> index2 = this.getSharedIndex(doc, keySetNumber, type);
                if (index2 == underConstruction) {
                    XPathException de = new XPathException("Key definition is circular");
                    de.setXPathContext(context);
                    de.setErrorCode("XTDE0640");
                    throw de;
                }
                if (index2.isEmpty() || (nodes = index2.get(KeyManager.getCollationKey(value = Converter.convert(soughtValue, type, rules = context.getConfiguration().getConversionRules()).asAtomic(), type, collation, context))) == null) continue;
                if (result == null) {
                    result = new ListIterator(nodes);
                    continue;
                }
                result = new UnionEnumeration(result, new ListIterator(nodes), LocalOrderComparer.getInstance());
            }
        }
        if (result == null) {
            return EmptyIterator.emptyIterator();
        }
        return result;
    }

    public Map<AtomicMatchKey, List<NodeInfo>> obtainIndex(KeyDefinitionSet keySet, DocumentInfo doc, XPathContext context, HashSet<BuiltInAtomicType> foundItemTypes, BuiltInAtomicType itemType) throws XPathException {
        if (keySet.isReusable()) {
            return this.obtainSharedIndex(keySet, doc, context, foundItemTypes, itemType);
        }
        return this.obtainLocalIndex(keySet, doc, context, foundItemTypes, itemType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AtomicMatchKey, List<NodeInfo>> obtainSharedIndex(KeyDefinitionSet keySet, DocumentInfo doc, XPathContext context, HashSet<BuiltInAtomicType> foundItemTypes, BuiltInAtomicType itemType) throws XPathException {
        Map<AtomicMatchKey, List<NodeInfo>> index;
        int keySetNumber = keySet.getKeySetNumber();
        DocumentInfo documentInfo = doc;
        synchronized (documentInfo) {
            index = this.getSharedIndex(doc, keySetNumber, itemType);
            if (index == underConstruction) {
                XPathException de = new XPathException("Key definition is circular");
                de.setXPathContext(context);
                de.setErrorCode("XTDE0640");
                throw de;
            }
            if (index == null) {
                this.putSharedIndex(doc, keySetNumber, itemType, underConstruction, context);
                index = this.buildIndex(keySet, itemType, foundItemTypes, doc, context);
                this.putSharedIndex(doc, keySetNumber, itemType, index, context);
                if (foundItemTypes != null) {
                    for (BuiltInAtomicType t : foundItemTypes) {
                        if (t.equals(BuiltInAtomicType.STRING)) continue;
                        this.putSharedIndex(doc, keySetNumber, t, underConstruction, context);
                        index = this.buildIndex(keySet, t, null, doc, context);
                        this.putSharedIndex(doc, keySetNumber, t, index, context);
                    }
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AtomicMatchKey, List<NodeInfo>> obtainLocalIndex(KeyDefinitionSet keySet, DocumentInfo doc, XPathContext context, HashSet<BuiltInAtomicType> foundItemTypes, BuiltInAtomicType itemType) throws XPathException {
        Map<AtomicMatchKey, List<NodeInfo>> index;
        int keySetNumber = keySet.getKeySetNumber();
        DocumentInfo documentInfo = doc;
        synchronized (documentInfo) {
            index = this.getLocalIndex(doc, keySetNumber, itemType, context);
            if (index == underConstruction) {
                XPathException de = new XPathException("Key definition is circular");
                de.setXPathContext(context);
                de.setErrorCode("XTDE0640");
                throw de;
            }
            if (index == null) {
                this.putLocalIndex(doc, keySetNumber, itemType, underConstruction, context);
                index = this.buildIndex(keySet, itemType, foundItemTypes, doc, context);
                this.putLocalIndex(doc, keySetNumber, itemType, index, context);
                if (foundItemTypes != null) {
                    for (BuiltInAtomicType t : foundItemTypes) {
                        if (t.equals(BuiltInAtomicType.STRING)) continue;
                        this.putLocalIndex(doc, keySetNumber, t, underConstruction, context);
                        index = this.buildIndex(keySet, t, null, doc, context);
                        this.putLocalIndex(doc, keySetNumber, t, index, context);
                    }
                }
            }
        }
        return index;
    }

    private static AtomicMatchKey getCollationKey(AtomicValue value, BuiltInAtomicType itemType, StringCollator collation, XPathContext context) throws XPathException {
        if (itemType.equals(BuiltInAtomicType.STRING) || itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || itemType.equals(BuiltInAtomicType.ANY_URI)) {
            if (collation == null) {
                return new CodepointMatchKey(value.getStringValue());
            }
            return collation.getCollationKey(value.getStringValue());
        }
        return value.getXPathComparable(false, collation, context.getImplicitTimezone());
    }

    private synchronized void putSharedIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType, Map<AtomicMatchKey, List<NodeInfo>> index, XPathContext context) {
        HashMap indexList;
        WeakReference<HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>>> indexRef;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((indexRef = this.docIndexes.get(doc)) == null || indexRef.get() == null) {
            indexList = new HashMap(10);
            Controller controller = context.getController();
            if (controller.getDocumentPool().contains(doc)) {
                context.getController().setUserData(doc, "saxon:key-index-list", indexList);
            } else {
                doc.setUserData("saxon:key-index-list", indexList);
            }
            this.docIndexes.put(doc, new WeakReference<HashMap>(indexList));
        } else {
            indexList = (HashMap)indexRef.get();
        }
        indexList.put((long)keyFingerprint << 32 | (long)itemType.getFingerprint(), index);
    }

    private synchronized void putLocalIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType, Map<AtomicMatchKey, List<NodeInfo>> index, XPathContext context) {
        Controller controller = context.getController();
        HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>> docIndexes = (HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>>)controller.getUserData(doc, "saxon:unshared-key-index-list");
        if (docIndexes == null) {
            docIndexes = new HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>>();
        }
        long indexId = (long)keyFingerprint << 32 | (long)itemType.getFingerprint();
        docIndexes.put(indexId, index);
    }

    private synchronized Map<AtomicMatchKey, List<NodeInfo>> getSharedIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType) {
        WeakReference<HashMap<Long, Map<AtomicMatchKey, List<NodeInfo>>>> ref;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((ref = this.docIndexes.get(doc)) == null) {
            return null;
        }
        HashMap indexList = (HashMap)ref.get();
        if (indexList == null) {
            return null;
        }
        return (Map)indexList.get((long)keyFingerprint << 32 | (long)itemType.getFingerprint());
    }

    private synchronized Map<AtomicMatchKey, List<NodeInfo>> getLocalIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType, XPathContext context) {
        Controller controller = context.getController();
        Map docIndexes = (Map)controller.getUserData(doc, "saxon:unshared-key-index-list");
        if (docIndexes == null) {
            return null;
        }
        long indexId = (long)keyFingerprint << 32 | (long)itemType.getFingerprint();
        return (Map)docIndexes.get(indexId);
    }

    public synchronized void clearDocumentIndexes(DocumentInfo doc) {
        this.docIndexes.remove(doc);
    }

    public Collection<KeyDefinitionSet> getAllKeyDefinitionSets() {
        return this.keyMap.values();
    }

    public int getNumberOfKeyDefinitions() {
        return this.keyMap.size();
    }

    public void explainKeys(ExpressionPresenter out) {
        if (this.keyMap.size() < 2) {
            return;
        }
        out.startElement("keys");
        for (Map.Entry<StructuredQName, KeyDefinitionSet> e : this.keyMap.entrySet()) {
            StructuredQName qName = e.getKey();
            List<KeyDefinition> list = e.getValue().getKeyDefinitions();
            for (KeyDefinition kd : list) {
                out.startElement("key");
                out.emitAttribute("name", qName.getDisplayName());
                out.emitAttribute("match", kd.getMatch().toString());
                if (kd.isRangeKey()) {
                    out.emitAttribute("range", "true");
                }
                kd.getUse().explain(out);
                out.endElement();
            }
        }
        out.endElement();
    }
}

