/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BooleanExpressionPattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.BuiltInRuleSet;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.TextOnlyCopyRuleSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mode {
    public static final int UNNAMED_MODE = -1;
    public static final int NAMED_MODE = -3;
    public static final int ACCUMULATOR = -5;
    public static final StructuredQName OMNI_MODE = new StructuredQName("saxon", "http://saxon.sf.net/", "_omniMode");
    public static final StructuredQName UNNAMED_MODE_NAME = new StructuredQName("saxon", "http://saxon.sf.net/", "_defaultMode");
    private BuiltInRuleSet builtInRuleSet = TextOnlyCopyRuleSet.getInstance();
    private Rule genericRuleChain = null;
    private Rule atomicValueRuleChain = null;
    private Rule functionItemRuleChain = null;
    private Rule documentRuleChain = null;
    private Rule textRuleChain = null;
    private Rule commentRuleChain = null;
    private Rule processingInstructionRuleChain = null;
    private Rule namespaceRuleChain = null;
    private Rule unnamedElementRuleChain = null;
    private Rule unnamedAttributeRuleChain = null;
    private IntHashMap<Rule> namedElementRuleChains = new IntHashMap(32);
    private IntHashMap<Rule> namedAttributeRuleChains = new IntHashMap(8);
    private Rule mostRecentRule;
    private int mostRecentModuleHash;
    private boolean isDefault;
    private boolean streamable;
    private boolean hasRules = false;
    private StructuredQName modeName;
    private int stackFrameSlotsNeeded = 0;
    private int recoveryPolicy = 1;
    private boolean mustBeTyped = false;
    private boolean mustBeUntyped = false;
    private Map<String, Integer> explicitPropertyPrecedences = new HashMap<String, Integer>();
    private Map<String, String> explicitPropertyValues = new HashMap<String, String>();

    public Mode(int usage, StructuredQName modeName) {
        this.isDefault = usage == -1;
        this.modeName = modeName;
    }

    public Mode(Mode omniMode, StructuredQName modeName) {
        this.isDefault = false;
        this.modeName = modeName;
        if (omniMode != null) {
            Rule r;
            int fp;
            this.genericRuleChain = omniMode.genericRuleChain == null ? null : new Rule(omniMode.genericRuleChain);
            this.documentRuleChain = omniMode.documentRuleChain == null ? null : new Rule(omniMode.documentRuleChain);
            this.textRuleChain = omniMode.textRuleChain == null ? null : new Rule(omniMode.textRuleChain);
            this.commentRuleChain = omniMode.commentRuleChain == null ? null : new Rule(omniMode.commentRuleChain);
            this.processingInstructionRuleChain = omniMode.processingInstructionRuleChain == null ? null : new Rule(omniMode.processingInstructionRuleChain);
            this.namespaceRuleChain = omniMode.namespaceRuleChain == null ? null : new Rule(omniMode.namespaceRuleChain);
            this.unnamedElementRuleChain = omniMode.unnamedElementRuleChain == null ? null : new Rule(omniMode.unnamedElementRuleChain);
            this.unnamedAttributeRuleChain = omniMode.unnamedAttributeRuleChain == null ? null : new Rule(omniMode.unnamedAttributeRuleChain);
            this.namedElementRuleChains = new IntHashMap(omniMode.namedElementRuleChains.size());
            IntIterator ii = omniMode.namedElementRuleChains.keyIterator();
            while (ii.hasNext()) {
                fp = ii.next();
                r = omniMode.namedElementRuleChains.get(fp);
                this.namedElementRuleChains.put(fp, new Rule(r));
            }
            ii = omniMode.namedAttributeRuleChains.keyIterator();
            while (ii.hasNext()) {
                fp = ii.next();
                r = omniMode.namedAttributeRuleChains.get(fp);
                this.namedAttributeRuleChains.put(fp, new Rule(r));
            }
            this.mostRecentRule = omniMode.mostRecentRule;
            this.mostRecentModuleHash = omniMode.mostRecentModuleHash;
        }
    }

    public void setBuiltInRuleSet(BuiltInRuleSet defaultRules) {
        this.builtInRuleSet = defaultRules;
        this.hasRules = true;
    }

    public BuiltInRuleSet getBuiltInRuleSet() {
        return this.builtInRuleSet;
    }

    public boolean isDefaultMode() {
        return this.isDefault;
    }

    public StructuredQName getModeName() {
        return this.modeName;
    }

    public String getModeTitle() {
        return this.isDefaultMode() ? "The unnamed mode" : "Mode" + this.getModeName().getDisplayName();
    }

    public boolean isEmpty() {
        return !this.hasRules;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setStreamable(boolean streamable) {
        this.streamable = streamable;
    }

    public boolean isDeclaredStreamable() {
        return this.streamable;
    }

    public void setExplicitProperty(String name, String value, int precedence) {
        Integer p = this.explicitPropertyPrecedences.get(name);
        if (p != null) {
            String v;
            if (p != null && p < precedence) {
                this.explicitPropertyPrecedences.put(name, precedence);
                this.explicitPropertyValues.put(name, value);
            } else if (p != null && p == precedence && (v = this.explicitPropertyValues.get(name)) != null & !v.equals(value)) {
                this.explicitPropertyValues.put(name, "##conflict##");
            }
        } else {
            this.explicitPropertyPrecedences.put(name, precedence);
            this.explicitPropertyValues.put(name, value);
        }
    }

    public String getPropertyValue(String name) {
        return this.explicitPropertyValues.get(name);
    }

    public Set<String> getExplicitNamespaces(NamePool pool) {
        HashSet<String> namespaces = new HashSet<String>();
        IntIterator ii = this.namedElementRuleChains.keyIterator();
        while (ii.hasNext()) {
            int fp = ii.next();
            namespaces.add(pool.getURI(fp));
        }
        return namespaces;
    }

    public void addRule(Pattern pattern, RuleTarget action, StylesheetModule module, double priority, boolean explicitMode) {
        if (explicitMode) {
            this.hasRules = true;
        }
        if (pattern.getItemType() instanceof ErrorType) {
            return;
        }
        int moduleHash = module.hashCode();
        int sequence = this.mostRecentRule == null ? 0 : (action == this.mostRecentRule.getAction() && moduleHash == this.mostRecentModuleHash ? this.mostRecentRule.getSequence() : this.mostRecentRule.getSequence() + 1);
        int precedence = module.getPrecedence();
        int minImportPrecedence = module.getMinImportPrecedence();
        Rule newRule = new Rule(pattern, action, precedence, minImportPrecedence, priority, sequence);
        if (pattern instanceof NodeTestPattern) {
            int kind;
            ItemType test = pattern.getItemType();
            if (test instanceof AnyNodeTest) {
                newRule.setAlwaysMatches(true);
            } else if (test instanceof NodeKindTest) {
                newRule.setAlwaysMatches(true);
            } else if (test instanceof NameTest && ((kind = test.getPrimitiveType()) == 1 || kind == 2)) {
                newRule.setAlwaysMatches(true);
            }
        }
        this.mostRecentRule = newRule;
        this.mostRecentModuleHash = moduleHash;
        int kind = pattern.getNodeKind();
        switch (kind) {
            case 1: {
                int fp = pattern.getFingerprint();
                if (fp == -1) {
                    this.unnamedElementRuleChain = this.addRuleToList(newRule, this.unnamedElementRuleChain);
                    break;
                }
                Rule chain = this.namedElementRuleChains.get(fp);
                this.namedElementRuleChains.put(fp, this.addRuleToList(newRule, chain));
                break;
            }
            case 2: {
                int fp = pattern.getFingerprint();
                if (fp == -1) {
                    this.unnamedAttributeRuleChain = this.addRuleToList(newRule, this.unnamedAttributeRuleChain);
                    break;
                }
                Rule chain = this.namedAttributeRuleChains.get(fp);
                this.namedAttributeRuleChains.put(fp, this.addRuleToList(newRule, chain));
                break;
            }
            case 0: {
                this.genericRuleChain = this.addRuleToList(newRule, this.genericRuleChain);
                break;
            }
            case 9: {
                this.documentRuleChain = this.addRuleToList(newRule, this.documentRuleChain);
                break;
            }
            case 3: {
                this.textRuleChain = this.addRuleToList(newRule, this.textRuleChain);
                break;
            }
            case 8: {
                this.commentRuleChain = this.addRuleToList(newRule, this.commentRuleChain);
                break;
            }
            case 7: {
                this.processingInstructionRuleChain = this.addRuleToList(newRule, this.processingInstructionRuleChain);
                break;
            }
            case 13: {
                this.namespaceRuleChain = this.addRuleToList(newRule, this.namespaceRuleChain);
                break;
            }
            default: {
                if (pattern instanceof NodeTestPattern || pattern instanceof PatternWithPredicate) {
                    ItemType type = pattern.getItemType();
                    if (type instanceof AtomicType) {
                        this.atomicValueRuleChain = this.addRuleToList(newRule, this.atomicValueRuleChain);
                        break;
                    }
                    if (type instanceof FunctionItemType) {
                        this.functionItemRuleChain = this.addRuleToList(newRule, this.functionItemRuleChain);
                        break;
                    }
                    throw new UnsupportedOperationException("XSLT 3.0 '~' syntax not recognized with node type or external object types");
                }
                if (pattern instanceof BooleanExpressionPattern) {
                    this.genericRuleChain = this.addRuleToList(newRule, this.genericRuleChain);
                    break;
                }
                throw new UnsupportedOperationException("Unrecognized pattern");
            }
        }
    }

    private Rule addRuleToList(Rule newRule, Rule list) {
        Rule rule;
        if (list == null) {
            return newRule;
        }
        int precedence = newRule.getPrecedence();
        double priority = newRule.getPriority();
        Rule prev = null;
        for (rule = list; rule != null; rule = rule.getNext()) {
            if (rule.getPrecedence() < precedence || rule.getPrecedence() == precedence && rule.getPriority() <= priority) {
                newRule.setNext(rule);
                if (prev == null) {
                    return newRule;
                }
                prev.setNext(newRule);
                break;
            }
            prev = rule;
        }
        if (rule == null) {
            prev.setNext(newRule);
            newRule.setNext(null);
        }
        return list;
    }

    public void allocatePatternSlots(int slots) {
        this.stackFrameSlotsNeeded = Math.max(this.stackFrameSlotsNeeded, slots);
    }

    private XPathContext makeNewContext(XPathContext context) {
        XPathContextMajor c2 = context.newContext();
        c2.setOriginatingConstructType(2000);
        c2.openStackFrame(this.stackFrameSlotsNeeded);
        return c2;
    }

    public Rule getRule(Item item, XPathContext context) throws XPathException {
        if (this.stackFrameSlotsNeeded > 0) {
            context = this.makeNewContext(context);
        }
        Rule bestRule = null;
        if (item instanceof NodeInfo) {
            Rule unnamedNodeChain;
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    unnamedNodeChain = this.documentRuleChain;
                    break;
                }
                case 1: {
                    unnamedNodeChain = this.unnamedElementRuleChain;
                    Rule namedNodeChain = this.namedElementRuleChains.get(node.getFingerprint());
                    if (namedNodeChain == null) break;
                    bestRule = this.searchRuleChain(node, context, null, namedNodeChain);
                    break;
                }
                case 2: {
                    unnamedNodeChain = this.unnamedAttributeRuleChain;
                    Rule namedNodeChain = this.namedAttributeRuleChains.get(node.getFingerprint());
                    if (namedNodeChain == null) break;
                    bestRule = this.searchRuleChain(node, context, null, namedNodeChain);
                    break;
                }
                case 3: {
                    unnamedNodeChain = this.textRuleChain;
                    break;
                }
                case 8: {
                    unnamedNodeChain = this.commentRuleChain;
                    break;
                }
                case 7: {
                    unnamedNodeChain = this.processingInstructionRuleChain;
                    break;
                }
                case 13: {
                    unnamedNodeChain = this.namespaceRuleChain;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown node kind");
                }
            }
            if (unnamedNodeChain != null) {
                bestRule = this.searchRuleChain(node, context, bestRule, unnamedNodeChain);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(node, context, bestRule, this.genericRuleChain);
            }
        } else if (item instanceof AtomicValue) {
            if (this.atomicValueRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.atomicValueRuleChain);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain);
            }
        } else if (item instanceof FunctionItem) {
            if (this.functionItemRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.functionItemRuleChain);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain);
            }
        }
        return bestRule;
    }

    private Rule searchRuleChain(Item item, XPathContext context, Rule bestRule, Rule head) throws XPathException {
        while (!(context instanceof XPathContextMajor)) {
            context = context.getCaller();
        }
        while (head != null) {
            if (bestRule != null) {
                int rank = head.compareRank(bestRule);
                if (rank < 0) break;
                if (rank == 0) {
                    if (head.isAlwaysMatches() || head.matches(item, (XPathContextMajor)context)) {
                        this.reportAmbiguity(item, bestRule, head, context);
                        bestRule = bestRule.getSequence() > head.getSequence() ? bestRule : head;
                        break;
                    }
                } else if (head.isAlwaysMatches() || head.matches(item, (XPathContextMajor)context)) {
                    bestRule = head;
                }
            } else if (head.isAlwaysMatches() || head.matches(item, (XPathContextMajor)context)) {
                bestRule = head;
                if (this.recoveryPolicy == 0) break;
            }
            head = head.getNext();
        }
        return bestRule;
    }

    public Rule getRule(Item item, XPathContext context, RuleFilter filter2) throws XPathException {
        if (this.stackFrameSlotsNeeded > 0) {
            context = this.makeNewContext(context);
        }
        Rule bestRule = null;
        if (item instanceof NodeInfo) {
            Rule unnamedNodeChain;
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    unnamedNodeChain = this.documentRuleChain;
                    break;
                }
                case 1: {
                    unnamedNodeChain = this.unnamedElementRuleChain;
                    Rule namedNodeChain = this.namedElementRuleChains.get(node.getFingerprint());
                    bestRule = this.searchRuleChain(item, context, null, namedNodeChain, filter2);
                    break;
                }
                case 2: {
                    unnamedNodeChain = this.unnamedAttributeRuleChain;
                    Rule namedNodeChain = this.namedAttributeRuleChains.get(node.getFingerprint());
                    bestRule = this.searchRuleChain(item, context, null, namedNodeChain, filter2);
                    break;
                }
                case 3: {
                    unnamedNodeChain = this.textRuleChain;
                    break;
                }
                case 8: {
                    unnamedNodeChain = this.commentRuleChain;
                    break;
                }
                case 7: {
                    unnamedNodeChain = this.processingInstructionRuleChain;
                    break;
                }
                case 13: {
                    unnamedNodeChain = this.namespaceRuleChain;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown node kind");
                }
            }
            bestRule = this.searchRuleChain(item, context, bestRule, unnamedNodeChain, filter2);
            return this.searchRuleChain(item, context, bestRule, this.genericRuleChain, filter2);
        }
        if (item instanceof AtomicValue) {
            if (this.atomicValueRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.atomicValueRuleChain, filter2);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain, filter2);
            }
            return bestRule;
        }
        if (item instanceof FunctionItem) {
            if (this.functionItemRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.functionItemRuleChain, filter2);
            }
            if (this.genericRuleChain != null) {
                bestRule = this.searchRuleChain(item, context, bestRule, this.genericRuleChain, filter2);
            }
            return bestRule;
        }
        return null;
    }

    private Rule searchRuleChain(Item item, XPathContext context, Rule bestRule, Rule head, RuleFilter filter2) throws XPathException {
        while (!(context instanceof XPathContextMajor)) {
            context = context.getCaller();
        }
        while (head != null) {
            if (filter2.testRule(head)) {
                if (bestRule != null) {
                    int rank = head.compareRank(bestRule);
                    if (rank < 0) break;
                    if (rank == 0) {
                        if (head.isAlwaysMatches() || head.matches(item, (XPathContextMajor)context)) {
                            this.reportAmbiguity(item, bestRule, head, context);
                            bestRule = bestRule.getSequence() > head.getSequence() ? bestRule : head;
                            break;
                        }
                    } else if (head.isAlwaysMatches() || head.matches(item, (XPathContextMajor)context)) {
                        bestRule = head;
                    }
                } else if (head.isAlwaysMatches() || head.matches(item, (XPathContextMajor)context)) {
                    bestRule = head;
                    if (this.recoveryPolicy == 0) break;
                }
            }
            head = head.getNext();
        }
        return bestRule;
    }

    public Rule getRule(Item item, final int min2, final int max, XPathContext context) throws XPathException {
        RuleFilter filter2 = new RuleFilter(){

            public boolean testRule(Rule r) {
                int p = r.getPrecedence();
                return p >= min2 && p <= max;
            }
        };
        return this.getRule(item, context, filter2);
    }

    public Rule getNextMatchRule(Item item, final Rule currentRule, XPathContext context) throws XPathException {
        RuleFilter filter2 = new RuleFilter(){

            public boolean testRule(Rule r) {
                int comp = r.compareRank(currentRule);
                return comp < 0 || comp == 0 && r.getSequence() < currentRule.getSequence();
            }
        };
        return this.getRule(item, context, filter2);
    }

    private void reportAmbiguity(Item item, Rule r1, Rule r2, XPathContext c) throws XPathException {
        if (r1.getAction() == r2.getAction() && r1.getSequence() == r2.getSequence()) {
            return;
        }
        String errorCode = "XTRE0540";
        String path = item instanceof NodeInfo ? Navigator.getPath((NodeInfo)item) : item.getStringValue();
        Pattern pat1 = r1.getPattern();
        Pattern pat2 = r2.getPattern();
        String message = r1.getAction() == r2.getAction() ? "Ambiguous rule match for " + path + ". " + "Matches \"" + Mode.showPattern(pat1) + "\" on line " + pat1.getLineNumber() + " of " + pat1.getSystemId() + ", a rule which appears in the stylesheet more than once, because the containing module was included more than once" : "Ambiguous rule match for " + path + '\n' + "Matches both \"" + Mode.showPattern(pat1) + "\" on line " + pat1.getLineNumber() + " of " + pat1.getSystemId() + "\nand \"" + Mode.showPattern(pat2) + "\" on line " + pat2.getLineNumber() + " of " + pat2.getSystemId();
        XPathException err = new XPathException(message, errorCode);
        if (this.recoveryPolicy == 2) {
            throw err;
        }
        c.getController().recoverableError(err);
    }

    private static String showPattern(Pattern p) {
        return Whitespace.collapseWhitespace(p.toString()).toString();
    }

    public void processRules(RuleAction action) throws XPathException {
        Rule r;
        this.processRuleChain(this.documentRuleChain, action);
        this.processRuleChain(this.unnamedElementRuleChain, action);
        IntIterator ii = this.namedElementRuleChains.keyIterator();
        while (ii.hasNext()) {
            r = this.namedElementRuleChains.get(ii.next());
            this.processRuleChain(r, action);
        }
        this.processRuleChain(this.unnamedAttributeRuleChain, action);
        ii = this.namedAttributeRuleChains.keyIterator();
        while (ii.hasNext()) {
            r = this.namedAttributeRuleChains.get(ii.next());
            this.processRuleChain(r, action);
        }
        this.processRuleChain(this.textRuleChain, action);
        this.processRuleChain(this.commentRuleChain, action);
        this.processRuleChain(this.processingInstructionRuleChain, action);
        this.processRuleChain(this.namespaceRuleChain, action);
        this.processRuleChain(this.genericRuleChain, action);
        this.processRuleChain(this.atomicValueRuleChain, action);
        this.processRuleChain(this.functionItemRuleChain, action);
    }

    private void processRuleChain(Rule r, RuleAction action) throws XPathException {
        while (r != null) {
            action.processRule(r);
            r = r.getNext();
        }
    }

    public void invertStreamableTemplates() throws XPathException {
    }

    public void explainTemplateRules(final ExpressionPresenter presenter) {
        RuleAction action = new RuleAction(){

            public void processRule(Rule r) {
                RuleTarget target = r.getAction();
                Template template = null;
                if (target instanceof Template) {
                    template = (Template)target;
                }
                int s2 = presenter.startElement("templateRule");
                presenter.emitAttribute("match", r.getPattern().toString());
                presenter.emitAttribute("precedence", r.getPrecedence() + "");
                presenter.emitAttribute("priority", r.getPriority() + "");
                target.explain(presenter);
                int e = presenter.endElement();
                if (s2 != e) {
                    throw new IllegalStateException("tree unbalanced in template at line " + (template != null ? template.getLineNumber() + " of " + template.getSystemId() : ""));
                }
            }
        };
        try {
            this.processRules(action);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public void computeRankings() throws XPathException {
        for (Map.Entry<String, String> entry : this.explicitPropertyValues.entrySet()) {
            if (!entry.getValue().equals("##conflict##")) continue;
            throw new XPathException("There are conflicting values for xsl:mode/@" + entry.getKey() + " at the same import precedence", "XTSE0545");
        }
        String typed = this.explicitPropertyValues.get("typed");
        this.mustBeTyped = "yes".equals(typed) || "strict".equals(typed) || "lax".equals(typed);
        this.mustBeUntyped = "no".equals(typed);
        final RuleSorter sorter = new RuleSorter();
        RuleAction addToSorter = new RuleAction(){

            public void processRule(Rule r) {
                sorter.addRule(r);
            }
        };
        this.processRules(addToSorter);
        sorter.allocateRanks();
    }

    public TailCall applyTemplates(ParameterSet parameters, ParameterSet tunnelParameters, XPathContextMajor context, int locationId) throws XPathException {
        Controller controller = context.getController();
        boolean tracing = controller.isTracing();
        PipelineConfiguration pipe = context.getReceiver().getPipelineConfiguration();
        FocusIterator iterator = context.getCurrentIterator();
        TailCall tc = null;
        TraceListener traceListener = tracing ? controller.getTraceListener() : null;
        boolean lookahead = (iterator.getProperties() & 4) != 0;
        Template previousTemplate = null;
        while (true) {
            int annotation;
            int kind;
            Item item;
            if (tc != null) {
                if (lookahead && !((LookaheadIterator)((Object)iterator)).hasNext()) break;
                while ((tc = tc.processLeavingTail()) != null) {
                }
            }
            if ((item = iterator.next()) == null) break;
            if (this.mustBeTyped) {
                int annotation2;
                int kind2;
                if (!(!(item instanceof NodeInfo) || (kind2 = ((NodeInfo)item).getNodeKind()) != 1 && kind2 != 2 || (annotation2 = ((NodeInfo)item).getTypeAnnotation()) != 630 && annotation2 != 631)) {
                    throw new XPathException(this.getModeTitle() + " requires typed nodes, but the input is untyped", "XTTE3100");
                }
            } else if (this.mustBeUntyped && item instanceof NodeInfo && ((kind = ((NodeInfo)item).getNodeKind()) == 1 || kind == 2) && (annotation = ((NodeInfo)item).getTypeAnnotation()) != 630 && annotation != 631) {
                throw new XPathException(this.getModeTitle() + " requires untyped nodes, but the input is typed", "XTTE3110");
            }
            pipe.pushCurrentAppliedItem(item);
            Rule rule = this.getRule(item, context);
            if (rule == null) {
                this.getBuiltInRuleSet().process(item, parameters, tunnelParameters, context, locationId);
            } else {
                Template template = (Template)rule.getAction();
                if (template != previousTemplate) {
                    previousTemplate = template;
                    context.openStackFrame(template.getStackFrameMap());
                    context.setLocalParameters(parameters);
                    context.setTunnelParameters(tunnelParameters);
                    context.setCurrentComponent(template.getDeclaringComponent());
                }
                context.setCurrentTemplateRule(rule);
                if (tracing) {
                    traceListener.startCurrentItem(item);
                    tc = template.applyLeavingTail(context);
                    if (tc != null) {
                        while ((tc = tc.processLeavingTail()) != null) {
                        }
                    }
                    traceListener.endCurrentItem(item);
                } else {
                    tc = template.applyLeavingTail(context);
                }
            }
            pipe.popCurrentAppliedItem();
        }
        return tc;
    }

    public void allocateAllPatternSlots() throws XPathException {
        final ArrayList<Integer> count = new ArrayList<Integer>(1);
        count.add(0);
        final SlotManager slotManager = new SlotManager();
        RuleAction slotAllocator = new RuleAction(){

            public void processRule(Rule r) throws XPathException {
                int slots = r.getPattern().allocateSlots(slotManager, 0);
                int max = Math.max((Integer)count.get(0), slots);
                count.set(0, max);
            }
        };
        this.processRules(slotAllocator);
        this.stackFrameSlotsNeeded = (Integer)count.get(0);
    }

    public int getStackFrameSlotsNeeded() {
        return this.stackFrameSlotsNeeded;
    }

    private static interface RuleAction {
        public void processRule(Rule var1) throws XPathException;
    }

    private static interface RuleFilter {
        public boolean testRule(Rule var1);
    }

    private static class RuleSorter
    implements Sortable {
        public ArrayList<Rule> rules = new ArrayList(100);

        private RuleSorter() {
        }

        public void addRule(Rule rule) {
            this.rules.add(rule);
        }

        public int compare(int a, int b) {
            return this.rules.get(a).compareComputedRank(this.rules.get(b));
        }

        public void swap(int a, int b) {
            Rule temp = this.rules.get(a);
            this.rules.set(a, this.rules.get(b));
            this.rules.set(b, temp);
        }

        public void allocateRanks() {
            GenericSorter.quickSort(0, this.rules.size(), this);
            int rank = 0;
            for (int i2 = 0; i2 < this.rules.size(); ++i2) {
                if (i2 > 0 && this.rules.get(i2 - 1).compareComputedRank(this.rules.get(i2)) != 0) {
                    ++rank;
                }
                this.rules.get(i2).setRank(rank);
            }
        }
    }
}

